/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigInteger;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;

public class CharacterExpression
extends SQLExpression {
    public CharacterExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public CharacterExpression(JavaTypeMapping mapping, String functionName, List args) {
        super(mapping, functionName, args, null);
    }

    public CharacterExpression(JavaTypeMapping mapping, String functionName, List args, List types) {
        super(mapping, functionName, args, types);
    }

    public BooleanExpression eq(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof StringLiteral) {
            Object value = ((StringLiteral)expr).getValue();
            if (value instanceof String && ((String)value).length() > 1) {
                throw new NucleusUserException("Can't perform equality comparison between a character and a String of more than 1 character (" + value + ") !");
            }
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).eq(expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).ne(expr);
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.lt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).lt(expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.le(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).le(expr);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.gt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).gt(expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.ge(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).ge(expr);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_ADD, ExpressionUtils.getNumericExpression(expr));
        }
        if (expr instanceof NumericExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_ADD, expr);
        }
        return super.add(expr);
    }

    public SQLExpression sub(SQLExpression expr) {
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_SUB, ExpressionUtils.getNumericExpression(expr));
        }
        if (expr instanceof NumericExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_SUB, expr);
        }
        return super.sub(expr);
    }

    public SQLExpression mul(SQLExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_MUL, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_MUL, ExpressionUtils.getNumericExpression(expr));
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).mul(expr);
        }
        return super.mul(expr);
    }

    public SQLExpression div(SQLExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_DIV, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_DIV, ExpressionUtils.getNumericExpression(expr));
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).div(expr);
        }
        return super.div(expr);
    }

    public SQLExpression mod(SQLExpression expr) {
        if (expr instanceof CharacterExpression) {
            return this.stmt.getSQLExpressionFactory().invokeOperation("mod", ExpressionUtils.getNumericExpression(this), ExpressionUtils.getNumericExpression(expr)).encloseInParentheses();
        }
        if (expr instanceof NumericExpression) {
            return this.stmt.getSQLExpressionFactory().invokeOperation("mod", ExpressionUtils.getNumericExpression(this), expr);
        }
        return super.mod(expr);
    }

    public SQLExpression neg() {
        return new NumericExpression(Expression.OP_NEG, ExpressionUtils.getNumericExpression(this));
    }

    public SQLExpression com() {
        return ExpressionUtils.getNumericExpression(this).neg().sub(new IntegerLiteral(this.stmt, this.mapping, BigInteger.ONE, null));
    }

    public BooleanExpression in(SQLExpression expr) {
        return new BooleanExpression(this, Expression.OP_IN, expr);
    }

    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, Character.class.getName(), methodName, this, args);
    }
}

