/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigInteger;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class IntegerLiteral
extends NumericExpression
implements SQLLiteral {
    private final Number value;

    public IntegerLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Number) {
            this.value = (Number)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (parameterName != null) {
            this.st.appendParameter(parameterName, mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    public BooleanExpression eq(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) == 0, null);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(expr, Expression.OP_EQ, literal);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) != 0, null);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(expr, Expression.OP_NOTEQ, literal);
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) < 0, null);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(literal, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) <= 0, null);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(literal, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) > 0, null);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(literal, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) >= 0, null);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()), null);
            return new BooleanExpression(literal, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new NumericExpression(this, Expression.OP_ADD, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).add(new BigInteger(((IntegerLiteral)expr).value.toString())), null);
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).add(new BigInteger("" + v)), null);
        }
        return super.add(expr);
    }

    public SQLExpression sub(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new NumericExpression(this, Expression.OP_SUB, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).subtract(new BigInteger(((IntegerLiteral)expr).value.toString())), null);
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).subtract(new BigInteger("" + v)), null);
        }
        return super.sub(expr);
    }

    public SQLExpression mul(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new NumericExpression(this, Expression.OP_MUL, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).multiply(new BigInteger(((IntegerLiteral)expr).value.toString())), null);
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).multiply(new BigInteger("" + v)), null);
        }
        return super.mul(expr);
    }

    public SQLExpression div(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new NumericExpression(this, Expression.OP_DIV, expr);
        }
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).divide(new BigInteger(((IntegerLiteral)expr).value.toString())), null);
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).divide(new BigInteger("" + v)), null);
        }
        return super.div(expr);
    }

    public SQLExpression mod(SQLExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).mod(new BigInteger(((IntegerLiteral)expr).value.toString())), null);
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).mod(new BigInteger("" + v)), null);
        }
        return super.mod(expr);
    }

    public SQLExpression neg() {
        return new IntegerLiteral(this.stmt, this.mapping, new BigInteger(this.value.toString()).negate(), this.parameterName);
    }

    public Object getValue() {
        return this.value;
    }

    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        this.st.append(String.valueOf(this.value));
    }
}

