/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.JPQLSingleStringParser;
import org.datanucleus.store.Extent;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.query.PersistentIDROF;
import org.datanucleus.store.rdbms.query.legacy.CollectionCandidates;
import org.datanucleus.store.rdbms.query.legacy.JPQLQueryCompiler;
import org.datanucleus.store.rdbms.query.legacy.QueryCompiler;
import org.datanucleus.store.rdbms.query.legacy.QueryResultsMetaData;
import org.datanucleus.store.rdbms.query.legacy.SQLEvaluator;
import org.datanucleus.util.Imports;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPQLQuery
extends AbstractJPQLQuery {
    protected transient QueryExpression queryStmt = null;
    protected transient Queryable candidates = null;
    protected transient String candidateAlias = "this";
    protected transient ResultObjectFactory rof = null;
    protected transient boolean isCompiled = false;
    protected transient QueryResultsMetaData resultMetaData;

    public JPQLQuery(ObjectManager om) {
        this(om, (JPQLQuery)null);
    }

    public JPQLQuery(ObjectManager om, JPQLQuery q) {
        super(om, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(ObjectManager om, String query) {
        super(om);
        new JPQLSingleStringParser((Query)this, query).parse();
    }

    public String getCandidateAlias() {
        return this.candidateAlias;
    }

    public Queryable getCandidates() {
        return this.candidates;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JPQLQuery && super.equals(obj);
    }

    protected void discardCompiled() {
        this.isCompiled = false;
        this.rof = null;
        this.queryStmt = null;
        super.discardCompiled();
    }

    protected boolean isCompiled() {
        return this.isCompiled;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.isCompiled) {
            return;
        }
        try {
            if (forExecute) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021044", (Object)this.getLanguage(), (Object)this.getSingleStringQuery()));
                }
                JPQLQueryCompiler c = new JPQLQueryCompiler(this, this.getParsedImports(), parameterValues);
                this.queryStmt = (QueryExpression)c.compile(4);
                if (this.resultDistinct) {
                    this.queryStmt.setDistinctResults(true);
                }
                this.resultMetaData = c.getResultMetaData();
                this.candidateClass = c.getCandidateClass();
                this.candidateAlias = c.getCandidateAlias();
                this.candidates = c.getCandidates();
                this.resultClass = c.getResultClass();
                this.fromInclNo = c.getRangeFromIncl();
                this.toExclNo = c.getRangeToExcl();
                c.close();
                c = null;
            } else {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021044", (Object)this.getLanguage(), (Object)this.getSingleStringQuery()));
                }
                JPQLQueryCompiler c = new JPQLQueryCompiler(this, this.getParsedImports(), parameterValues);
                c.compile(3);
                this.resultMetaData = c.getResultMetaData();
                this.candidateClass = c.getCandidateClass();
                this.candidateAlias = c.getCandidateAlias();
                this.candidates = c.getCandidates();
                this.resultClass = c.getResultClass();
                this.fromInclNo = c.getRangeFromIncl();
                this.toExclNo = c.getRangeToExcl();
                c.close();
                c = null;
            }
            this.isCompiled = true;
        }
        catch (NucleusException jpe) {
            this.discardCompiled();
            this.isCompiled = false;
            throw jpe;
        }
    }

    public QueryResultsMetaData getResultSetMetaData() {
        if (this.resultMetaData == null) {
            throw new NucleusUserException("You must compile the query before calling this method.");
        }
        return this.resultMetaData;
    }

    protected Object executeQuery(Map parameters) {
        this.discardCompiled();
        return super.executeQuery(parameters);
    }

    protected Object performExecute(Map executeParameters) {
        if (this.candidates.isEmpty()) {
            return new ArrayList();
        }
        if (this.candidates instanceof CollectionCandidates) {
            ((CollectionCandidates)this.candidates).getFetchPlan().setGroups((Collection)this.getFetchPlan().getGroups());
        } else if (this.candidates instanceof Extent) {
            ((Extent)this.candidates).getFetchPlan().setGroups((Collection)this.getFetchPlan().getGroups());
        }
        this.rof = this.candidates.newResultObjectFactory(this.queryStmt, this.getIgnoreCache(), this.resultClass, this.useFetchPlan());
        if (this.rof instanceof PersistentIDROF) {
            ((PersistentIDROF)this.rof).setPersistentClass(this.candidateClass);
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)this.getLanguage(), (Object)this.getSingleStringQuery()));
        }
        SQLEvaluator eval = new SQLEvaluator((Query)this, this.rof, this.candidateCollection);
        QueryResult qr = (QueryResult)eval.evaluate(this.queryStmt);
        this.queryResults.add(qr);
        return qr;
    }

    protected long performDeletePersistentAll(Map parameters) {
        this.discardCompiled();
        return super.performDeletePersistentAll(parameters);
    }

    public Set<String> getSupportedExtensions() {
        Set supported = super.getSupportedExtensions();
        supported.add("datanucleus.rdbms.query.resultSetType");
        supported.add("datanucleus.rdbms.query.resultSetConcurrency");
        supported.add("datanucleus.rdbms.query.useUpdateLock");
        supported.add("datanucleus.rdbms.query.fetchDirection");
        return supported;
    }

    public Imports getParsedImports() {
        if (this.parsedImports == null) {
            super.getParsedImports();
            Iterator it = QueryCompiler.getUserDefinedScalarExpressions().keySet().iterator();
            while (it.hasNext()) {
                this.parsedImports.importClass((String)it.next());
            }
        }
        return this.parsedImports;
    }
}

