/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ResultMetaDataROF
implements ResultObjectFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    QueryResultMetaData queryResultMetaData = null;
    String[] columnNames = null;
    private boolean ignoreCache = false;

    public ResultMetaDataROF(QueryResultMetaData qrmd) {
        this.queryResultMetaData = qrmd;
    }

    public Object getObject(ObjectManager om, Object rs) {
        String[] columns;
        int i;
        ArrayList<Object> returnObjects = new ArrayList<Object>();
        if (this.columnNames == null) {
            try {
                ResultSetMetaData rsmd = ((ResultSet)rs).getMetaData();
                int columnCount = rsmd.getColumnCount();
                this.columnNames = new String[columnCount];
                for (int i2 = 0; i2 < columnCount; ++i2) {
                    this.columnNames[i2] = rsmd.getColumnName(i2 + 1);
                }
            }
            catch (SQLException ex) {
                throw new NucleusDataStoreException("Error obtaining objects", (Throwable)ex);
            }
        }
        QueryResultMetaData.PersistentTypeMapping[] persistentTypes = this.queryResultMetaData.getPersistentTypeMappings();
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        if (persistentTypes != null) {
            int startColumnIndex = 0;
            for (i = 0; i < persistentTypes.length; ++i) {
                HashSet<String> columnsInThisType = new HashSet<String>();
                AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[this.columnNames.length];
                HashMap<String, AbstractMemberMetaData> fieldColumns = new HashMap<String, AbstractMemberMetaData>();
                DatastoreClass dc = storeMgr.getDatastoreClass(persistentTypes[i].getClassName(), om.getClassLoaderResolver());
                AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(persistentTypes[i].getClassName(), om.getClassLoaderResolver());
                Object id = null;
                for (int j = startColumnIndex; j < this.columnNames.length; ++j) {
                    DatastoreField df;
                    if (columnsInThisType.contains(this.columnNames[j])) {
                        startColumnIndex = j;
                        break;
                    }
                    boolean found = false;
                    if (acmd.getIdentityType() == IdentityType.DATASTORE && (df = dc.getDataStoreObjectIdMapping().getDataStoreMapping(0).getDatastoreField()).getIdentifier().getIdentifierName().equals(this.columnNames[j])) {
                        int datastoreIdentityExpressionIndex = j + 1;
                        if (dc.getDataStoreObjectIdMapping() != null) {
                            id = dc.getDataStoreObjectIdMapping().getObject(om, rs, new int[]{datastoreIdentityExpressionIndex});
                        }
                        found = true;
                    }
                    for (int k = 0; k < acmd.getNoOfManagedMembers() + acmd.getNoOfInheritedManagedMembers() && !found; ++k) {
                        AbstractMemberMetaData apmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(k);
                        if (persistentTypes[i].getColumnForField(apmd.getName()) != null) {
                            if (!persistentTypes[i].getColumnForField(apmd.getName()).equals(this.columnNames[j])) continue;
                            fieldColumns.put(this.columnNames[j], apmd);
                            columnsInThisType.add(this.columnNames[j]);
                            fmds[j] = apmd;
                            found = true;
                            continue;
                        }
                        JavaTypeMapping mapping = dc.getMemberMapping(apmd);
                        for (int l = 0; l < mapping.getDataStoreMappings().length && !found; ++l) {
                            DatastoreField df2 = mapping.getDataStoreMapping(l).getDatastoreField();
                            if (!df2.getIdentifier().getIdentifierName().equals(this.columnNames[j])) continue;
                            fieldColumns.put(this.columnNames[j], apmd);
                            columnsInThisType.add(this.columnNames[j]);
                            fmds[j] = apmd;
                            found = true;
                        }
                    }
                    if (columnsInThisType.contains(this.columnNames[j])) continue;
                    startColumnIndex = j;
                    break;
                }
                StatementMappingIndex[] stmtMappings = new StatementMappingIndex[acmd.getNoOfManagedMembers() + acmd.getNoOfInheritedManagedMembers()];
                HashSet fields = new HashSet();
                fields.addAll(fieldColumns.values());
                int[] fieldNumbers = new int[fields.size()];
                Iterator it = fields.iterator();
                int j = 0;
                while (it.hasNext()) {
                    AbstractMemberMetaData apmd = (AbstractMemberMetaData)it.next();
                    StatementMappingIndex stmtMapping = new StatementMappingIndex(dc.getMemberMapping(apmd));
                    fieldNumbers[j] = apmd.getAbsoluteFieldNumber();
                    ArrayList<Integer> indexes = new ArrayList<Integer>();
                    for (int k = 0; k < fmds.length; ++k) {
                        if (fmds == null || fmds[k] != apmd) continue;
                        indexes.add(new Integer(k));
                    }
                    int[] indxs = new int[indexes.size()];
                    for (int k = 0; k < indxs.length; ++k) {
                        indxs[k] = (Integer)indexes.get(k) + 1;
                    }
                    stmtMapping.setColumnPositions(indxs);
                    stmtMappings[fieldNumbers[j]] = stmtMapping;
                    ++j;
                }
                Object obj = null;
                Class type = om.getClassLoaderResolver().classForName(persistentTypes[i].getClassName());
                if (acmd.getIdentityType() == IdentityType.APPLICATION) {
                    obj = this.getObjectForApplicationId(om, (ResultSet)rs, fieldNumbers, acmd, type, false, stmtMappings);
                } else if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                    obj = this.getObjectForDatastoreId(om, (ResultSet)rs, fieldNumbers, acmd, id, type, stmtMappings);
                }
                returnObjects.add(obj);
            }
        }
        if ((columns = this.queryResultMetaData.getScalarColumns()) != null) {
            for (i = 0; i < columns.length; ++i) {
                try {
                    Object obj = this.getResultObject((ResultSet)rs, columns[i]);
                    returnObjects.add(obj);
                    continue;
                }
                catch (SQLException sqe) {
                    String msg = LOCALISER.msg("059027", (Object)sqe.getMessage());
                    NucleusLogger.QUERY.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)sqe);
                }
            }
        }
        if (returnObjects.size() == 0) {
            return null;
        }
        if (returnObjects.size() == 1) {
            return returnObjects.get(0);
        }
        return returnObjects.toArray(new Object[returnObjects.size()]);
    }

    private Object getResultObject(ResultSet rs, String columnName) throws SQLException {
        return rs.getObject(columnName);
    }

    private Object getObjectForApplicationId(final ObjectManager om, final ResultSet rs, final int[] fieldNumbers, AbstractClassMetaData cmd, Class pcClass, boolean requiresInheritanceCheck, StatementMappingIndex[] stmtMappings) {
        final StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i = 0; i < fieldNumbers.length; ++i) {
            resultMappings.addMappingForMember(fieldNumbers[i], stmtMappings[fieldNumbers[i]]);
        }
        return om.findObjectUsingAID(pcClass, new FieldValues(){

            public void fetchFields(StateManager sm) {
                FieldManager fm = ((MappedStoreManager)om.getStoreManager()).getFieldManagerForResultProcessing(sm, (Object)rs, resultMappings);
                sm.replaceFields(fieldNumbers, fm, false);
            }

            public void fetchNonLoadedFields(StateManager sm) {
                FieldManager fm = ((MappedStoreManager)om.getStoreManager()).getFieldManagerForResultProcessing(sm, (Object)rs, resultMappings);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return om.getFetchPlan();
            }
        }, this.ignoreCache, requiresInheritanceCheck);
    }

    private Object getObjectForDatastoreId(final ObjectManager om, final ResultSet rs, final int[] fieldNumbers, AbstractClassMetaData cmd, Object oid, Class pcClass, StatementMappingIndex[] stmtMappings) {
        final StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i = 0; i < fieldNumbers.length; ++i) {
            resultMappings.addMappingForMember(fieldNumbers[i], stmtMappings[fieldNumbers[i]]);
        }
        return om.findObject(oid, new FieldValues(){

            public void fetchFields(StateManager sm) {
                FieldManager fm = ((MappedStoreManager)om.getStoreManager()).getFieldManagerForResultProcessing(sm, (Object)rs, resultMappings);
                sm.replaceFields(fieldNumbers, fm, false);
            }

            public void fetchNonLoadedFields(StateManager sm) {
                FieldManager fm = ((MappedStoreManager)om.getStoreManager()).getFieldManagerForResultProcessing(sm, (Object)rs, resultMappings);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return om.getFetchPlan();
            }
        }, pcClass, this.ignoreCache);
    }
}

