/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.util.NucleusLogger;

public class ObjectLiteral
extends ObjectExpression
implements SQLLiteral {
    private Object value;

    public ObjectLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, boolean parameter) {
        super(stmt, null, mapping);
        this.value = value;
        this.isParameter = parameter;
        if (value == null) {
            this.st.appendParameter(mapping, value);
        } else if (mapping instanceof PersistableMapping && mapping.getNumberOfDatastoreFields() > 1) {
            this.subExprs = new SQLExpression.ColumnExpressionList();
            this.addSubexpressionsForValue(value, mapping);
            this.st.append(this.subExprs.toString());
        } else {
            this.st.appendParameter(mapping, value);
        }
    }

    private void addSubexpressionsForValue(Object value, JavaTypeMapping mapping) {
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        ApiAdapter api = storeMgr.getApiAdapter();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        AbstractClassMetaData cmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
        if (cmd != null) {
            JavaTypeMapping[] subMappings = ((PersistableMapping)mapping).getJavaTypeMapping();
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (api.getIdForObject(value) != null) {
                    ObjectManager om = api.getObjectManager(value);
                    for (int i = 0; i < cmd.getNoOfPrimaryKeyMembers(); ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
                        Object fieldValue = ExpressionUtils.getValueForMemberOfObject(om, mmd, value);
                        if (api.isPersistable(fieldValue)) {
                            this.addSubexpressionsForValue(fieldValue, subMappings[i]);
                            continue;
                        }
                        this.subExprs.addExpression(new ColumnExpression(this.stmt, subMappings[i], fieldValue));
                    }
                }
            } else {
                NucleusLogger.GENERAL.info((Object)">> ObjectLiteral doesn't yet cater for datastore identity");
            }
        } else {
            NucleusLogger.GENERAL.info((Object)">> ObjectLiteral doesn't yet cater for input identity values");
        }
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        this.addSubexpressionsToRelatedExpression(expr);
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (this.value == null) {
            return new NullLiteral(this.stmt, null, null, false).eq(expr);
        }
        if (expr instanceof ObjectExpression) {
            return ExpressionUtils.getEqualityExpressionForObjectExpressions(this, (ObjectExpression)expr, true);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        this.addSubexpressionsToRelatedExpression(expr);
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (this.value == null) {
            return new NullLiteral(this.stmt, null, null, false).ne(expr);
        }
        if (expr instanceof ObjectExpression) {
            return ExpressionUtils.getEqualityExpressionForObjectExpressions(this, (ObjectExpression)expr, false);
        }
        return super.ne(expr);
    }

    public String toString() {
        if (this.value != null) {
            return super.toString() + " = " + this.value.toString();
        }
        return super.toString() + " = NULL";
    }

    public void setNotParameter() {
        if (!this.isParameter) {
            return;
        }
        this.isParameter = false;
    }
}

