/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.scostore.AbstractCollectionStore;
import org.datanucleus.store.mapped.scostore.AbstractCollectionStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSElementContainerStoreSpecialization;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.util.Localiser;

abstract class RDBMSAbstractCollectionStoreSpecialization
extends RDBMSElementContainerStoreSpecialization
implements AbstractCollectionStoreSpecialization {
    private String containsStmt;

    RDBMSAbstractCollectionStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSStoreManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    protected String getUpdateEmbeddedElementStmt(JavaTypeMapping fieldMapping, ElementContainerStore acs) {
        int i;
        JavaTypeMapping ownerMapping = acs.getOwnerMapping();
        DatastoreContainerObject containerTable = acs.getContainerTable();
        JavaTypeMapping elementMapping = acs.getElementMapping();
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(containerTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)elementMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(m.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedElement(StateManager sm, Object element, int fieldNumber, Object value, JavaTypeMapping fieldMapping, ElementContainerStore ecs) {
        boolean modified = false;
        String stmt = this.getUpdateEmbeddedElementStmt(fieldMapping, ecs);
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    int jdbcPosition = 1;
                    fieldMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)fieldMapping), value);
                    jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)ecs);
                    jdbcPosition = BackingStoreHelper.populateEmbeddedElementFieldsInStatement(sm, element, ps, jdbcPosition, ((JoinTable)ecs.getContainerTable()).getOwnerMemberMetaData(), ecs.getElementMapping(), ecs.getEmd(), (BaseContainerStore)ecs);
                    sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                    modified = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new NucleusDataStoreException(this.localiser.msg("056009", (Object)stmt), (Throwable)e);
        }
        return modified;
    }

    private String getContainsStmt(AbstractCollectionStore acs) {
        if (this.containsStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = acs.getOwnerMapping();
            DatastoreContainerObject containerTable = acs.getContainerTable();
            boolean elementsAreSerialised = acs.isElementsAreSerialised();
            JavaTypeMapping elementMapping = acs.getElementMapping();
            ElementContainerStore.ElementInfo[] elementInfo = acs.getElementInfo();
            JavaTypeMapping relationDiscriminatorMapping = acs.getRelationDiscriminatorMapping();
            StringBuffer stmt = new StringBuffer();
            String containerAlias = "THIS";
            String joinedElementAlias = "ELEM";
            stmt.append("SELECT ");
            for (int i2 = 0; i2 < ownerMapping.getNumberOfDatastoreFields(); ++i2) {
                if (i2 > 0) {
                    stmt.append(",");
                }
                stmt.append(ownerMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier().toString());
            }
            stmt.append(" FROM ");
            stmt.append(acs.getContainerTable().toString()).append(" ").append(containerAlias);
            boolean joinedDiscrim = false;
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerAlias).append(".").append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                if (elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (elementInfo != null && containerTable == elementInfo[0].getDatastoreClass() && elementInfo[0].getDiscriminatorMapping() != null) {
                stmt.append(" AND (");
                HashSet subclasses = this.storeMgr.getSubClassesForClass(elementInfo[0].getClassName(), true, this.clr);
                for (int i3 = 0; i3 < subclasses.size() + 1; ++i3) {
                    JavaTypeMapping discrimMapping = elementInfo[0].getDiscriminatorMapping();
                    for (int j = 0; j < discrimMapping.getNumberOfDatastoreFields(); ++j) {
                        if (joinedDiscrim) {
                            stmt.append(joinedElementAlias);
                        } else {
                            stmt.append(containerAlias);
                        }
                        stmt.append(".").append(discrimMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString());
                        stmt.append(" = ");
                        stmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(j)).getUpdateInputParameter());
                        if (j == discrimMapping.getNumberOfDatastoreFields() - 1 && i3 == subclasses.size()) continue;
                        stmt.append(" OR ");
                    }
                }
                stmt.append(")");
            }
            if (relationDiscriminatorMapping != null) {
                for (int i4 = 0; i4 < relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i4) {
                    stmt.append(" AND ");
                    stmt.append(containerAlias).append(".").append(relationDiscriminatorMapping.getDataStoreMapping(i4).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDataStoreMapping(i4)).getUpdateInputParameter());
                }
            }
            this.containsStmt = stmt.toString();
        }
        return this.containsStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(StateManager sm, Object element, AbstractCollectionStore acs) {
        boolean retval;
        DatastoreContainerObject containerTable = acs.getContainerTable();
        JavaTypeMapping elementMapping = acs.getElementMapping();
        ElementContainerStore.ElementInfo[] elementInfo = acs.getElementInfo();
        String stmt = this.getContainsStmt(acs);
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)acs);
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(om, ps, element, jdbcPosition, elementMapping);
                    if (elementInfo != null && elementInfo[0].getDiscriminatorMapping() != null && elementInfo[0].getDatastoreClass() == containerTable) {
                        jdbcPosition = BackingStoreHelper.populateElementDiscriminatorInStatement(om, ps, jdbcPosition, true, elementInfo[0], this.clr);
                    }
                    if (acs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, (ElementContainerStore)acs);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        retval = rs.next();
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056008", (Object)stmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] internalRemove(StateManager ownerSM, ManagedConnection conn, boolean batched, Object element, boolean executeNow, AbstractCollectionStore acs) throws MappedDatastoreException {
        int[] nArray;
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String removeStmt = this.getRemoveStmt((ElementContainerStore)acs);
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)acs);
            jdbcPosition = BackingStoreHelper.populateElementInStatement(om, ps, element, jdbcPosition, acs.getElementMapping());
            if (acs.getRelationDiscriminatorMapping() != null) {
                jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, (ElementContainerStore)acs);
            }
            nArray = sqlControl.executeStatementUpdate(conn, removeStmt, ps, executeNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new MappedDatastoreException("SQLException", (Throwable)sqle);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    protected String getRemoveStmt(ElementContainerStore ecs) {
        JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
        DatastoreContainerObject containerTable = ecs.getContainerTable();
        boolean elementsAreSerialised = ecs.isElementsAreSerialised();
        JavaTypeMapping elementMapping = ecs.getElementMapping();
        ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
        if (this.removeStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("DELETE FROM ");
            stmt.append(containerTable.toString());
            boolean joinedDiscrim = false;
            if (elementInfo != null && elementInfo[0].getDatastoreClass() != containerTable && elementInfo[0].getDiscriminatorMapping() != null) {
                joinedDiscrim = true;
                stmt.append(" USING ");
                stmt.append(elementInfo[0].getDatastoreClass().toString());
            }
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerTable.toString()).append(".");
                stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(containerTable.toString()).append(".");
                stmt.append(elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                if (elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (elementInfo != null && elementInfo[0].getDiscriminatorMapping() != null) {
                JavaTypeMapping discrimMapping = elementInfo[0].getDiscriminatorMapping();
                for (int i2 = 0; i2 < discrimMapping.getNumberOfDatastoreFields(); ++i2) {
                    stmt.append(" AND ");
                    if (joinedDiscrim) {
                        stmt.append(elementInfo[0].getDatastoreClass().toString());
                    } else {
                        stmt.append(containerTable.toString());
                    }
                    stmt.append(".");
                    stmt.append(discrimMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(i2)).getUpdateInputParameter());
                }
            }
            this.removeStmt = stmt.toString();
        }
        return this.removeStmt;
    }
}

