/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.sql.CLOB;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.exceptions.DatastoreFieldDefinitionException;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.mapping.ClobRDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.Column;

public class OracleClobRDBMSMapping
extends ClobRDBMSMapping {
    protected OracleClobRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public OracleClobRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null && !this.column.isUnlimitedLength()) {
            throw new DatastoreFieldDefinitionException("Invalid length specified for CLOB column " + this.column + ", must be 'unlimited'");
        }
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return ((RDBMSStoreManager)this.storeMgr).getSQLTypeInfoForJDBCType(2005);
    }

    public String getInsertionInputParameter() {
        return "EMPTY_CLOB()";
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public String getUpdateInputParameter() {
        return "EMPTY_CLOB()";
    }

    public boolean insertValuesOnInsert() {
        return false;
    }

    public String getString(Object rs, int param) {
        String value;
        block8: {
            value = null;
            try {
                char[] cbuf = null;
                Clob clob = ((ResultSet)rs).getClob(param);
                if (clob == null) break block8;
                StringBuffer sbuf = new StringBuffer();
                Reader reader = clob.getCharacterStream();
                try {
                    int BUFF_SIZE = 4096;
                    cbuf = new char[4096];
                    int charsRead = reader.read(cbuf);
                    while (-1 != charsRead) {
                        sbuf.append(cbuf, 0, charsRead);
                        Arrays.fill(cbuf, '\u0000');
                        charsRead = reader.read(cbuf);
                    }
                }
                catch (IOException e) {
                    throw new NucleusDataStoreException("Error reading Oracle CLOB object: param = " + param, (Throwable)e);
                }
                value = sbuf.toString();
                if (value.length() == 0) {
                    value = null;
                } else if (value.equals(this.getDatabaseAdapter().getSurrogateForEmptyStrings())) {
                    value = "";
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"String", (Object)("" + param)), (Throwable)e);
            }
        }
        return value;
    }

    public Object getObject(Object rs, int param) {
        return this.getString(rs, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateClobColumn(StateManager sm, DatastoreContainerObject datastoreContainer, DatastoreMapping mapping, String value) {
        StateManager[] embeddedOwners;
        ObjectManager om = sm.getObjectManager();
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)om.getStoreManager();
        DatastoreClass classTable = (DatastoreClass)datastoreContainer;
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        SQLStatement sqlStmt = new SQLStatement(storeMgr, datastoreContainer, null, null);
        sqlStmt.addExtension("lock-for-update", true);
        SQLTable blobSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), mapping.getJavaTypeMapping());
        sqlStmt.select(blobSqlTbl, mapping.getDatastoreField(), null);
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        AbstractClassMetaData cmd = sm.getClassMetaData();
        int inputParamNum = 1;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping datastoreIdMapping = classTable.getDataStoreObjectIdMapping();
            SQLExpression expr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), datastoreIdMapping);
            SQLExpression val = exprFactory.newLiteralParameter(sqlStmt, datastoreIdMapping, null);
            sqlStmt.whereAnd(expr.eq(val), true);
            StatementMappingIndex datastoreIdx = mappingDefinition.getMappingForMemberPosition(StatementClassMapping.MEMBER_DATASTORE_ID);
            if (datastoreIdx == null) {
                datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DATASTORE_ID, datastoreIdx);
            }
            datastoreIdx.addParameterOccurrence(new int[]{inputParamNum});
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkNums.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                JavaTypeMapping pkMapping = classTable.getMemberMapping(mmd);
                SQLExpression expr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), pkMapping);
                SQLExpression val = exprFactory.newLiteralParameter(sqlStmt, pkMapping, null);
                sqlStmt.whereAnd(expr.eq(val), true);
                StatementMappingIndex pkIdx = mappingDefinition.getMappingForMemberPosition(pkNums[i]);
                if (pkIdx == null) {
                    pkIdx = new StatementMappingIndex(pkMapping);
                    mappingDefinition.addMappingForMember(pkNums[i], pkIdx);
                }
                int[] inputParams = new int[pkMapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < pkMapping.getNumberOfDatastoreFields(); ++j) {
                    inputParams[j] = inputParamNum++;
                }
                pkIdx.addParameterOccurrence(inputParams);
            }
        }
        String textStmt = sqlStmt.getSelectStatement().toSQL();
        if (sm.getPcObjectType() != 0 && (embeddedOwners = sm.getEmbeddedOwners()) != null) {
            sm = embeddedOwners[0];
        }
        try {
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, textStmt);
                try {
                    if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        StatementMappingIndex datastoreIdx = mappingDefinition.getMappingForMemberPosition(StatementClassMapping.MEMBER_DATASTORE_ID);
                        for (int i = 0; i < datastoreIdx.getNumberOfParameterOccurrences(); ++i) {
                            classTable.getDataStoreObjectIdMapping().setObject(om, (Object)ps, datastoreIdx.getParameterPositionsForOccurrence(i), sm.getInternalObjectId());
                        }
                    } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                        sm.provideFields(cmd.getPKMemberPositions(), storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDefinition, false));
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, textStmt, ps);
                    try {
                        Clob clob;
                        if (!rs.next()) {
                            throw new NucleusObjectNotFoundException("No such database row", sm.getInternalObjectId());
                        }
                        int jdbcMajorVersion = ((DatabaseAdapter)datastoreContainer.getStoreManager().getDatastoreAdapter()).getDriverMajorVersion();
                        if (jdbcMajorVersion < 10) {
                            clob = (CLOB)rs.getClob(1);
                            if (clob != null) {
                                clob.putString(1L, value);
                            }
                        } else {
                            clob = rs.getClob(1);
                            if (clob != null) {
                                clob.setString(1L, value);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Update of CLOB value failed: " + textStmt, (Throwable)e);
        }
    }
}

