/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.ClassDefinitionException;
import org.datanucleus.store.exceptions.NoSuchPersistentFieldException;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.DuplicateDatastoreFieldException;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorLongMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorStringMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.IndexMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.VersionLongMapping;
import org.datanucleus.store.mapped.mapping.VersionTimestampMapping;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.AbstractClassTable;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.store.rdbms.table.TableUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.MacroString;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTable
extends AbstractClassTable
implements DatastoreClass {
    private final ClassMetaData cmd;
    private final Collection<AbstractClassMetaData> managedClassMetaData = new HashSet<AbstractClassMetaData>();
    private ClassTable supertable;
    private Map<String, SecondaryTable> secondaryTables;
    private HashMap<AbstractMemberMetaData, JavaTypeMapping> externalFkMappings;
    private HashMap<AbstractMemberMetaData, JavaTypeMapping> externalFkDiscriminatorMappings;
    private HashMap<AbstractMemberMetaData, JavaTypeMapping> externalOrderMappings;
    private MacroString tableDef;
    private String createStatementDDL;
    private static MultiMap callbacks = new MultiMap();
    HashMap<AbstractMemberMetaData, CandidateKey> candidateKeysByMapField = new HashMap();
    HashSet<Column> unmappedColumns = null;
    protected transient String managingClassCurrent = null;
    protected boolean runCallbacksAfterManageClass = false;

    public ClassTable(DatastoreIdentifier tableName, RDBMSManager storeMgr, ClassMetaData cmd) {
        super(tableName, storeMgr);
        this.cmd = cmd;
        if (cmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.NEW_TABLE && cmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.COMPLETE_TABLE) {
            throw new NucleusUserException(LOCALISER.msg("057003", (Object)cmd.getFullClassName(), (Object)cmd.getInheritanceMetaData().getStrategy().toString())).setFatal();
        }
        this.highestMemberNumber = cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers();
        String tableImpStr = cmd.getValueForExtension("ddl-imports");
        String tableDefStr = null;
        if (this.dba.getVendorID() != null) {
            tableDefStr = cmd.getValueForExtension("ddl-definition-" + this.dba.getVendorID());
        }
        if (tableDefStr == null) {
            tableDefStr = cmd.getValueForExtension("ddl-definition");
        }
        if (tableDefStr != null) {
            this.tableDef = new MacroString(cmd.getFullClassName(), tableImpStr, tableDefStr);
        }
    }

    @Override
    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsPKUninitialized();
        if (this.cmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.COMPLETE_TABLE) {
            this.supertable = this.getSupertable((AbstractClassMetaData)this.cmd, clr);
            if (this.supertable != null && !this.supertable.isInitialized() && !this.supertable.isPKInitialized()) {
                this.supertable.preInitialize(clr);
            }
        }
        if (!this.isPKInitialized()) {
            this.initializePK(clr);
        }
    }

    @Override
    public void initialize(ClassLoaderResolver clr) {
        DiscriminatorMetaData dismd;
        this.assertIsUninitialized();
        this.initializeForClass((AbstractClassMetaData)this.cmd, clr);
        MappingManager mapMgr = this.storeMgr.getMappingManager();
        this.versionMetaData = this.cmd.getVersionMetaDataForTable();
        if (this.versionMetaData != null && this.versionMetaData.getFieldName() == null) {
            if (this.versionMetaData.getVersionStrategy() == VersionStrategy.NONE) {
                this.versionMapping = new VersionLongMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(Long.class));
            } else if (this.versionMetaData.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                this.versionMapping = new VersionLongMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(Long.class));
            } else if (this.versionMetaData.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                if (!this.dba.supportsOption("DateTimeStoresMillisecs")) {
                    throw new NucleusException("Class " + this.cmd.getFullClassName() + " is defined " + "to use date-time versioning, yet this datastore doesnt support storing " + "milliseconds in DATETIME/TIMESTAMP columns. Use version-number");
                }
                this.versionMapping = new VersionTimestampMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(Timestamp.class));
            }
        }
        if ((dismd = this.cmd.getDiscriminatorMetaDataForTable()) != null) {
            this.discriminatorMetaData = dismd;
            if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.discriminatorPerSubclassTable")) {
                if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                    this.discriminatorMapping = new DiscriminatorStringMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(String.class));
                } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                    ColumnMetaData disColmd = dismd.getColumnMetaData();
                    this.discriminatorMapping = disColmd != null && disColmd.getJdbcType() != null ? (disColmd.getJdbcType().equalsIgnoreCase("INTEGER") || disColmd.getJdbcType().equalsIgnoreCase("BIGINT") || disColmd.getJdbcType().equalsIgnoreCase("NUMERIC") ? new DiscriminatorLongMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(Long.class)) : new DiscriminatorStringMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(String.class))) : new DiscriminatorStringMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(String.class));
                }
            } else {
                ClassTable tableWithDiscrim = this.getTableWithDiscriminator();
                if (tableWithDiscrim == this) {
                    if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                        this.discriminatorMapping = new DiscriminatorStringMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(String.class));
                    } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                        ColumnMetaData disColmd = dismd.getColumnMetaData();
                        this.discriminatorMapping = disColmd != null && disColmd.getJdbcType() != null ? (disColmd.getJdbcType().equalsIgnoreCase("INTEGER") || disColmd.getJdbcType().equalsIgnoreCase("BIGINT") || disColmd.getJdbcType().equalsIgnoreCase("NUMERIC") ? new DiscriminatorLongMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(Long.class)) : new DiscriminatorStringMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(String.class))) : new DiscriminatorStringMapping((DatastoreAdapter)this.dba, (DatastoreContainerObject)this, mapMgr.getMapping(String.class));
                    }
                }
            }
        }
        if (this.secondaryTables != null) {
            Set<String> secondaryTableNames = this.secondaryTables.keySet();
            for (String secondaryTableName : secondaryTableNames) {
                SecondaryTable second = this.secondaryTables.get(secondaryTableName);
                if (second.isInitialized()) continue;
                second.initialize(clr);
            }
        }
        this.state = 2;
    }

    @Override
    public void postInitialize(final ClassLoaderResolver clr) {
        this.assertIsInitialized();
        this.runCallBacks(clr);
        if (this.tableDef != null) {
            this.createStatementDDL = this.tableDef.substituteMacros(new MacroString.MacroHandler(){

                public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                    ClassTable.this.storeMgr.resolveIdentifierMacro(im, clr);
                }

                public void onParameterMacro(MacroString.ParameterMacro pm) {
                    throw new NucleusUserException(AbstractTable.LOCALISER.msg("057033", (Object)ClassTable.this.cmd.getFullClassName(), (Object)pm));
                }
            }, clr);
        }
    }

    public void manageClass(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("057024", (Object)this.toString(), (Object)theCmd.getFullClassName(), (Object)theCmd.getInheritanceMetaData().getStrategy().toString()));
        }
        this.managingClassCurrent = theCmd.getFullClassName();
        this.managedClassMetaData.add(theCmd);
        this.manageMembers(theCmd, clr, theCmd.getManagedMembers());
        this.manageMembers(theCmd, clr, theCmd.getOverriddenMembers());
        this.manageUnmappedColumns(theCmd, clr);
        this.managingClassCurrent = null;
        if (this.runCallbacksAfterManageClass) {
            this.runCallBacks(clr);
            this.runCallbacksAfterManageClass = false;
        }
    }

    public String[] getManagedClasses() {
        String[] classNames = new String[this.managedClassMetaData.size()];
        Iterator<AbstractClassMetaData> iter = this.managedClassMetaData.iterator();
        int i = 0;
        while (iter.hasNext()) {
            classNames[i++] = iter.next().getFullClassName();
        }
        return classNames;
    }

    private void manageMembers(AbstractClassMetaData theCmd, ClassLoaderResolver clr, AbstractMemberMetaData[] mmds) {
        for (int fieldNumber = 0; fieldNumber < mmds.length; ++fieldNumber) {
            DatastoreClass dc;
            AbstractMemberMetaData fmd = mmds[fieldNumber];
            if (fmd.isPrimaryKey()) continue;
            if (this.managesMember(fmd.getFullFieldName())) {
                if (fmd.getClassName(true).equals(theCmd.getFullClassName())) continue;
                JavaTypeMapping fieldMapping = this.getMappingForMemberName(fmd.getFullFieldName());
                ColumnMetaData[] colmds = fmd.getColumnMetaData();
                if (colmds == null || colmds.length <= 0) continue;
                int colnum = 0;
                IdentifierFactory idFactory = this.getStoreManager().getIdentifierFactory();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    Column col = (Column)fieldMapping.getDataStoreMapping(i).getDatastoreField();
                    col.setIdentifier(idFactory.newDatastoreFieldIdentifier(colmds[colnum].getName()));
                    col.setColumnMetaData(colmds[colnum]);
                    if (++colnum == colmds.length) break;
                }
                if (!NucleusLogger.DATASTORE.isDebugEnabled()) continue;
                StringBuffer columnsStr = new StringBuffer();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    if (i > 0) {
                        columnsStr.append(",");
                    }
                    columnsStr.append(fieldMapping.getDataStoreMapping(i).getDatastoreField());
                }
                if (fieldMapping.getNumberOfDatastoreFields() == 0) {
                    columnsStr.append("[none]");
                }
                StringBuffer datastoreMappingTypes = new StringBuffer();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    if (i > 0) {
                        datastoreMappingTypes.append(',');
                    }
                    datastoreMappingTypes.append(fieldMapping.getDataStoreMapping(i).getClass().getName());
                }
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("057010", (Object)fmd.getFullFieldName(), (Object)columnsStr.toString(), (Object)fieldMapping.getClass().getName(), (Object)datastoreMappingTypes.toString()));
                continue;
            }
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                boolean isPrimary = true;
                if (fmd.getTable() != null && fmd.getJoinMetaData() == null) {
                    isPrimary = false;
                }
                if (isPrimary) {
                    this.addMemberMapping(this.storeMgr.getMappingManager().getMapping((DatastoreContainerObject)this, fmd, (DatastoreAdapter)this.dba, clr, 2));
                } else {
                    SecondaryTable secTable;
                    if (this.secondaryTables == null) {
                        this.secondaryTables = new HashMap<String, SecondaryTable>();
                    }
                    if ((secTable = this.secondaryTables.get(fmd.getTable())) == null) {
                        String schemaName;
                        JoinMetaData[] joinmds = theCmd.getJoinMetaData();
                        JoinMetaData joinmd = null;
                        if (joinmds != null) {
                            for (int j = 0; j < joinmds.length; ++j) {
                                if (!joinmds[j].getTable().equalsIgnoreCase(fmd.getTable()) || joinmds[j].getCatalog() != null && (joinmds[j].getCatalog() == null || !joinmds[j].getCatalog().equalsIgnoreCase(fmd.getCatalog())) || joinmds[j].getSchema() != null && (joinmds[j].getSchema() == null || !joinmds[j].getSchema().equalsIgnoreCase(fmd.getSchema()))) continue;
                                joinmd = joinmds[j];
                                break;
                            }
                        }
                        DatastoreIdentifier secTableIdentifier = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(fmd.getTable());
                        String catalogName = fmd.getCatalog();
                        if (catalogName == null) {
                            catalogName = this.getCatalogName();
                        }
                        if ((schemaName = fmd.getSchema()) == null) {
                            schemaName = this.getSchemaName();
                        }
                        secTableIdentifier.setCatalogName(catalogName);
                        secTableIdentifier.setSchemaName(schemaName);
                        secTable = new SecondaryTable(secTableIdentifier, this.storeMgr, this, joinmd, clr);
                        secTable.preInitialize(clr);
                        secTable.initialize(clr);
                        secTable.postInitialize(clr);
                        this.secondaryTables.put(fmd.getTable(), secTable);
                    }
                    secTable.addMemberMapping(this.storeMgr.getMappingManager().getMapping((DatastoreContainerObject)secTable, fmd, (DatastoreAdapter)this.dba, clr, 2));
                }
            } else if (fmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                throw new NucleusException(LOCALISER.msg("057006", (Object)fmd.getName())).setFatal();
            }
            boolean needsFKToContainerOwner = false;
            int relationType = fmd.getRelationType(clr);
            if (relationType == 4) {
                AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
                if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                    needsFKToContainerOwner = true;
                }
            } else if (relationType == 3 && fmd.getJoinMetaData() == null) {
                needsFKToContainerOwner = true;
            }
            if (!needsFKToContainerOwner) continue;
            if (fmd.getCollection() != null && !SCOUtils.collectionHasSerialisedElements((AbstractMemberMetaData)fmd) || fmd.getArray() != null && !SCOUtils.arrayIsStoredInSingleColumn((AbstractMemberMetaData)fmd)) {
                AbstractClassMetaData elementCmd = null;
                elementCmd = fmd.hasCollection() ? this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getCollection().getElementType(), clr) : this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getType().getComponentType(), clr);
                if (elementCmd == null) {
                    if (fmd.hasCollection()) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("057016", (Object)theCmd.getFullClassName(), (Object)fmd.getCollection().getElementType()));
                        continue;
                    }
                    NucleusLogger.METADATA.warn((Object)LOCALISER.msg("057014", (Object)theCmd.getFullClassName(), (Object)fmd.getType().getComponentType().getName()));
                    continue;
                }
                Object[] elementCmds = null;
                elementCmds = elementCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(elementCmd, clr) : new ClassMetaData[]{elementCmd};
                for (int i = 0; i < elementCmds.length; ++i) {
                    callbacks.put((Object)elementCmds[i].getFullClassName(), (Object)new CallBack(fmd));
                    dc = this.storeMgr.getDatastoreClass(elementCmds[i].getFullClassName(), clr);
                    ClassTable ct = (ClassTable)dc;
                    if (!ct.isInitialized()) continue;
                    ct.runCallBacks(clr);
                }
                continue;
            }
            if (fmd.getMap() == null || SCOUtils.mapHasSerialisedKeysAndValues((AbstractMemberMetaData)fmd)) continue;
            if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
                AbstractClassMetaData valueCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getMap().getValueType(), clr);
                if (valueCmd == null) {
                    NucleusLogger.METADATA.warn((Object)LOCALISER.msg("057018", (Object)theCmd.getFullClassName(), (Object)fmd.getMap().getValueType()));
                    continue;
                }
                Object[] valueCmds = null;
                valueCmds = valueCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(valueCmd, clr) : new ClassMetaData[]{valueCmd};
                for (int i = 0; i < valueCmds.length; ++i) {
                    callbacks.put((Object)valueCmds[i].getFullClassName(), (Object)new CallBack(fmd));
                    dc = this.storeMgr.getDatastoreClass(valueCmds[i].getFullClassName(), clr);
                    ClassTable ct = (ClassTable)dc;
                    if (!ct.isInitialized()) continue;
                    ct.runCallBacks(clr);
                }
                continue;
            }
            if (fmd.getValueMetaData() == null || fmd.getValueMetaData().getMappedBy() == null) continue;
            AbstractClassMetaData keyCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getMap().getKeyType(), clr);
            if (keyCmd == null) {
                NucleusLogger.METADATA.warn((Object)LOCALISER.msg("057019", (Object)theCmd.getFullClassName(), (Object)fmd.getMap().getKeyType()));
                continue;
            }
            Object[] keyCmds = null;
            keyCmds = keyCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(keyCmd, clr) : new ClassMetaData[]{keyCmd};
            for (int i = 0; i < keyCmds.length; ++i) {
                callbacks.put((Object)keyCmds[i].getFullClassName(), (Object)new CallBack(fmd));
                dc = this.storeMgr.getDatastoreClass(keyCmds[i].getFullClassName(), clr);
                ClassTable ct = (ClassTable)dc;
                if (!ct.isInitialized()) continue;
                ct.runCallBacks(clr);
            }
        }
    }

    private void manageUnmappedColumns(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        List cols = theCmd.getUnmappedColumns();
        if (cols != null && cols.size() > 0) {
            for (ColumnMetaData colmd : cols) {
                if (colmd.getJdbcType().equals("VARCHAR") && colmd.getLength() == null) {
                    colmd.setLength(Integer.valueOf(this.getStoreManager().getOMFContext().getPersistenceConfiguration().getIntProperty("datanucleus.rdbms.stringDefaultLength")));
                }
                IdentifierFactory idFactory = this.getStoreManager().getIdentifierFactory();
                DatastoreIdentifier colIdentifier = idFactory.newIdentifier(IdentifierType.COLUMN, colmd.getName());
                Column col = (Column)this.addDatastoreField(null, colIdentifier, null, (MetaData)colmd);
                SQLTypeInfo sqlTypeInfo = this.storeMgr.getSQLTypeInfoForJDBCType(JDBCUtils.getJDBCTypeForName(colmd.getJdbcType()));
                col.setTypeInfo(sqlTypeInfo);
                if (this.unmappedColumns == null) {
                    this.unmappedColumns = new HashSet();
                }
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("057011", (Object)col.toString(), (Object)colmd.getJdbcType()));
                }
                this.unmappedColumns.add(col);
            }
        }
    }

    public boolean managesClass(String className) {
        if (className == null) {
            return false;
        }
        for (AbstractClassMetaData managedCmd : this.managedClassMetaData) {
            if (!managedCmd.getFullClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void initializePK(ClassLoaderResolver clr) {
        this.assertIsPKUninitialized();
        AbstractMemberMetaData[] membersToAdd = new AbstractMemberMetaData[this.cmd.getNoOfPrimaryKeyMembers()];
        int pkFieldNum = 0;
        int fieldCount = this.cmd.getNoOfManagedMembers();
        boolean hasPrimaryKeyInThisClass = false;
        if (this.cmd.getNoOfPrimaryKeyMembers() > 0) {
            this.pkMappings = new JavaTypeMapping[this.cmd.getNoOfPrimaryKeyMembers()];
            if (this.cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                AbstractClassMetaData baseCmd = this.cmd.getBaseAbstractClassMetaData();
                fieldCount = baseCmd.getNoOfManagedMembers();
                for (int relFieldNum = 0; relFieldNum < fieldCount; ++relFieldNum) {
                    AbstractMemberMetaData mmd = baseCmd.getMetaDataForManagedMemberAtPosition(relFieldNum);
                    if (!mmd.isPrimaryKey()) continue;
                    if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                        membersToAdd[pkFieldNum++] = mmd;
                        hasPrimaryKeyInThisClass = true;
                    } else if (mmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                        throw new NucleusException(LOCALISER.msg("057006", (Object)mmd.getName())).setFatal();
                    }
                    if (mmd.getValueStrategy() != IdentityStrategy.IDENTITY || this.dba.supportsOption("IdentityColumns")) continue;
                    throw new NucleusException(LOCALISER.msg("057020", (Object)this.cmd.getFullClassName(), (Object)mmd.getName())).setFatal();
                }
            } else {
                for (int relFieldNum = 0; relFieldNum < fieldCount; ++relFieldNum) {
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtPosition(relFieldNum);
                    if (!fmd.isPrimaryKey()) continue;
                    if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                        membersToAdd[pkFieldNum++] = fmd;
                        hasPrimaryKeyInThisClass = true;
                    } else if (fmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                        throw new NucleusException(LOCALISER.msg("057006", (Object)fmd.getName())).setFatal();
                    }
                    if (fmd.getValueStrategy() != IdentityStrategy.IDENTITY || this.dba.supportsOption("IdentityColumns")) continue;
                    throw new NucleusException(LOCALISER.msg("057020", (Object)this.cmd.getFullClassName(), (Object)fmd.getName())).setFatal();
                }
            }
        }
        if (!hasPrimaryKeyInThisClass) {
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
                DatastoreClass elementCT = this.storeMgr.getDatastoreClass(this.cmd.getPersistenceCapableSuperclass(), clr);
                if (elementCT != null) {
                    JoinMetaData colContainer = null;
                    if (this.cmd.getInheritanceMetaData() != null) {
                        colContainer = this.cmd.getInheritanceMetaData().getJoinMetaData();
                    }
                    if (colContainer == null) {
                        colContainer = this.cmd.getPrimaryKeyMetaData();
                    }
                    this.addApplicationIdUsingClassTableId((ColumnMetaDataContainer)colContainer, elementCT, clr, (AbstractClassMetaData)this.cmd);
                } else {
                    AbstractClassMetaData pkCmd = this.storeMgr.getClassWithPrimaryKeyForClass(this.cmd.getSuperAbstractClassMetaData(), clr);
                    if (pkCmd != null) {
                        this.pkMappings = new JavaTypeMapping[pkCmd.getNoOfPrimaryKeyMembers()];
                        pkFieldNum = 0;
                        fieldCount = pkCmd.getNoOfInheritedManagedMembers() + pkCmd.getNoOfManagedMembers();
                        for (int absFieldNum = 0; absFieldNum < fieldCount; ++absFieldNum) {
                            AbstractMemberMetaData fmd = pkCmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNum);
                            if (!fmd.isPrimaryKey()) continue;
                            AbstractMemberMetaData overriddenFmd = this.cmd.getOverriddenMember(fmd.getName());
                            if (overriddenFmd != null) {
                                fmd = overriddenFmd;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                                membersToAdd[pkFieldNum++] = fmd;
                                continue;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                            throw new NucleusException(LOCALISER.msg("057006", (Object)fmd.getName())).setFatal();
                        }
                    }
                }
            } else if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                PrimaryKeyMetaData colContainer = null;
                if (this.cmd.getIdentityMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData().length > 0) {
                    colContainer = this.cmd.getIdentityMetaData();
                }
                if (colContainer == null) {
                    colContainer = this.cmd.getPrimaryKeyMetaData();
                }
                this.addDatastoreId((ColumnMetaDataContainer)colContainer, null, (AbstractClassMetaData)this.cmd);
            } else if (this.cmd.getIdentityType() == IdentityType.NONDURABLE) {
                // empty if block
            }
        }
        for (int i = 0; i < membersToAdd.length; ++i) {
            if (membersToAdd[i] == null) continue;
            try {
                DatastoreClass datastoreClass = this.getStoreManager().getDatastoreClass(membersToAdd[i].getType().getName(), clr);
                if (datastoreClass.getIDMapping() == null) {
                    throw new NucleusException("Unsupported relationship with field " + membersToAdd[i].getFullFieldName()).setFatal();
                }
            }
            catch (NoTableManagedException ex) {
                // empty catch block
            }
            JavaTypeMapping fieldMapping = this.storeMgr.getMappingManager().getMapping((DatastoreContainerObject)this, membersToAdd[i], (DatastoreAdapter)this.dba, clr, 2);
            this.addMemberMapping(fieldMapping);
            this.pkMappings[i] = fieldMapping;
        }
        this.initializeIDMapping();
        this.state = 1;
    }

    private void initializeForClass(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        String columnOrdering = this.getStoreManager().getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.tableColumnOrder");
        if (columnOrdering.equalsIgnoreCase("superclass-first")) {
            AbstractClassMetaData parentCmd = theCmd.getSuperAbstractClassMetaData();
            if (parentCmd != null) {
                if (this.cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                    this.initializeForClass(parentCmd, clr);
                } else if (parentCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    this.initializeForClass(parentCmd, clr);
                }
            }
            this.manageClass(theCmd, clr);
        } else {
            this.manageClass(theCmd, clr);
            AbstractClassMetaData parentCmd = theCmd.getSuperAbstractClassMetaData();
            if (parentCmd != null) {
                if (this.cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                    this.initializeForClass(parentCmd, clr);
                } else if (parentCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    this.initializeForClass(parentCmd, clr);
                }
            }
        }
    }

    private void runCallBacks(ClassLoaderResolver clr) {
        for (AbstractClassMetaData managedCmd : this.managedClassMetaData) {
            if (this.managingClassCurrent != null && this.managingClassCurrent.equals(managedCmd.getFullClassName())) {
                this.runCallbacksAfterManageClass = true;
                break;
            }
            Collection c = (Collection)callbacks.remove((Object)managedCmd.getFullClassName());
            this.runSpecifiedCallbacks(managedCmd, c, clr);
        }
    }

    private void runSpecifiedCallbacks(AbstractClassMetaData classCmd, Collection callbacks, ClassLoaderResolver clr) {
        if (callbacks != null) {
            for (CallBack callback : callbacks) {
                JavaTypeMapping orderMapping;
                JavaTypeMapping fkDiscrimMapping;
                if (callback.fmd.getJoinMetaData() != null) continue;
                AbstractMemberMetaData ownerFmd = callback.fmd;
                if (ownerFmd.getMappedBy() != null) {
                    AbstractMemberMetaData fmd = classCmd.getMetaDataForMember(ownerFmd.getMappedBy());
                    if (fmd == null) {
                        throw new NucleusUserException(LOCALISER.msg("057036", (Object)ownerFmd.getMappedBy(), (Object)classCmd.getFullClassName(), (Object)ownerFmd.getFullFieldName()));
                    }
                    if (ownerFmd.getMap() != null && this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.uniqueConstraints.mapInverse")) {
                        this.initializeFKMapUniqueConstraints(ownerFmd);
                    }
                    boolean duplicate = false;
                    fkDiscrimMapping = null;
                    orderMapping = null;
                    if (ownerFmd.hasExtension("relation-discriminator-column")) {
                        String colName = ownerFmd.getValueForExtension("relation-discriminator-column");
                        if (colName == null) {
                            colName = "RELATION_DISCRIM";
                        }
                        Set<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> fkDiscrimEntries = this.getExternalFkDiscriminatorMappings().entrySet();
                        for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry : fkDiscrimEntries) {
                            JavaTypeMapping discrimMapping = entry.getValue();
                            String discrimColName = discrimMapping.getDataStoreMapping(0).getDatastoreField().getColumnMetaData().getName();
                            if (!discrimColName.equalsIgnoreCase(colName)) continue;
                            duplicate = true;
                            fkDiscrimMapping = discrimMapping;
                            orderMapping = this.getExternalOrderMappings().get(entry.getKey());
                            break;
                        }
                        if (!duplicate) {
                            ColumnMetaData colmd = new ColumnMetaData();
                            colmd.setName(colName);
                            colmd.setAllowsNull(Boolean.TRUE);
                            fkDiscrimMapping = this.storeMgr.getMappingManager().getMapping(String.class);
                            fkDiscrimMapping.setDatastoreContainer((DatastoreContainerObject)this);
                            ColumnCreator.createIndexColumn((JavaTypeMapping)fkDiscrimMapping, (MappedStoreManager)this.storeMgr, (ClassLoaderResolver)clr, (DatastoreContainerObject)this, (ColumnMetaData)colmd, (boolean)false);
                        }
                        if (fkDiscrimMapping != null) {
                            this.getExternalFkDiscriminatorMappings().put(ownerFmd, fkDiscrimMapping);
                        }
                    }
                    this.addOrderMapping(ownerFmd, orderMapping, clr);
                    continue;
                }
                String ownerClassName = ownerFmd.getAbstractClassMetaData().getFullClassName();
                PersistenceCapableMapping fkMapping = new PersistenceCapableMapping();
                fkMapping.setDatastoreContainer((DatastoreContainerObject)this);
                fkMapping.initialize((DatastoreAdapter)this.dba, ownerClassName);
                fkDiscrimMapping = null;
                orderMapping = null;
                boolean duplicate = false;
                try {
                    JavaTypeMapping ownerIdMapping = this.storeMgr.getDatastoreClass(ownerClassName, clr).getIDMapping();
                    ElementMetaData colmdContainer = null;
                    if (ownerFmd.hasCollection() || ownerFmd.hasArray()) {
                        colmdContainer = ownerFmd.getElementMetaData();
                    } else if (ownerFmd.hasMap() && ownerFmd.getKeyMetaData() != null && ownerFmd.getKeyMetaData().getMappedBy() != null) {
                        colmdContainer = ownerFmd.getValueMetaData();
                    } else if (ownerFmd.hasMap() && ownerFmd.getValueMetaData() != null && ownerFmd.getValueMetaData().getMappedBy() != null) {
                        colmdContainer = ownerFmd.getKeyMetaData();
                    }
                    CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper((ColumnMetaDataContainer)colmdContainer, ownerIdMapping, true);
                    int countIdFields = ownerIdMapping.getNumberOfDatastoreFields();
                    for (int i = 0; i < countIdFields; ++i) {
                        DatastoreMapping refDatastoreMapping = ownerIdMapping.getDataStoreMapping(i);
                        JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType());
                        ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(((Column)refDatastoreMapping.getDatastoreField()).getIdentifier());
                        if (colmd == null) {
                            throw new NucleusUserException(LOCALISER.msg("057035", (Object)((Column)refDatastoreMapping.getDatastoreField()).getIdentifier(), (Object)this.toString())).setFatal();
                        }
                        DatastoreIdentifier identifier = null;
                        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
                        identifier = colmd.getName() == null || colmd.getName().length() < 1 ? idFactory.newForeignKeyFieldIdentifier(ownerFmd, null, refDatastoreMapping.getDatastoreField().getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(mapping.getJavaType()), 1) : idFactory.newDatastoreFieldIdentifier(colmd.getName());
                        DatastoreField refColumn = this.addDatastoreField(mapping.getJavaType().getName(), identifier, mapping, (MetaData)colmd);
                        ((Column)refDatastoreMapping.getDatastoreField()).copyConfigurationTo(refColumn);
                        if (colmd == null || colmd != null && colmd.getAllowsNull() == null || colmd != null && colmd.getAllowsNull() != null && colmd.isAllowsNull()) {
                            refColumn.setNullable();
                        }
                        fkMapping.addDataStoreMapping(this.getStoreManager().getMappingManager().createDatastoreMapping(mapping, refColumn, refDatastoreMapping.getJavaTypeMapping().getJavaType().getName()));
                        fkMapping.addJavaTypeMapping(mapping);
                    }
                }
                catch (DuplicateDatastoreFieldException dce) {
                    if (!ownerFmd.hasExtension("relation-discriminator-column")) {
                        throw dce;
                    }
                    Iterator<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> fkIter = this.getExternalFkMappings().entrySet().iterator();
                    fkMapping = null;
                    block5: while (fkIter.hasNext()) {
                        Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry;
                        entry = fkIter.next();
                        JavaTypeMapping existingFkMapping = entry.getValue();
                        for (int j = 0; j < existingFkMapping.getNumberOfDatastoreFields(); ++j) {
                            if (!existingFkMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString().equals(dce.getConflictingColumn().getIdentifier().toString())) continue;
                            fkMapping = existingFkMapping;
                            fkDiscrimMapping = this.externalFkDiscriminatorMappings.get(entry.getKey());
                            orderMapping = this.getExternalOrderMappings().get(entry.getKey());
                            continue block5;
                        }
                    }
                    if (fkMapping == null) {
                        throw dce;
                    }
                    duplicate = true;
                }
                if (!duplicate && ownerFmd.hasExtension("relation-discriminator-column")) {
                    String colName = ownerFmd.getValueForExtension("relation-discriminator-column");
                    if (colName == null) {
                        colName = "RELATION_DISCRIM";
                    }
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(colName);
                    colmd.setAllowsNull(Boolean.TRUE);
                    fkDiscrimMapping = this.storeMgr.getMappingManager().getMapping(String.class);
                    fkDiscrimMapping.setDatastoreContainer((DatastoreContainerObject)this);
                    ColumnCreator.createIndexColumn((JavaTypeMapping)fkDiscrimMapping, (MappedStoreManager)this.storeMgr, (ClassLoaderResolver)clr, (DatastoreContainerObject)this, (ColumnMetaData)colmd, (boolean)false);
                }
                this.getExternalFkMappings().put(ownerFmd, (JavaTypeMapping)fkMapping);
                if (fkDiscrimMapping != null) {
                    this.getExternalFkDiscriminatorMappings().put(ownerFmd, fkDiscrimMapping);
                }
                this.addOrderMapping(ownerFmd, orderMapping, clr);
            }
        }
    }

    private JavaTypeMapping addOrderMapping(AbstractMemberMetaData fmd, JavaTypeMapping orderMapping, ClassLoaderResolver clr) {
        boolean needsOrderMapping = false;
        OrderMetaData omd = fmd.getOrderMetaData();
        if (fmd.hasArray()) {
            needsOrderMapping = true;
        } else if (List.class.isAssignableFrom(fmd.getType())) {
            needsOrderMapping = true;
            if (omd != null && !omd.isIndexedList()) {
                needsOrderMapping = false;
            }
        } else if (Collection.class.isAssignableFrom(fmd.getType()) && omd != null && omd.isIndexedList() && omd.getMappedBy() == null) {
            needsOrderMapping = true;
        }
        if (needsOrderMapping) {
            this.state = 0;
            if (orderMapping == null) {
                orderMapping = this.addOrderColumn(fmd, clr);
            }
            this.getExternalOrderMappings().put(fmd, orderMapping);
            this.state = 2;
        }
        return orderMapping;
    }

    public String getType() {
        return this.cmd.getFullClassName();
    }

    @Override
    public IdentityType getIdentityType() {
        return this.cmd.getIdentityType();
    }

    @Override
    public final VersionMetaData getVersionMetaData() {
        return this.versionMetaData;
    }

    @Override
    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        return this.discriminatorMetaData;
    }

    public final ClassTable getTableWithDiscriminator() {
        ClassTable tbl;
        if (this.supertable != null && (tbl = this.supertable.getTableWithDiscriminator()) != null) {
            return tbl;
        }
        if (this.discriminatorMetaData != null) {
            return this;
        }
        if (this.cmd.getInheritanceMetaData() != null && this.cmd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isObjectIDDatastoreAttributed() {
        boolean attributed = this.storeMgr.isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getValueStrategy(), this.cmd.getIdentityType() == IdentityType.DATASTORE);
        if (attributed) {
            return true;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = (Column)this.columns.get(i);
            if (!col.isPrimaryKey() || !col.isIdentity()) continue;
            return true;
        }
        return false;
    }

    public boolean isBaseDatastoreClass() {
        return this.supertable == null;
    }

    public DatastoreClass getSuperDatastoreClass() {
        this.assertIsInitialized();
        return this.supertable;
    }

    public boolean isSuperDatastoreClass(DatastoreClass table) {
        if (this == table) {
            return true;
        }
        if (this.supertable != null) {
            if (table == this.supertable) {
                return true;
            }
            return this.supertable.isSuperDatastoreClass(table);
        }
        return false;
    }

    public Collection getSecondaryDatastoreClasses() {
        return this.secondaryTables != null ? this.secondaryTables.values() : null;
    }

    @Override
    public JavaTypeMapping getVersionMapping(boolean allowSuperclasses) {
        if (this.versionMapping != null) {
            return this.versionMapping;
        }
        if (allowSuperclasses && this.supertable != null) {
            return this.supertable.getVersionMapping(allowSuperclasses);
        }
        return null;
    }

    @Override
    public JavaTypeMapping getDiscriminatorMapping(boolean allowSuperclasses) {
        if (this.discriminatorMapping != null) {
            return this.discriminatorMapping;
        }
        if (allowSuperclasses && this.supertable != null) {
            return this.supertable.getDiscriminatorMapping(allowSuperclasses);
        }
        return null;
    }

    private ClassTable getSupertable(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        if (this.cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
            return null;
        }
        AbstractClassMetaData superCmd = theCmd.getSuperAbstractClassMetaData();
        if (superCmd != null) {
            if (superCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE) {
                return (ClassTable)this.storeMgr.getDatastoreClass(superCmd.getFullClassName(), clr);
            }
            if (superCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                return this.getSupertable(superCmd, clr);
            }
            return this.getSupertable(superCmd, clr);
        }
        return null;
    }

    public DatastoreClass getBaseDatastoreClassWithMember(AbstractMemberMetaData mmd) {
        if (mmd.isPrimaryKey() && this.getSuperDatastoreClass() != null) {
            return this.getSuperDatastoreClass().getBaseDatastoreClassWithMember(mmd);
        }
        if (this.memberMappingsMap.get(mmd) != null) {
            return this;
        }
        if (this.externalFkMappings != null && this.externalFkMappings.get(mmd) != null) {
            return this;
        }
        if (this.externalFkDiscriminatorMappings != null && this.externalFkDiscriminatorMappings.get(mmd) != null) {
            return this;
        }
        if (this.externalOrderMappings != null && this.externalOrderMappings.get(mmd) != null) {
            return this;
        }
        if (this.getSuperDatastoreClass() == null) {
            return this;
        }
        return this.getSuperDatastoreClass().getBaseDatastoreClassWithMember(mmd);
    }

    ClassMetaData getClassMetaData() {
        return this.cmd;
    }

    @Override
    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        DiscriminatorMetaData dismd;
        IndexMetaData idxmd;
        IndexMetaData idxmd2;
        Index index;
        int i;
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        HashSet<Index> indices = new HashSet<Index>();
        Set memberNumbersSet = this.memberMappingsMap.keySet();
        for (AbstractMemberMetaData fmd : memberNumbersSet) {
            Index index2;
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.memberMappingsMap.get(fmd);
            if (fieldMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)fieldMapping;
                for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                    JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                    IndexMetaData imd = embFieldMapping.getMemberMetaData().getIndexMetaData();
                    if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                    indices.add(index);
                }
                continue;
            }
            IndexMetaData imd = fmd.getIndexMetaData();
            if (imd == null || (index2 = TableUtils.getIndexForField(this, imd, fieldMapping)) == null) continue;
            indices.add(index2);
        }
        if (this.versionMapping != null && (idxmd2 = this.getVersionMetaData().getIndexMetaData()) != null) {
            Index index3 = new Index(this, idxmd2.isUnique() != null ? idxmd2.isUnique() : false, idxmd2.getValueForExtension("extended-setting"));
            if (idxmd2.getName() != null) {
                index3.setName(idxmd2.getName());
            }
            int countVersionFields = this.versionMapping.getNumberOfDatastoreFields();
            for (i = 0; i < countVersionFields; ++i) {
                index3.addDatastoreField(this.versionMapping.getDataStoreMapping(i).getDatastoreField());
            }
            indices.add(index3);
        }
        if (this.discriminatorMapping != null && (idxmd = (dismd = this.getDiscriminatorMetaData()).getIndexMetaData()) != null) {
            Index index4 = new Index(this, idxmd.isUnique() != null ? idxmd.isUnique() : false, idxmd.getValueForExtension("extended-setting"));
            if (idxmd.getName() != null) {
                index4.setName(idxmd.getName());
            }
            int countDiscrimFields = this.discriminatorMapping.getNumberOfDatastoreFields();
            for (int i2 = 0; i2 < countDiscrimFields; ++i2) {
                index4.addDatastoreField(this.discriminatorMapping.getDataStoreMapping(i2).getDatastoreField());
            }
            indices.add(index4);
        }
        Set<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> orderMappingsEntries = this.getExternalOrderMappings().entrySet();
        for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry : orderMappingsEntries) {
            AbstractMemberMetaData fmd = entry.getKey();
            JavaTypeMapping mapping = entry.getValue();
            OrderMetaData omd = fmd.getOrderMetaData();
            if (omd == null || omd.getIndexMetaData() == null || (index = this.getIndexForIndexMetaDataAndMapping(omd.getIndexMetaData(), mapping)) == null) continue;
            indices.add(index);
        }
        for (AbstractClassMetaData thisCmd : this.managedClassMetaData) {
            IndexMetaData[] classIndices = thisCmd.getIndexMetaData();
            if (classIndices == null) continue;
            for (int i3 = 0; i3 < classIndices.length; ++i3) {
                index = this.getIndexForIndexMetaData(classIndices[i3]);
                if (index == null) continue;
                indices.add(index);
            }
        }
        if (autoMode) {
            indices.addAll(super.getExpectedIndices(clr));
        }
        return indices;
    }

    private Index getIndexForIndexMetaDataAndMapping(IndexMetaData imd, JavaTypeMapping mapping) {
        boolean unique = false;
        if (imd.isUnique() != null && imd.isUnique().booleanValue()) {
            unique = true;
        }
        Index index = new Index(this, unique, imd.getValueForExtension("extended-setting"));
        if (imd.getName() != null) {
            index.setName(imd.getName());
        }
        int numCols = mapping.getNumberOfDatastoreFields();
        for (int i = 0; i < numCols; ++i) {
            index.addDatastoreField(mapping.getDataStoreMapping(i).getDatastoreField());
        }
        return index;
    }

    private Index getIndexForIndexMetaData(IndexMetaData imd) {
        boolean unique = false;
        if (imd.isUnique() != null && imd.isUnique().booleanValue()) {
            unique = true;
        }
        Index index = new Index(this, unique, imd.getValueForExtension("extended-setting"));
        if (imd.getName() != null) {
            index.setName(imd.getName());
        }
        ColumnMetaData[] colmds = imd.getColumnMetaData();
        AbstractMemberMetaData[] mmds = imd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (int i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column col = (Column)this.columnsByName.get(colName);
                if (col == null) {
                    NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("058001", (Object)this.toString(), (Object)index.getName(), (Object)colmds[i].getName()));
                    break;
                }
                index.addDatastoreField(col);
            }
        } else if (mmds != null && mmds.length > 0) {
            for (int i = 0; i < mmds.length; ++i) {
                AbstractMemberMetaData realFmd = this.getMetaDataForMember(mmds[i].getName());
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.memberMappingsMap.get(realFmd);
                int countFields = fieldMapping.getNumberOfDatastoreFields();
                for (int j = 0; j < countFields; ++j) {
                    index.addDatastoreField(fieldMapping.getDataStoreMapping(j).getDatastoreField());
                }
            }
        } else {
            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("058002", (Object)this.toString(), (Object)index.getName()));
            return null;
        }
        return index;
    }

    @Override
    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        ForeignKeyMetaData idFkmd;
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        Set memberNumbersSet = this.memberMappingsMap.keySet();
        for (AbstractMemberMetaData mmd : memberNumbersSet) {
            ForeignKey fk;
            JavaTypeMapping memberMapping = (JavaTypeMapping)this.memberMappingsMap.get(mmd);
            if (mmd.getEmbeddedMetaData() != null && memberMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)memberMapping;
                this.addExpectedForeignKeysForEmbeddedPCField(foreignKeys, autoMode, clr, embMapping);
                continue;
            }
            if (ClassUtils.isReferenceType((Class)mmd.getType()) && memberMapping instanceof ReferenceMapping) {
                Collection fks = TableUtils.getForeignKeysForReferenceField(memberMapping, mmd, autoMode, this.storeMgr, clr);
                foreignKeys.addAll(fks);
                continue;
            }
            if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(mmd.getType(), clr) == null || memberMapping.getNumberOfDatastoreFields() <= 0 || !(memberMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(memberMapping, mmd, autoMode, this.storeMgr, clr)) == null) continue;
            foreignKeys.add(fk);
        }
        ForeignKeyMetaData foreignKeyMetaData = idFkmd = this.cmd.getInheritanceMetaData().getJoinMetaData() != null ? this.cmd.getInheritanceMetaData().getJoinMetaData().getForeignKeyMetaData() : null;
        if (this.supertable != null && (autoMode || idFkmd != null && idFkmd.getDeleteAction() != ForeignKeyAction.NONE)) {
            ForeignKey fk = new ForeignKey(this.getIDMapping(), this.dba, this.supertable, false);
            if (idFkmd != null && idFkmd.getName() != null) {
                fk.setName(idFkmd.getName());
            }
            foreignKeys.add(0, fk);
        }
        for (AbstractClassMetaData thisCmd : this.managedClassMetaData) {
            ForeignKeyMetaData[] fkmds = thisCmd.getForeignKeyMetaData();
            if (fkmds == null) continue;
            for (int i = 0; i < fkmds.length; ++i) {
                ForeignKey fk = this.getForeignKeyForForeignKeyMetaData(fkmds[i]);
                if (fk == null) continue;
                foreignKeys.add(fk);
            }
        }
        HashMap<AbstractMemberMetaData, JavaTypeMapping> externalFks = this.getExternalFkMappings();
        if (!externalFks.isEmpty()) {
            Set<AbstractMemberMetaData> externalFkKeys = externalFks.keySet();
            for (AbstractMemberMetaData fmd : externalFkKeys) {
                DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(fmd.getAbstractClassMetaData().getFullClassName(), clr);
                if (referencedTable == null) continue;
                ForeignKeyMetaData fkmd = fmd.getForeignKeyMetaData();
                if (fkmd == null && fmd.getElementMetaData() != null) {
                    fkmd = fmd.getElementMetaData().getForeignKeyMetaData();
                }
                if ((fkmd == null || fkmd.getDeleteAction() == ForeignKeyAction.NONE) && !autoMode) continue;
                JavaTypeMapping fkMapping = externalFks.get(fmd);
                ForeignKey fk = new ForeignKey(fkMapping, this.dba, referencedTable, true);
                fk.setForMetaData(fkmd);
                if (foreignKeys.contains(fk)) continue;
                foreignKeys.add(fk);
            }
        }
        return foreignKeys;
    }

    private void addExpectedForeignKeysForEmbeddedPCField(List foreignKeys, boolean autoMode, ClassLoaderResolver clr, EmbeddedPCMapping embeddedMapping) {
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            ForeignKey fk;
            JavaTypeMapping embFieldMapping = embeddedMapping.getJavaTypeMapping(i);
            if (embFieldMapping instanceof EmbeddedPCMapping) {
                this.addExpectedForeignKeysForEmbeddedPCField(foreignKeys, autoMode, clr, (EmbeddedPCMapping)embFieldMapping);
                continue;
            }
            AbstractMemberMetaData embFmd = embFieldMapping.getMemberMetaData();
            if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                Collection fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                foreignKeys.addAll(fks);
                continue;
            }
            if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreFields() <= 0 || !(embFieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
            foreignKeys.add(fk);
        }
    }

    private ForeignKey getForeignKeyForForeignKeyMetaData(ForeignKeyMetaData fkmd) {
        int j;
        int i;
        if (fkmd == null) {
            return null;
        }
        ForeignKey fk = new ForeignKey(fkmd.isDeferred());
        fk.setForMetaData(fkmd);
        ClassMetaData acmd = this.cmd;
        if (fkmd.getTable() == null) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER.msg("058105", (Object)acmd.getFullClassName()));
            return null;
        }
        DatastoreIdentifier tableId = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(fkmd.getTable());
        ClassTable refTable = (ClassTable)this.storeMgr.getDatastoreClass(tableId);
        if (refTable == null) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER.msg("058106", (Object)acmd.getFullClassName(), (Object)fkmd.getTable()));
            return null;
        }
        PrimaryKey pk = refTable.getPrimaryKey();
        List targetCols = pk.getColumns();
        ArrayList<DatastoreField> sourceCols = new ArrayList<DatastoreField>();
        ColumnMetaData[] colmds = fkmd.getColumnMetaData();
        AbstractMemberMetaData[] fmds = fkmd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colId = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column sourceCol = (Column)this.columnsByName.get(colId);
                if (sourceCol == null) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER.msg("058107", (Object)acmd.getFullClassName(), (Object)fkmd.getTable(), (Object)colmds[i].getName(), (Object)this.toString()));
                    return null;
                }
                sourceCols.add(sourceCol);
            }
        } else if (fmds != null && fmds.length > 0) {
            for (i = 0; i < fmds.length; ++i) {
                AbstractMemberMetaData realFmd = this.getMetaDataForMember(fmds[i].getName());
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.memberMappingsMap.get(realFmd);
                int countDatastoreFields = fieldMapping.getNumberOfDatastoreFields();
                for (j = 0; j < countDatastoreFields; ++j) {
                    sourceCols.add(fieldMapping.getDataStoreMapping(i).getDatastoreField());
                }
            }
        }
        if (sourceCols.size() != targetCols.size()) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER.msg("058108", (Object)acmd.getFullClassName(), (Object)fkmd.getTable(), (Object)("" + sourceCols.size()), (Object)("" + targetCols.size())));
        }
        if (sourceCols.size() > 0) {
            for (i = 0; i < sourceCols.size(); ++i) {
                Column source = (Column)sourceCols.get(i);
                String targetColName = colmds[i].getTarget();
                Column target = (Column)targetCols.get(i);
                if (targetColName != null) {
                    for (j = 0; j < targetCols.size(); ++j) {
                        Column targetCol = (Column)targetCols.get(j);
                        if (!targetCol.getIdentifier().getIdentifierName().equalsIgnoreCase(targetColName)) continue;
                        target = targetCol;
                        break;
                    }
                }
                fk.addDatastoreField(source, target);
            }
        }
        return fk;
    }

    @Override
    protected List getExpectedCandidateKeys() {
        int i;
        this.assertIsInitialized();
        List candidateKeys = super.getExpectedCandidateKeys();
        Set fieldNumbersSet = this.memberMappingsMap.keySet();
        for (AbstractMemberMetaData fmd : fieldNumbersSet) {
            CandidateKey ck;
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.memberMappingsMap.get(fmd);
            if (fieldMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)fieldMapping;
                for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                    CandidateKey ck2;
                    JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                    UniqueMetaData umd = embFieldMapping.getMemberMetaData().getUniqueMetaData();
                    if (umd == null || (ck2 = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                    candidateKeys.add(ck2);
                }
                continue;
            }
            UniqueMetaData umd = fmd.getUniqueMetaData();
            if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, fieldMapping)) == null) continue;
            candidateKeys.add(ck);
        }
        for (AbstractClassMetaData thisCmd : this.managedClassMetaData) {
            UniqueMetaData[] classCKs = thisCmd.getUniqueMetaData();
            if (classCKs == null) continue;
            for (i = 0; i < classCKs.length; ++i) {
                CandidateKey ck = this.getCandidateKeyForUniqueMetaData(classCKs[i]);
                if (ck == null) continue;
                candidateKeys.add(ck);
            }
        }
        return candidateKeys;
    }

    private CandidateKey getCandidateKeyForUniqueMetaData(UniqueMetaData umd) {
        CandidateKey ck = new CandidateKey(this);
        if (umd.getName() != null) {
            ck.setName(umd.getName());
        }
        ColumnMetaData[] colmds = umd.getColumnMetaData();
        AbstractMemberMetaData[] mmds = umd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (int i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column col = (Column)this.columnsByName.get(colName);
                if (col == null) {
                    NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("058202", (Object)this.toString(), (Object)ck.getName(), (Object)colmds[i].getName()));
                    break;
                }
                ck.addDatastoreField(col);
            }
        } else if (mmds != null && mmds.length > 0) {
            for (int i = 0; i < mmds.length; ++i) {
                AbstractMemberMetaData realMmd = this.getMetaDataForMember(mmds[i].getName());
                JavaTypeMapping memberMapping = (JavaTypeMapping)this.memberMappingsMap.get(realMmd);
                int countFields = memberMapping.getNumberOfDatastoreFields();
                for (int j = 0; j < countFields; ++j) {
                    ck.addDatastoreField(memberMapping.getDataStoreMapping(j).getDatastoreField());
                }
            }
        } else {
            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("058203", (Object)this.toString(), (Object)ck.getName()));
            return null;
        }
        return ck;
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        PrimaryKey pk = super.getPrimaryKey();
        PrimaryKeyMetaData pkmd = this.cmd.getPrimaryKeyMetaData();
        if (pkmd != null && pkmd.getName() != null) {
            pk.setName(pkmd.getName());
        }
        return pk;
    }

    @Override
    protected List getSQLCreateStatements(Properties props) {
        List<String> stmts;
        Properties tableProps = null;
        if (this.createStatementDDL != null) {
            stmts = new ArrayList();
            StringTokenizer tokens = new StringTokenizer(this.createStatementDDL, ";");
            while (tokens.hasMoreTokens()) {
                stmts.add(tokens.nextToken());
            }
        } else {
            if (this.cmd.getExtensions() != null) {
                tableProps = new Properties();
                ExtensionMetaData[] emds = this.cmd.getExtensions();
                for (int i = 0; i < emds.length; ++i) {
                    if (!emds[i].getVendorName().equalsIgnoreCase("datanucleus")) continue;
                    tableProps.put(emds[i].getKey(), emds[i].getValue());
                }
            }
            stmts = super.getSQLCreateStatements(tableProps);
        }
        if (this.secondaryTables != null) {
            Set<String> secondaryTableNames = this.secondaryTables.keySet();
            Iterator<String> iter = secondaryTableNames.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = this.secondaryTables.get(iter.next());
                stmts.addAll(secTable.getSQLCreateStatements(tableProps));
            }
        }
        stmts.addAll(this.getSQLAddUniqueConstraintsStatements());
        return stmts;
    }

    @Override
    protected List getSQLDropStatements() {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        if (this.secondaryTables != null) {
            Set<String> secondaryTableNames = this.secondaryTables.keySet();
            Iterator<String> iter = secondaryTableNames.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = this.secondaryTables.get(iter.next());
                stmts.addAll(secTable.getSQLDropStatements());
            }
        }
        stmts.add(this.dba.getDropTableStatement(this));
        return stmts;
    }

    private List getSQLAddUniqueConstraintsStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        int ckNum = 0;
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        Iterator<CandidateKey> cks = this.candidateKeysByMapField.values().iterator();
        while (cks.hasNext()) {
            DatastoreIdentifier ckName = idFactory.newCandidateKeyIdentifier((DatastoreContainerObject)this, ++ckNum);
            CandidateKey ck = cks.next();
            ck.setName(ckName.getIdentifierName());
            stmts.add(this.dba.getAddCandidateKeyStatement(ck, idFactory));
        }
        return stmts;
    }

    private void initializeFKMapUniqueConstraints(AbstractMemberMetaData ownerMmd) {
        AbstractMemberMetaData mfmd = null;
        String map_field_name = ownerMmd.getMappedBy();
        if (map_field_name != null) {
            mfmd = this.cmd.getMetaDataForMember(map_field_name);
            if (mfmd == null) {
                AbstractClassMetaData managedCmd;
                Iterator<AbstractClassMetaData> cmdIter = this.managedClassMetaData.iterator();
                while (cmdIter.hasNext() && (mfmd = (managedCmd = cmdIter.next()).getMetaDataForMember(map_field_name)) == null) {
                }
            }
            if (mfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("057036", (Object)map_field_name, (Object)this.cmd.getFullClassName(), (Object)ownerMmd.getFullFieldName()));
            }
            if (mfmd != null && ownerMmd.getJoinMetaData() == null) {
                if (ownerMmd.getKeyMetaData() != null && ownerMmd.getKeyMetaData().getMappedBy() != null) {
                    AbstractMemberMetaData kmd = null;
                    String key_field_name = ownerMmd.getKeyMetaData().getMappedBy();
                    if (key_field_name != null) {
                        kmd = this.cmd.getMetaDataForMember(key_field_name);
                    }
                    if (kmd == null) {
                        AbstractClassMetaData managedCmd;
                        Iterator<AbstractClassMetaData> cmdIter = this.managedClassMetaData.iterator();
                        while (cmdIter.hasNext() && (kmd = (managedCmd = cmdIter.next()).getMetaDataForMember(key_field_name)) == null) {
                        }
                    }
                    if (kmd == null) {
                        throw new ClassDefinitionException(LOCALISER.msg("057007", (Object)mfmd.getFullFieldName(), (Object)key_field_name));
                    }
                    JavaTypeMapping ownerMapping = this.getMemberMapping(map_field_name);
                    JavaTypeMapping keyMapping = this.getMemberMapping(kmd.getName());
                    if ((this.dba.supportsOption("NullsInCandidateKeys") || !ownerMapping.isNullable() && !keyMapping.isNullable()) && keyMapping.getDatastoreContainer() == this && ownerMapping.getDatastoreContainer() == this) {
                        CandidateKey ck = new CandidateKey(this);
                        HashSet<Column> addedColumns = new HashSet<Column>();
                        int countOwnerFields = ownerMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countOwnerFields; ++i) {
                            Column col = (Column)ownerMapping.getDataStoreMapping(i).getDatastoreField();
                            addedColumns.add(col);
                            ck.addDatastoreField(col);
                        }
                        int countKeyFields = keyMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countKeyFields; ++i) {
                            Column col = (Column)keyMapping.getDataStoreMapping(i).getDatastoreField();
                            if (!addedColumns.contains(col)) {
                                addedColumns.add(col);
                                ck.addDatastoreField(col);
                                continue;
                            }
                            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("057041", (Object)ownerMmd.getName()));
                        }
                        if (this.candidateKeysByMapField.put(mfmd, ck) != null) {
                            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("057012", (Object)mfmd.getFullFieldName(), (Object)ownerMmd.getFullFieldName()));
                        }
                    }
                } else if (ownerMmd.getValueMetaData() != null && ownerMmd.getValueMetaData().getMappedBy() != null) {
                    AbstractMemberMetaData vmd = null;
                    String value_field_name = ownerMmd.getValueMetaData().getMappedBy();
                    if (value_field_name != null) {
                        vmd = this.cmd.getMetaDataForMember(value_field_name);
                    }
                    if (vmd == null) {
                        throw new ClassDefinitionException(LOCALISER.msg("057008", (Object)mfmd));
                    }
                    JavaTypeMapping ownerMapping = this.getMemberMapping(map_field_name);
                    JavaTypeMapping valueMapping = this.getMemberMapping(vmd.getName());
                    if ((this.dba.supportsOption("NullsInCandidateKeys") || !ownerMapping.isNullable() && !valueMapping.isNullable()) && valueMapping.getDatastoreContainer() == this && ownerMapping.getDatastoreContainer() == this) {
                        CandidateKey ck = new CandidateKey(this);
                        HashSet<Column> addedColumns = new HashSet<Column>();
                        int countOwnerFields = ownerMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countOwnerFields; ++i) {
                            Column col = (Column)ownerMapping.getDataStoreMapping(i).getDatastoreField();
                            addedColumns.add(col);
                            ck.addDatastoreField(col);
                        }
                        int countValueFields = valueMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countValueFields; ++i) {
                            Column col = (Column)valueMapping.getDataStoreMapping(i).getDatastoreField();
                            if (!addedColumns.contains(col)) {
                                addedColumns.add(col);
                                ck.addDatastoreField(col);
                                continue;
                            }
                            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("057042", (Object)ownerMmd.getName()));
                        }
                        if (this.candidateKeysByMapField.put(mfmd, ck) != null) {
                            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("057012", (Object)mfmd.getFullFieldName(), (Object)ownerMmd.getFullFieldName()));
                        }
                    }
                } else {
                    throw new ClassDefinitionException(LOCALISER.msg("057009", (Object)ownerMmd.getFullFieldName()));
                }
            }
        }
    }

    private void initializeIDMapping() {
        if (this.idMapping != null) {
            return;
        }
        PersistenceCapableMapping mapping = new PersistenceCapableMapping();
        mapping.setDatastoreContainer((DatastoreContainerObject)this);
        mapping.initialize(this.getStoreManager().getDatastoreAdapter(), this.cmd.getFullClassName());
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            mapping.addJavaTypeMapping(this.datastoreIDMapping);
        } else if (this.getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < this.pkMappings.length; ++i) {
                mapping.addJavaTypeMapping(this.pkMappings[i]);
            }
        }
        this.idMapping = mapping;
    }

    public JavaTypeMapping getIDMapping() {
        return this.idMapping;
    }

    private HashMap<AbstractMemberMetaData, JavaTypeMapping> getExternalOrderMappings() {
        if (this.externalOrderMappings == null) {
            this.externalOrderMappings = new HashMap();
        }
        return this.externalOrderMappings;
    }

    private HashMap<AbstractMemberMetaData, JavaTypeMapping> getExternalFkMappings() {
        if (this.externalFkMappings == null) {
            this.externalFkMappings = new HashMap();
        }
        return this.externalFkMappings;
    }

    public JavaTypeMapping getExternalMapping(AbstractMemberMetaData mmd, int mappingType) {
        if (mappingType == 5) {
            return this.getExternalFkMappings().get(mmd);
        }
        if (mappingType == 6) {
            return this.getExternalFkDiscriminatorMappings().get(mmd);
        }
        if (mappingType == 4) {
            return this.getExternalOrderMappings().get(mmd);
        }
        return null;
    }

    public AbstractMemberMetaData getMetaDataForExternalMapping(JavaTypeMapping mapping, int mappingType) {
        block4: {
            block5: {
                block3: {
                    if (mappingType != 5) break block3;
                    Set<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> entries = this.getExternalFkMappings().entrySet();
                    for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry : entries) {
                        if (entry.getValue() != mapping) continue;
                        return entry.getKey();
                    }
                    break block4;
                }
                if (mappingType != 6) break block5;
                Set<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> entries = this.getExternalFkDiscriminatorMappings().entrySet();
                for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry : entries) {
                    if (entry.getValue() != mapping) continue;
                    return entry.getKey();
                }
                break block4;
            }
            if (mappingType != 4) break block4;
            Set<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> entries = this.getExternalOrderMappings().entrySet();
            for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry : entries) {
                if (entry.getValue() != mapping) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private HashMap<AbstractMemberMetaData, JavaTypeMapping> getExternalFkDiscriminatorMappings() {
        if (this.externalFkDiscriminatorMappings == null) {
            this.externalFkDiscriminatorMappings = new HashMap();
        }
        return this.externalFkDiscriminatorMappings;
    }

    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return null;
        }
        if (mmd instanceof PropertyMetaData && mmd.getAbstractClassMetaData() instanceof InterfaceMetaData) {
            return this.getMemberMapping(mmd.getName());
        }
        if (mmd.isPrimaryKey()) {
            this.assertIsPKInitialized();
        } else {
            this.assertIsInitialized();
        }
        JavaTypeMapping m = (JavaTypeMapping)this.memberMappingsMap.get(mmd);
        if (m != null) {
            return m;
        }
        int ifc = this.cmd.getNoOfInheritedManagedMembers();
        if (mmd.getAbsoluteFieldNumber() < ifc && this.supertable != null && (m = this.supertable.getMemberMapping(mmd)) != null) {
            return m;
        }
        if (this.secondaryTables != null) {
            Collection<SecondaryTable> secTables = this.secondaryTables.values();
            for (SecondaryTable secTable : secTables) {
                m = secTable.getMemberMapping(mmd);
                if (m == null) continue;
                return m;
            }
        }
        return null;
    }

    public JavaTypeMapping getMemberMappingInDatastoreClass(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return null;
        }
        if (mmd instanceof PropertyMetaData && mmd.getAbstractClassMetaData() instanceof InterfaceMetaData) {
            return this.getMemberMapping(mmd.getName());
        }
        if (mmd.isPrimaryKey()) {
            this.assertIsPKInitialized();
        } else {
            this.assertIsInitialized();
        }
        JavaTypeMapping m = (JavaTypeMapping)this.memberMappingsMap.get(mmd);
        if (m != null) {
            return m;
        }
        return null;
    }

    public JavaTypeMapping getMemberMapping(String memberName) {
        this.assertIsInitialized();
        AbstractMemberMetaData mmd = this.getMetaDataForMember(memberName);
        JavaTypeMapping m = this.getMemberMapping(mmd);
        if (m == null) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), memberName);
        }
        return m;
    }

    AbstractMemberMetaData getMetaDataForMember(String memberName) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForMember(memberName);
        if (mmd == null) {
            for (AbstractClassMetaData theCmd : this.managedClassMetaData) {
                AbstractMemberMetaData foundMmd = theCmd.getMetaDataForMember(memberName);
                if (foundMmd == null) continue;
                if (!(mmd == null || mmd.toString().equalsIgnoreCase(foundMmd.toString()) && mmd.getType() == foundMmd.getType())) {
                    String errMsg = "Table " + this.getIdentifier() + " manages at least 2 subclasses that both define a field \"" + memberName + "\", " + "and the fields' metadata is different or they have different type! That means you can get e.g. wrong fetch results.";
                    NucleusLogger.DATASTORE.error((Object)errMsg);
                    throw new NucleusException(errMsg).setFatal();
                }
                mmd = foundMmd;
            }
        }
        return mmd;
    }

    void assertPCClass(StateManager sm) {
        Class<?> c = sm.getObject().getClass();
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.cmd.getFullClassName(), c)) {
            throw new NucleusException(LOCALISER.msg("057013", (Object)this.cmd.getFullClassName(), c)).setFatal();
        }
    }

    private JavaTypeMapping addOrderColumn(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        Class<Integer> indexType = Integer.class;
        IndexMapping indexMapping = new IndexMapping();
        indexMapping.initialize((DatastoreAdapter)this.dba, indexType.getName());
        indexMapping.setMemberMetaData(mmd);
        indexMapping.setDatastoreContainer((DatastoreContainerObject)this);
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier indexColumnName = null;
        ColumnMetaData colmd = null;
        OrderMetaData omd = mmd.getOrderMetaData();
        if (omd != null) {
            ColumnMetaData columnMetaData = colmd = omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 ? omd.getColumnMetaData()[0] : null;
            if (omd.getMappedBy() != null) {
                this.state = 2;
                JavaTypeMapping orderMapping = this.getMemberMapping(omd.getMappedBy());
                if (orderMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("057021", (Object)mmd.getFullFieldName(), (Object)omd.getMappedBy()));
                }
                if (!(orderMapping instanceof IntegerMapping) && !(orderMapping instanceof LongMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("057022", (Object)mmd.getFullFieldName(), (Object)omd.getMappedBy()));
                }
                return orderMapping;
            }
            String colName = null;
            if (omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 && omd.getColumnMetaData()[0].getName() != null) {
                colName = omd.getColumnMetaData()[0].getName();
                indexColumnName = idFactory.newDatastoreFieldIdentifier(colName);
            }
        }
        if (indexColumnName == null) {
            indexColumnName = idFactory.newForeignKeyFieldIdentifier(mmd, null, null, this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(indexType), 7);
        }
        DatastoreField column = this.addDatastoreField(indexType.getName(), indexColumnName, (JavaTypeMapping)indexMapping, (MetaData)colmd);
        if (colmd == null || colmd != null && colmd.getAllowsNull() == null || colmd != null && colmd.getAllowsNull() != null && colmd.isAllowsNull()) {
            column.setNullable();
        }
        this.storeMgr.getMappingManager().createDatastoreMapping((JavaTypeMapping)indexMapping, column, indexType.getName());
        return indexMapping;
    }

    @Override
    public void providePrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        if (this.pkMappings != null) {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            for (int i = 0; i < this.pkMappings.length; ++i) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.pkMappings[i], fmd);
            }
        } else {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            int countPkFields = this.cmd.getNoOfPrimaryKeyMembers();
            for (int i = 0; i < countPkFields; ++i) {
                AbstractMemberMetaData pkfmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.getMemberMapping(pkfmd), pkfmd);
            }
        }
    }

    public final void provideExternalMappings(MappingConsumer consumer, int mappingType) {
        block4: {
            block5: {
                block3: {
                    if (mappingType != 5 || this.externalFkMappings == null) break block3;
                    consumer.preConsumeMapping(this.highestMemberNumber + 1);
                    for (AbstractMemberMetaData fmd : this.externalFkMappings.keySet()) {
                        JavaTypeMapping fieldMapping = this.externalFkMappings.get(fmd);
                        if (fieldMapping == null) continue;
                        consumer.consumeMapping(fieldMapping, 5);
                    }
                    break block4;
                }
                if (mappingType != 6 || this.externalFkDiscriminatorMappings == null) break block5;
                consumer.preConsumeMapping(this.highestMemberNumber + 1);
                for (AbstractMemberMetaData fmd : this.externalFkDiscriminatorMappings.keySet()) {
                    JavaTypeMapping fieldMapping = this.externalFkDiscriminatorMappings.get(fmd);
                    if (fieldMapping == null) continue;
                    consumer.consumeMapping(fieldMapping, 6);
                }
                break block4;
            }
            if (mappingType != 4 || this.externalOrderMappings == null) break block4;
            consumer.preConsumeMapping(this.highestMemberNumber + 1);
            for (AbstractMemberMetaData fmd : this.externalOrderMappings.keySet()) {
                JavaTypeMapping fieldMapping = this.externalOrderMappings.get(fmd);
                if (fieldMapping == null) continue;
                consumer.consumeMapping(fieldMapping, 4);
            }
        }
    }

    @Override
    public void provideMappingsForMembers(MappingConsumer consumer, AbstractMemberMetaData[] fieldMetaData, boolean includeSecondaryTables) {
        super.provideMappingsForMembers(consumer, fieldMetaData, true);
        if (includeSecondaryTables && this.secondaryTables != null) {
            Collection<SecondaryTable> secTables = this.secondaryTables.values();
            for (SecondaryTable secTable : secTables) {
                secTable.provideMappingsForMembers(consumer, fieldMetaData, false);
            }
        }
    }

    public void provideUnmappedDatastoreFields(MappingConsumer consumer) {
        if (this.unmappedColumns != null) {
            Iterator<Column> iter = this.unmappedColumns.iterator();
            while (iter.hasNext()) {
                consumer.consumeUnmappedDatastoreField((DatastoreField)iter.next());
            }
        }
    }

    @Override
    public boolean validateConstraints(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean modified = false;
        if (super.validateConstraints(conn, autoCreate, autoCreateErrors, clr)) {
            modified = true;
        }
        if (this.secondaryTables != null) {
            Collection<SecondaryTable> secTables = this.secondaryTables.values();
            for (SecondaryTable secTable : secTables) {
                if (!secTable.validateConstraints(conn, autoCreate, autoCreateErrors, clr)) continue;
                modified = true;
            }
        }
        return modified;
    }

    private static class CallBack {
        final AbstractMemberMetaData fmd;

        public CallBack(AbstractMemberMetaData fmd) {
            this.fmd = fmd;
        }
    }
}

