/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.util.StringUtils;

public class StringLiteral
extends StringExpression
implements SQLLiteral {
    private final String value;

    public StringLiteral(SQLStatement stmt, JavaTypeMapping mapping) {
        super(stmt, null, mapping);
        this.isParameter = true;
        this.value = null;
        this.st.appendParameter(mapping, this.value);
    }

    public StringLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        if (value instanceof String) {
            this.value = (String)value;
        } else if (value instanceof Character) {
            this.value = ((Character)value).toString();
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.st.append('\'').append(StringUtils.replaceAll((String)this.value, (String)"'", (String)"''")).append('\'');
    }

    public void generateStatementWithoutQuotes() {
        this.st.clearStatement();
        this.st.append(StringUtils.replaceAll((String)this.value, (String)"'", (String)"''"));
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.equals(((StringLiteral)expr).value));
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), !this.value.equals(((StringLiteral)expr).value));
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) < 0);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) <= 0);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) > 0);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) >= 0);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (expr.isParameter || this.isParameter) {
            return super.add(expr);
        }
        if (expr instanceof StringLiteral) {
            return new StringLiteral(this.stmt, this.mapping, this.value.concat(((StringLiteral)expr).value));
        }
        if (expr instanceof CharacterLiteral) {
            return new StringLiteral(this.stmt, this.mapping, this.value.concat(((SQLLiteral)((Object)expr)).getValue().toString()));
        }
        if (expr instanceof IntegerLiteral || expr instanceof FloatingPointLiteral || expr instanceof BooleanLiteral) {
            return new StringLiteral(this.stmt, this.mapping, this.value.concat(((SQLLiteral)((Object)expr)).getValue().toString()));
        }
        return super.add(expr);
    }

    public SQLExpression invoke(String methodName, List args) {
        if (!this.isParameter) {
            if (methodName.equals("toUpperCase")) {
                return new StringLiteral(this.stmt, this.mapping, this.value.toUpperCase());
            }
            if (methodName.equals("toLowerCase")) {
                return new StringLiteral(this.stmt, this.mapping, this.value.toLowerCase());
            }
            if (methodName.equals("length")) {
                return new IntegerLiteral(this.stmt, this.mapping, new Integer(this.value.length()));
            }
            if (methodName.equals("trim")) {
                return new StringLiteral(this.stmt, this.mapping, this.value.trim());
            }
        }
        return super.invoke(methodName, args);
    }
}

