/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.util.NucleusLogger;

public class ObjectLiteral
extends ObjectExpression
implements SQLLiteral {
    private Object value;

    public ObjectLiteral(SQLStatement stmt, JavaTypeMapping mapping) {
        super(stmt, null, mapping);
        this.isParameter = true;
        this.value = null;
        this.st.appendParameter(mapping, this.value);
    }

    public ObjectLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        this.value = value;
        this.st.appendParameter(mapping, value);
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (this.value == null) {
            return new NullLiteral(this.stmt, null, (Object)null).eq(expr);
        }
        if (expr instanceof ObjectLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, this.value.equals(((ObjectLiteral)expr).value));
        }
        if (expr instanceof ObjectExpression) {
            BooleanExpression bExpr = this.getEqualityExpressionForObjectExpression((ObjectExpression)expr);
            return bExpr;
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (this.value == null) {
            return new NullLiteral(this.stmt, null, (Object)null).ne(expr);
        }
        if (expr instanceof ObjectLiteral) {
            return new BooleanLiteral(this.stmt, this.mapping, !this.value.equals(((ObjectLiteral)expr).value));
        }
        if (expr instanceof ObjectExpression) {
            BooleanExpression bExpr = this.getEqualityExpressionForObjectExpression((ObjectExpression)expr);
            return new BooleanExpression(this, Expression.OP_NOTEQ, bExpr);
        }
        return super.ne(expr);
    }

    protected BooleanExpression getEqualityExpressionForObjectExpression(ObjectExpression expr) {
        BooleanExpression bExpr;
        block13: {
            AbstractClassMetaData cmd;
            ApiAdapter api;
            SQLExpressionFactory exprFactory;
            RDBMSManager storeMgr;
            block15: {
                ClassLoaderResolver clr;
                block14: {
                    block12: {
                        bExpr = null;
                        storeMgr = this.stmt.getRDBMSManager();
                        exprFactory = storeMgr.getSQLExpressionFactory();
                        clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
                        if (!(this.value instanceof OID)) break block12;
                        JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(((OID)this.value).getKeyValue().getClass(), false);
                        SQLExpression oidExpr = exprFactory.newLiteral(this.stmt, m, ((OID)this.value).getKeyValue());
                        bExpr = expr.subExprs.getExpression(0).eq(oidExpr);
                        break block13;
                    }
                    api = storeMgr.getApiAdapter();
                    cmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.value.getClass(), clr);
                    if (cmd != null) break block14;
                    if (storeMgr.getApiAdapter().isSingleFieldIdentityClass(this.value.getClass().getName())) {
                        JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(api.getTargetClassForSingleFieldIdentity(this.value), false);
                        SQLExpression oidExpr = exprFactory.newLiteral(this.stmt, m, api.getTargetKeyForSingleFieldIdentity(this.value));
                        bExpr = expr.subExprs.getExpression(0).eq(oidExpr);
                    } else {
                        String pcClassName = storeMgr.getClassNameForObjectID(this.value, clr, null);
                        if (pcClassName != null) {
                            cmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(pcClassName, clr);
                            bExpr = ExpressionUtils.getAppIdEqualityExpression(this.value, expr, storeMgr, clr, cmd, null, null);
                        } else {
                            bExpr = exprFactory.newLiteral(this.stmt, this.mapping, false).eq(exprFactory.newLiteral(this.stmt, this.mapping, true));
                        }
                    }
                    break block13;
                }
                if (cmd.getIdentityType() != IdentityType.APPLICATION) break block15;
                if (api.getIdForObject(this.value) != null) {
                    int i;
                    JavaTypeMapping[] pkMappingsApp = new JavaTypeMapping[expr.subExprs.size()];
                    Object[] pkFieldValues = new Object[expr.subExprs.size()];
                    int position = 0;
                    ObjectManager om = api.getObjectManager(this.value);
                    for (i = 0; i < cmd.getNoOfPrimaryKeyMembers(); ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
                        Object fieldValue = ExpressionUtils.getValueForMemberOfObject(om, mmd, this.value);
                        JavaTypeMapping mapping = storeMgr.getSQLExpressionFactory().getMappingForType(fieldValue.getClass(), false);
                        if (mapping instanceof PersistenceCapableMapping) {
                            position = ExpressionUtils.populatePrimaryKeyMappingsValuesForPCMapping(pkMappingsApp, pkFieldValues, position, (PersistenceCapableMapping)mapping, cmd, mmd, fieldValue, storeMgr, clr);
                            continue;
                        }
                        pkMappingsApp[position] = mapping;
                        pkFieldValues[position] = fieldValue;
                        ++position;
                    }
                    for (i = 0; i < expr.subExprs.size(); ++i) {
                        ColumnExpression source = expr.subExprs.getExpression(i);
                        SQLExpression target = exprFactory.newLiteral(this.stmt, pkMappingsApp[i], pkFieldValues[i]);
                        bExpr = bExpr == null ? ((SQLExpression)source).eq(target) : bExpr.and(((SQLExpression)source).eq(target));
                    }
                } else {
                    for (int i = 0; i < expr.subExprs.size(); ++i) {
                        NucleusLogger.QUERY.warn((Object)LOCALISER.msg("037003", this.value));
                        bExpr = exprFactory.newLiteral(this.stmt, this.mapping, false).eq(exprFactory.newLiteral(this.stmt, this.mapping, true));
                    }
                }
                break block13;
            }
            if (cmd.getIdentityType() != IdentityType.DATASTORE) break block13;
            for (int i = 0; i < expr.subExprs.size(); ++i) {
                ColumnExpression source = expr.subExprs.getExpression(i);
                OID objectId = (OID)api.getIdForObject(this.value);
                if (objectId == null) {
                    NucleusLogger.QUERY.warn((Object)LOCALISER.msg("037003", this.value));
                    bExpr = exprFactory.newLiteral(this.stmt, this.mapping, false).eq(exprFactory.newLiteral(this.stmt, this.mapping, true));
                    continue;
                }
                JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(objectId.getKeyValue().getClass(), false);
                SQLExpression oidExpr = exprFactory.newLiteral(this.stmt, m, objectId.getKeyValue());
                bExpr = ((SQLExpression)source).eq(oidExpr);
            }
        }
        return bExpr;
    }

    public String toString() {
        if (this.value != null) {
            return super.toString() + " = " + this.value.toString();
        }
        return super.toString() + " = NULL";
    }
}

