/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class MapLiteral
extends SQLExpression
implements SQLLiteral {
    private final Map value;
    private final boolean isEmpty;
    private final boolean containsNull;
    private final MapValueLiteral mapValueLiteral;
    private final MapKeyLiteral mapKeyLiteral;

    public MapLiteral(SQLStatement stmt, JavaTypeMapping mapping) {
        super(stmt, null, mapping);
        this.isParameter = true;
        this.value = null;
        this.isEmpty = false;
        this.containsNull = false;
        this.mapKeyLiteral = null;
        this.mapValueLiteral = null;
        this.st.appendParameter(mapping, this.value);
    }

    public MapLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        Map mapValue;
        if (!(value instanceof Map)) {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.value = mapValue = (Map)value;
        this.mapValueLiteral = new MapValueLiteral(stmt, mapping, value);
        this.mapKeyLiteral = new MapKeyLiteral(stmt, mapping, value);
        this.containsNull = mapValue != null && mapValue.containsValue(null);
        this.isEmpty = mapValue == null || mapValue.isEmpty() || mapValue.size() == 1 && this.containsNull;
    }

    public SQLExpression invoke(String methodName, List args) {
        if (!this.isParameter) {
            if (methodName.equals("isEmpty") && args.size() == 0) {
                return new BooleanLiteral(this.stmt, this.mapping, this.isEmpty ? Boolean.TRUE : Boolean.FALSE);
            }
            if (methodName.equals("size")) {
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, new Integer(this.value.size()));
            }
            if (methodName.equals("containsKey")) {
                if (this.isEmpty) {
                    return new BooleanLiteral(this.stmt, this.mapping, Boolean.FALSE);
                }
                return this.mapKeyLiteral.invoke("contains", args);
            }
            if (methodName.equals("containsValue")) {
                if (this.isEmpty) {
                    return new BooleanLiteral(this.stmt, this.mapping, Boolean.FALSE);
                }
                return this.mapValueLiteral.invoke("contains", args);
            }
            if (!methodName.equals("containsEntry") && methodName.equals("get")) {
                if (this.value == null) {
                    return new NullLiteral(this.stmt, null, (Object)null);
                }
                return this.mapKeyLiteral.invoke("get", args);
            }
        }
        return super.invoke(methodName, args);
    }

    public Object getValue() {
        return this.value;
    }

    class MapValueLiteral
    extends SQLExpression
    implements SQLLiteral {
        private final Map value;
        private List scalarExpressions;

        public MapValueLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
            super(stmt, null, mapping);
            if (value instanceof Map) {
                boolean isEmpty;
                Map mapValue;
                this.value = mapValue = (Map)value;
                boolean bl = isEmpty = mapValue == null || mapValue.isEmpty() || mapValue.size() == 1 && MapLiteral.this.containsNull;
                if (!isEmpty) {
                    RDBMSManager storeMgr = stmt.getRDBMSManager();
                    this.scalarExpressions = new ArrayList();
                    this.st.append("(");
                    boolean hadPrev = false;
                    Collection values = mapValue.values();
                    for (Object current : values) {
                        if (null == current) continue;
                        JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(current.getClass(), false);
                        SQLExpression expr = storeMgr.getSQLExpressionFactory().newLiteral(stmt, m, current);
                        this.st.append(hadPrev ? "," : "");
                        this.st.append(expr);
                        this.scalarExpressions.add(expr);
                        hadPrev = true;
                    }
                    this.st.append(")");
                }
            } else {
                throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
            }
        }

        public SQLExpression invoke(String methodName, List args) {
            if (methodName.equals("contains") && args.size() == 1) {
                SQLExpression argExpr = (SQLExpression)args.get(0);
                SQLExpression bExpr = null;
                for (int i = 0; i < this.scalarExpressions.size(); ++i) {
                    bExpr = bExpr == null ? ((SQLExpression)this.scalarExpressions.get(i)).eq(argExpr) : ((BooleanExpression)bExpr).ior(((SQLExpression)this.scalarExpressions.get(i)).eq(argExpr));
                }
                bExpr.encloseInParentheses();
                return bExpr;
            }
            return super.invoke(methodName, args);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getRawValue() {
            return null;
        }

        public void setRawValue(Object val) {
        }
    }

    class MapKeyLiteral
    extends SQLExpression
    implements SQLLiteral {
        private final Map value;
        private List scalarExpressions;

        public MapKeyLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
            super(stmt, null, mapping);
            if (value instanceof Map) {
                boolean isEmpty;
                Map mapValue;
                this.value = mapValue = (Map)value;
                boolean bl = isEmpty = mapValue == null || mapValue.isEmpty() || mapValue.size() == 1 && MapLiteral.this.containsNull;
                if (!isEmpty) {
                    RDBMSManager storeMgr = stmt.getRDBMSManager();
                    this.st.append("(");
                    this.scalarExpressions = new ArrayList();
                    boolean hadPrev = false;
                    Set keys = mapValue.keySet();
                    for (Object current : keys) {
                        if (null == current) continue;
                        JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(current.getClass(), false);
                        SQLExpression expr = storeMgr.getSQLExpressionFactory().newLiteral(stmt, m, current);
                        this.st.append(hadPrev ? "," : "");
                        this.st.append(expr);
                        this.scalarExpressions.add(expr);
                        hadPrev = true;
                    }
                    this.st.append(")");
                }
            } else {
                throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
            }
        }

        public SQLExpression invoke(String methodName, List args) {
            if (methodName.equals("contains") && args.size() == 1) {
                SQLExpression argExpr = (SQLExpression)args.get(0);
                SQLExpression bExpr = null;
                for (int i = 0; i < this.scalarExpressions.size(); ++i) {
                    bExpr = bExpr == null ? ((SQLExpression)this.scalarExpressions.get(i)).eq(argExpr) : ((BooleanExpression)bExpr).ior(((SQLExpression)this.scalarExpressions.get(i)).eq(argExpr));
                }
                bExpr.encloseInParentheses();
                return bExpr;
            }
            if (methodName.equals("get") && args.size() == 1) {
                SQLExpression argExpr = (SQLExpression)args.get(0);
                if (argExpr instanceof SQLLiteral) {
                    Object val = this.value.get(((SQLLiteral)((Object)argExpr)).getValue());
                    if (val == null) {
                        return new NullLiteral(this.stmt, null, (Object)null);
                    }
                    JavaTypeMapping m = this.stmt.getRDBMSManager().getSQLExpressionFactory().getMappingForType(val.getClass(), false);
                    return new ObjectLiteral(this.stmt, m, val);
                }
                throw new IllegalExpressionOperationException(this, "getMethod", argExpr);
            }
            return super.invoke(methodName, args);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getRawValue() {
            return null;
        }

        public void setRawValue(Object val) {
        }
    }
}

