/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.ArrayExpression;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class ArrayLiteral
extends ArrayExpression
implements SQLLiteral {
    Object value;

    public ArrayLiteral(SQLStatement stmt, JavaTypeMapping mapping) {
        super(stmt, null, mapping);
        this.isParameter = true;
        this.value = null;
        this.st.appendParameter(mapping, null);
    }

    public ArrayLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object literal) {
        super(stmt, null, mapping);
        this.value = literal;
        if (this.value == null || !this.value.getClass().isArray()) {
            throw new NucleusUserException("Invalid argument literal : " + this.value);
        }
    }

    public SQLExpression invoke(String methodName, List args) {
        if (!this.isParameter && (methodName.equals("size") || methodName.equals("length"))) {
            JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
            return new IntegerLiteral(this.stmt, m, new Integer(Array.getLength(this.value)));
        }
        return super.invoke(methodName, args);
    }

    public Object getValue() {
        return this.value;
    }
}

