/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;

public final class PersistentIDROF
implements ResultObjectFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    private final MappedStoreManager storeMgr;
    private final DatastoreClass table;
    protected final AbstractClassMetaData acmd;
    private Class persistentClass;
    protected StatementMappingForClass stmtMapping = null;
    protected boolean discriminator;
    protected final FetchPlan fetchPlan;
    private final boolean ignoreCache;
    private Map resolvedClasses = new SoftValueMap();

    public PersistentIDROF(MappedStoreManager storeMgr, DatastoreClass table, AbstractClassMetaData acmd, StatementMappingForClass mappingDefinition, boolean ignoreCache, boolean discriminator, FetchPlan fetchPlan, Class persistentClass) {
        if (mappingDefinition == null) {
            throw new NucleusException("Attempt to create PersistentIDROF with null mappingDefinition");
        }
        this.stmtMapping = mappingDefinition;
        this.acmd = acmd;
        this.table = table;
        this.storeMgr = storeMgr;
        this.ignoreCache = ignoreCache;
        this.fetchPlan = fetchPlan;
        this.persistentClass = persistentClass;
        this.discriminator = discriminator;
    }

    public void setPersistentClass(Class cls) {
        this.persistentClass = cls;
    }

    public Object getObject(ObjectManager om, Object rs) {
        int[] mappedFieldNumbers;
        StatementMappingForClass mappingDefinition;
        String[] subclasses;
        String className = null;
        boolean requiresInheritanceCheck = true;
        StatementMappingIndex discrimMapIdx = this.stmtMapping.getMappingForMemberPosition(StatementMappingForClass.MEMBER_DISCRIMINATOR);
        if (discrimMapIdx != null && this.table != null) {
            try {
                String discrimValue = ((ResultSet)rs).getString(discrimMapIdx.getColumnPositions()[0]);
                JavaTypeMapping discrimMapping = discrimMapIdx.getMapping();
                DiscriminatorMetaData dismd = discrimMapping != null ? discrimMapping.getDatastoreContainer().getDiscriminatorMetaData() : null;
                className = RDBMSQueryUtils.getClassNameFromDiscriminatorValue(discrimValue, dismd, om);
            }
            catch (SQLException sqle) {}
        } else if (this.discriminator && this.table != null) {
            JavaTypeMapping discrimMapping = this.table.getDiscriminatorMapping(true);
            DiscriminatorMetaData dismd = discrimMapping != null ? discrimMapping.getDatastoreContainer().getDiscriminatorMetaData() : null;
            className = RDBMSQueryUtils.getClassNameFromDiscriminatorResultSetRow(discrimMapping, dismd, (ResultSet)rs, om);
        } else if (this.stmtMapping.getNucleusTypeColumnName() != null) {
            try {
                className = ((ResultSet)rs).getString(this.stmtMapping.getNucleusTypeColumnName()).trim();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class pcClassForObject = this.persistentClass;
        if (className != null) {
            Class cls = (Class)this.resolvedClasses.get(className);
            if (cls != null) {
                pcClassForObject = cls;
            } else {
                pcClassForObject = this.persistentClass.getName().equals(className) ? this.persistentClass : clr.classForName(className, this.persistentClass.getClassLoader());
                this.resolvedClasses.put(className, pcClassForObject);
            }
            requiresInheritanceCheck = false;
        }
        if (Modifier.isAbstract(pcClassForObject.getModifiers()) && (subclasses = om.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) != null) {
            for (int i = 0; i < subclasses.length; ++i) {
                Class subcls = clr.classForName(subclasses[i]);
                if (!Modifier.isAbstract(subcls.getModifiers())) {
                    NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("052300", (Object)pcClassForObject.getName(), (Object)subcls.getName()));
                    pcClassForObject = subcls;
                    break;
                }
                if (i != subclasses.length - 1) continue;
                throw new NucleusUserException(LOCALISER.msg("052301", (Object)pcClassForObject.getName()));
            }
        }
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr);
        int[] fieldNumbers = this.stmtMapping.getMemberNumbers();
        if (this.acmd instanceof InterfaceMetaData) {
            mappingDefinition = new StatementMappingForClass(null);
            mappingDefinition.setNucleusTypeColumnName(this.stmtMapping.getNucleusTypeColumnName());
            mappedFieldNumbers = new int[fieldNumbers.length];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                mappedFieldNumbers[i] = cmd.getAbsolutePositionOfMember(mmd.getName());
                mappingDefinition.addMappingForMember(mappedFieldNumbers[i], this.stmtMapping.getMappingForMemberPosition(fieldNumbers[i]));
            }
        } else {
            mappingDefinition = this.stmtMapping;
            mappedFieldNumbers = fieldNumbers;
        }
        Object obj = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            obj = this.getObjectForApplicationId(om, rs, mappingDefinition, mappedFieldNumbers, cmd, pcClassForObject, requiresInheritanceCheck);
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping = this.stmtMapping.getMappingForMemberPosition(StatementMappingForClass.MEMBER_DATASTORE_ID);
            JavaTypeMapping mapping = datastoreIdMapping.getMapping();
            OID oid = (OID)mapping.getObject(om, rs, datastoreIdMapping.getColumnPositions());
            if (oid != null) {
                OID id = oid;
                if (!pcClassForObject.getName().equals(oid.getPcClass())) {
                    id = OIDFactory.getInstance((ObjectManager)om, (String)pcClassForObject.getName(), (Object)oid.getKeyValue());
                }
                obj = mappedFieldNumbers == null ? om.findObject((Object)id, false, requiresInheritanceCheck, null) : this.getObjectForDatastoreId(om, rs, mappingDefinition, mappedFieldNumbers, cmd, id, requiresInheritanceCheck ? null : pcClassForObject);
            }
        } else if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            Object id = om.newObjectId(className, null);
            obj = mappedFieldNumbers == null ? om.findObject(id, false, requiresInheritanceCheck, null) : this.getObjectForDatastoreId(om, rs, mappingDefinition, mappedFieldNumbers, cmd, id, pcClassForObject);
        }
        if (obj != null) {
            StatementMappingIndex versionMapping;
            StateManager objSM;
            Object verFieldValue;
            int versionFieldNumber = -1;
            VersionMetaData vermd = cmd.getVersionMetaData();
            if (vermd != null && vermd.getFieldName() != null && this.stmtMapping.getMappingForMemberPosition(versionFieldNumber = this.acmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = (objSM = om.findStateManager(obj)).provideField(versionFieldNumber)) != null) {
                objSM.setVersion(verFieldValue);
            }
            if ((versionMapping = this.stmtMapping.getMappingForMemberPosition(StatementMappingForClass.MEMBER_VERSION)) != null) {
                JavaTypeMapping mapping = versionMapping.getMapping();
                Object version = mapping.getObject(om, rs, versionMapping.getColumnPositions());
                StateManager objSM2 = om.findStateManager(obj);
                objSM2.setVersion(version);
            }
        }
        return obj;
    }

    private Object getObjectForApplicationId(ObjectManager om, final Object resultSet, final StatementMappingForClass mappingDefinition, final int[] fieldNumbers, AbstractClassMetaData cmd, Class pcClass, boolean requiresInheritanceCheck) {
        int[] pkNumbers = cmd.getPKMemberPositions();
        ResultSet rs = (ResultSet)resultSet;
        boolean nullObject = true;
        block2: for (int i = 0; i < pkNumbers.length; ++i) {
            StatementMappingIndex pkIdx = mappingDefinition.getMappingForMemberPosition(pkNumbers[i]);
            for (int j = 0; j < pkIdx.getColumnPositions().length; ++j) {
                try {
                    Object obj = rs.getObject(pkIdx.getColumnPositions()[0]);
                    if (obj != null) {
                        nullObject = false;
                        continue block2;
                    }
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
                if (!nullObject) continue block2;
            }
        }
        if (nullObject) {
            return null;
        }
        return om.findObjectUsingAID(pcClass, new FieldValues(){

            public void fetchFields(StateManager sm) {
                FieldManager fm = PersistentIDROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceFields(fieldNumbers, fm, false);
            }

            public void fetchNonLoadedFields(StateManager sm) {
                FieldManager fm = PersistentIDROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentIDROF.this.fetchPlan;
            }
        }, this.ignoreCache, requiresInheritanceCheck);
    }

    private Object getObjectForDatastoreId(ObjectManager om, final Object resultSet, final StatementMappingForClass mappingDefinition, final int[] fieldNumbers, AbstractClassMetaData cmd, Object oid, Class pcClass) {
        if (oid == null) {
            return null;
        }
        if (pcClass == null) {
            return om.findObject(oid, new FieldValues(){

                public void fetchFields(StateManager sm) {
                    FieldManager fm = PersistentIDROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                    sm.replaceFields(fieldNumbers, fm, false);
                }

                public void fetchNonLoadedFields(StateManager sm) {
                    FieldManager fm = PersistentIDROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                    sm.replaceNonLoadedFields(fieldNumbers, fm);
                }

                public FetchPlan getFetchPlanForLoading() {
                    return PersistentIDROF.this.fetchPlan;
                }
            });
        }
        return om.findObject(oid, new FieldValues(){

            public void fetchFields(StateManager sm) {
                FieldManager fm = PersistentIDROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceFields(fieldNumbers, fm, false);
            }

            public void fetchNonLoadedFields(StateManager sm) {
                FieldManager fm = PersistentIDROF.this.storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentIDROF.this.fetchPlan;
            }
        }, pcClass, this.ignoreCache);
    }
}

