/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.ExpressionHelper;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.FKMapStore;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.mapped.scostore.MapKeySetStore;
import org.datanucleus.store.mapped.scostore.MapValueSetStore;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractMapStoreSpecialization;
import org.datanucleus.store.rdbms.scostore.RDBMSMapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapKeySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapValueSetStore;
import org.datanucleus.store.scostore.MapStore;

public class RDBMSFKMapStore
extends FKMapStore {
    private String updateFkStmt;

    public RDBMSFKMapStore(AbstractMemberMetaData mmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super(mmd, (MappedStoreManager)storeMgr, clr, (AbstractMapStoreSpecialization)new RDBMSAbstractMapStoreSpecialization(LOCALISER, clr, storeMgr));
        this.getSpecialization().initialise((AbstractMapStore)this);
    }

    private RDBMSManager getStoreMgr() {
        return (RDBMSManager)this.storeMgr;
    }

    private RDBMSAbstractMapStoreSpecialization getSpecialization() {
        return (RDBMSAbstractMapStoreSpecialization)this.specialization;
    }

    protected void initialise() {
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    private String getUpdateFkStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.getMapTable().toString());
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        if (this.keyFieldNumber >= 0) {
            for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        } else {
            for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateValueFkInternal(StateManager sm, Object value, Object owner) {
        boolean retval;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, (Object)ps, ExpressionHelper.getParametersIndex((int)1, (JavaTypeMapping)this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, (Object)ps, ExpressionHelper.getParametersIndex((int)1, (JavaTypeMapping)this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    }
                    jdbcPosition = this.getSpecialization().populateValueInStatement(om, ps, value, jdbcPosition, this.valueMapping);
                    sqlControl.executeStatementUpdate(mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateKeyFkInternal(StateManager sm, Object key, Object owner) {
        boolean retval;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, (Object)ps, ExpressionHelper.getParametersIndex((int)1, (JavaTypeMapping)this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, (Object)ps, ExpressionHelper.getParametersIndex((int)1, (JavaTypeMapping)this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    }
                    jdbcPosition = this.getSpecialization().populateKeyInStatement(om, ps, key, jdbcPosition, this.keyMapping);
                    sqlControl.executeStatementUpdate(mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    protected MapKeySetStore newMapKeySetStore() {
        return new RDBMSMapKeySetStore((DatastoreContainerObject)this.valueTable, this.ownerMapping, this.keyMapping, this.clr, this.ownerMemberMetaData, this.getStoreMgr());
    }

    protected MapValueSetStore newMapValueSetStore() {
        return new RDBMSMapValueSetStore(this.valueTable, this.ownerMapping, this.valueMapping, (MapStore)this, this.clr, this.ownerMemberMetaData, this.getStoreMgr());
    }

    protected MapEntrySetStore newMapEntrySetStore() {
        return new RDBMSMapEntrySetStore((DatastoreContainerObject)this.valueTable, this.ownerMapping, this.keyMapping, this.valueMapping, (MapStore)this, this.getStoreMgr());
    }
}

