/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.expression.AggregateExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NewObjectExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.query.RDBMSDiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.RDBMSUnionIteratorStatement;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.util.Localiser;

public class ResultExpressionsQueryable
implements Queryable {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    private final MappedStoreManager storeMgr;
    private final ClassLoaderResolver clr;
    private final Class candidateClass;
    private final Collection userCandidates;
    private final boolean subclasses;
    private ScalarExpression[] expressions;
    private Boolean hasAggregatedExpressionsOnly = null;

    public ResultExpressionsQueryable(ObjectManager om, Class candidateClass, boolean subclasses) {
        this.candidateClass = candidateClass;
        this.storeMgr = (MappedStoreManager)om.getStoreManager();
        this.clr = om.getClassLoaderResolver();
        this.subclasses = subclasses;
        this.userCandidates = null;
    }

    public ResultExpressionsQueryable(ObjectManager om, Class candidateClass, Collection userCandidates, boolean subclasses) {
        this.userCandidates = userCandidates;
        this.candidateClass = candidateClass;
        this.storeMgr = (MappedStoreManager)om.getStoreManager();
        this.clr = om.getClassLoaderResolver();
        this.subclasses = subclasses;
    }

    public QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.candidateClass, null);
    }

    public QueryExpression newQueryStatement(Class candidateClass, DatastoreIdentifier candidateAlias) {
        DatastoreClass datastoreClass = this.storeMgr.getDatastoreClass(candidateClass.getName(), this.clr);
        JavaTypeMapping m = datastoreClass.getIDMapping();
        Class type = candidateClass;
        boolean subclasses = this.subclasses;
        QueryExpression stmt = null;
        stmt = !this.queryUsingDiscriminator(datastoreClass) && !subclasses && this.hasAggregatedExpressionsOnly() ? new RDBMSDiscriminatorIteratorStatement(this.clr, new Class[]{type}, subclasses, (StoreManager)this.storeMgr, false).getQueryStatement(candidateAlias) : (this.queryUsingDiscriminator(datastoreClass) || this.hasAggregatedExpressionsOnly() ? new RDBMSDiscriminatorIteratorStatement(this.clr, new Class[]{type}, subclasses, (StoreManager)this.storeMgr, false).getQueryStatement(candidateAlias) : new RDBMSUnionIteratorStatement(this.clr, candidateClass, subclasses, (StoreManager)this.storeMgr, type, m, (DatastoreContainerObject)datastoreClass, false, Boolean.FALSE, true, false).getQueryStatement(candidateAlias));
        if (this.userCandidates != null) {
            BooleanExpression elementsExpr = null;
            for (Object candidateValue : this.userCandidates) {
                ScalarExpression expr = m.newScalarExpression(stmt, stmt.getMainTableExpression());
                BooleanExpression keyExpr = expr.eq(m.newLiteral(stmt, candidateValue));
                if (elementsExpr == null) {
                    elementsExpr = keyExpr;
                    continue;
                }
                elementsExpr = elementsExpr.ior((ScalarExpression)keyExpr);
            }
            if (elementsExpr != null) {
                stmt.andCondition(elementsExpr, true);
            }
        }
        return stmt;
    }

    public void setHasAggregatedExpressionsOnly(boolean flag) {
        this.hasAggregatedExpressionsOnly = flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setResultExpressions(ScalarExpression[] expressions) {
        this.expressions = expressions;
    }

    public ScalarExpression[] getResultExpressions() {
        return this.expressions;
    }

    public boolean hasAggregatedExpressionsOnly() {
        if (this.hasAggregatedExpressionsOnly != null) {
            return this.hasAggregatedExpressionsOnly;
        }
        boolean aggregatedOnly = true;
        if (this.expressions == null) {
            return false;
        }
        for (int i = 0; this.expressions != null && i < this.expressions.length; ++i) {
            if (this.expressions[i] instanceof AggregateExpression) continue;
            aggregatedOnly = false;
        }
        return aggregatedOnly;
    }

    private boolean queryUsingDiscriminator(DatastoreClass table) {
        if (table.getDiscriminatorMetaData() == null || table.getDiscriminatorMapping(false) == null) {
            return false;
        }
        if (this.subclasses) {
            for (String subCandidateName : this.storeMgr.getSubClassesForClass(this.candidateClass.getName(), true, this.clr)) {
                if (table.managesClass(subCandidateName)) continue;
                return false;
            }
        }
        return true;
    }

    private void selectNewObjectExpression(QueryExpression stmt, List stmtExprIndexList, ScalarExpression expr1) {
        List argExprs = ((NewObjectExpression)expr1).getArgumentExpressions();
        for (int j = 0; j < argExprs.size(); ++j) {
            ScalarExpression argExpr = (ScalarExpression)argExprs.get(j);
            this.selectScalarExpression(stmt, stmtExprIndexList, argExpr);
        }
    }

    private void selectLiteralExpression(QueryExpression stmt, List stmtExprIndexList, ScalarExpression expr1) {
        AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.candidateClass, stmt.getClassLoaderResolver());
        JavaTypeMapping mapping = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            mapping = expr1.getMapping();
            stmt.select(this.storeMgr.getDatastoreClass(this.candidateClass.getName(), this.clr).getDataStoreObjectIdMapping(), true);
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] prefetchFieldNumbers = new int[cmd.getPKMemberPositions().length];
            for (int j = 0; j < prefetchFieldNumbers.length; ++j) {
                prefetchFieldNumbers[j] = cmd.getPKMemberPositions()[j];
                JavaTypeMapping m = this.storeMgr.getDatastoreClass(this.candidateClass.getName(), this.clr).getMemberMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[j]));
                if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                stmt.select(m, true);
            }
            mapping = expr1.getMapping();
        }
        if (expr1.getMapping() instanceof SingleFieldMapping && expr1 instanceof Literal) {
            mapping = new ResultLiteralJavaTypeMapping(expr1.getMapping(), ((Literal)expr1).getValue());
        }
        StatementMappingIndex stmtExprIndex = new StatementMappingIndex(mapping);
        stmtExprIndexList.add(stmtExprIndex);
    }

    private void selectScalarExpression(QueryExpression stmt, List stmtExprIndexList, ScalarExpression expr1) {
        if (expr1 instanceof Literal) {
            this.selectLiteralExpression(stmt, stmtExprIndexList, expr1);
        } else if (expr1 instanceof NewObjectExpression) {
            this.selectNewObjectExpression(stmt, stmtExprIndexList, expr1);
        } else {
            StatementMappingIndex stmtMapping = new StatementMappingIndex(expr1.getMapping());
            int[] exprIndex = null;
            ScalarExpression[] expr = expr1.getExpressionList().toArray();
            if (expr.length > 0) {
                exprIndex = new int[expr.length];
                for (int j = 0; j < expr.length; ++j) {
                    exprIndex[j] = stmt.selectScalarExpression(expr[j], true);
                }
            } else {
                exprIndex = new int[]{stmt.selectScalarExpression(expr1, true)};
            }
            stmtMapping.setColumnPositions(exprIndex);
            if (expr1.getAlias() != null) {
                stmtMapping.setColumnAlias(expr1.getAlias());
            }
            stmtExprIndexList.add(stmtMapping);
        }
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        ArrayList stmtExprIndex = new ArrayList();
        for (int i = 0; i < this.expressions.length; ++i) {
            if (!(this.expressions[i] instanceof NewObjectExpression) && this.expressions[i].getMapping() == null) {
                throw new NucleusUserException(LOCALISER.msg("021074", (Object)this.expressions[i]));
            }
            this.selectScalarExpression(stmt, stmtExprIndex, this.expressions[i]);
        }
        if (stmt.getNumberOfScalarExpressions() < 1) {
            JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(BigInteger.class);
            stmt.selectScalarExpression(mapping.newLiteral(stmt, (Object)BigInteger.ONE));
        }
        StatementMappingIndex[] statementExpressionIndex = stmtExprIndex.toArray(new StatementMappingIndex[stmtExprIndex.size()]);
        if (resultClass != null) {
            return new ResultClassROF(resultClass, statementExpressionIndex, this.expressions);
        }
        if (this.expressions.length == 1) {
            return new ResultClassROF(Object.class, statementExpressionIndex, this.expressions);
        }
        return new ResultClassROF(Object[].class, statementExpressionIndex, this.expressions);
    }

    public boolean isEmpty() {
        if (this.userCandidates != null) {
            return this.userCandidates.isEmpty();
        }
        return false;
    }

    class ResultLiteralJavaTypeMapping
    extends JavaTypeMapping {
        final JavaTypeMapping mapping;
        final Object literal;

        public ResultLiteralJavaTypeMapping(JavaTypeMapping mapping, Object literal) {
            super(null, mapping.getType(), mapping.getMemberMetaData(), null);
            this.mapping = mapping;
            this.literal = literal;
        }

        public DatastoreContainerObject getDatastoreContainer() {
            return this.mapping.getDatastoreContainer();
        }

        public Class getJavaType() {
            return this.mapping.getJavaType();
        }

        public Object getSampleValue(ClassLoaderResolver clr) {
            return this.mapping.getSampleValue(clr);
        }

        public boolean includeInFetchStatement() {
            return this.mapping.includeInFetchStatement();
        }

        public boolean includeInUpdateStatement() {
            return this.mapping.includeInUpdateStatement();
        }

        public boolean includeInInsertStatement() {
            return this.mapping.includeInInsertStatement();
        }

        public ScalarExpression newLiteral(QueryExpression qs, Object value) {
            return this.mapping.newLiteral(qs, value);
        }

        public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
            return this.mapping.newScalarExpression(qs, te);
        }

        public boolean getBoolean(ObjectManager om, Object resultSet, int[] exprIndex) {
            return (Boolean)this.literal;
        }

        public byte getByte(ObjectManager om, Object resultSet, int[] exprIndex) {
            return (Byte)this.literal;
        }

        public char getChar(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Character)this.literal).charValue();
        }

        public double getDouble(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).doubleValue();
        }

        public float getFloat(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).floatValue();
        }

        public int getInt(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).intValue();
        }

        public long getLong(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).longValue();
        }

        public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
            return this.literal;
        }

        public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex, StateManager ownerSM, int ownerFieldNumber) {
            return this.literal;
        }

        public short getShort(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).shortValue();
        }

        public String getString(ObjectManager om, Object resultSet, int[] exprIndex) {
            return (String)this.literal;
        }
    }
}

