/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.fieldmanager;

import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.util.Localiser;

public class ParameterSetter
extends AbstractFieldManager {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    private final StateManager sm;
    private final ObjectManager om;
    private final Object statement;
    private final StatementMappingForClass stmtMappings;
    private final boolean checkNonNullable;

    public ParameterSetter(StateManager sm, Object stmt, StatementMappingForClass stmtMappings, boolean checkNonNullable) {
        this.sm = sm;
        this.om = sm.getObjectManager();
        this.statement = stmt;
        this.stmtMappings = stmtMappings;
        this.checkNonNullable = checkNonNullable;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        mapIdx.getMapping().setBoolean(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeCharField(int fieldNumber, char value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        mapIdx.getMapping().setChar(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        mapIdx.getMapping().setByte(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeShortField(int fieldNumber, short value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        mapIdx.getMapping().setShort(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeIntField(int fieldNumber, int value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        mapIdx.getMapping().setInt(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeLongField(int fieldNumber, long value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        mapIdx.getMapping().setLong(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        mapIdx.getMapping().setFloat(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeDoubleField(int fieldNumber, double value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        mapIdx.getMapping().setDouble(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeStringField(int fieldNumber, String value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        if (this.checkNonNullable && value == null && mapIdx.getMapping().getMemberMetaData().getNullValue() == NullValue.EXCEPTION) {
            throw new NucleusUserException(LOCALISER.msg("052400", (Object)mapIdx.getMapping().getMemberMetaData().getFullFieldName()));
        }
        mapIdx.getMapping().setString(this.om, this.statement, mapIdx.getParameterPositions(), value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        StatementMappingIndex mapIdx = this.stmtMappings.getMappingForMemberPosition(fieldNumber);
        if (this.checkNonNullable && value == null && mapIdx.getMapping().getMemberMetaData().getNullValue() == NullValue.EXCEPTION) {
            throw new NucleusUserException(LOCALISER.msg("052400", (Object)mapIdx.getMapping().getMemberMetaData().getFullFieldName()));
        }
        try {
            JavaTypeMapping mapping = mapIdx.getMapping();
            if (mapping instanceof EmbeddedPCMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping || mapping instanceof PersistenceCapableMapping || mapping instanceof InterfaceMapping) {
                mapping.setObject(this.om, this.statement, mapIdx.getParameterPositions(), value, this.sm, fieldNumber);
            } else {
                mapping.setObject(this.om, this.statement, mapIdx.getParameterPositions(), value);
            }
            this.sm.wrapSCOField(fieldNumber, value, false, true, true);
        }
        catch (NotYetFlushedException e) {
            if (this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getNullValue() == NullValue.EXCEPTION) {
                throw e;
            }
            this.sm.updateFieldAfterInsert(e.getPersistable(), fieldNumber);
        }
    }
}

