/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;

public class TemporalLiteral
extends TemporalExpression
implements SQLLiteral {
    private final Date value;
    Object rawValue;

    public TemporalLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        if (!(value instanceof Date)) {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.value = (Date)value;
        this.st.appendParameter(mapping, this.value);
    }

    public String toString() {
        return super.toString() + " = " + this.value.toString();
    }

    public SQLExpression invoke(String methodName, List args) {
        if (methodName.equals("getDay")) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.value);
            JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
            return new IntegerLiteral(this.stmt, m, new Integer(cal.get(5)));
        }
        if (methodName.equals("getMonth")) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.value);
            JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
            return new IntegerLiteral(this.stmt, m, new Integer(cal.get(2)));
        }
        if (methodName.equals("getYear")) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.value);
            JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
            return new IntegerLiteral(this.stmt, m, new Integer(cal.get(1)));
        }
        if (methodName.equals("getHour")) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.value);
            JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
            return new IntegerLiteral(this.stmt, m, new Integer(cal.get(11)));
        }
        if (methodName.equals("getMinutes")) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.value);
            JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
            return new IntegerLiteral(this.stmt, m, new Integer(cal.get(12)));
        }
        if (methodName.equals("getSeconds")) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.value);
            JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
            return new IntegerLiteral(this.stmt, m, new Integer(cal.get(13)));
        }
        return super.invoke(methodName, args);
    }

    public Object getValue() {
        return this.value;
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }
}

