/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JoinListStore
extends AbstractListStore {
    public JoinListStore(AbstractMemberMetaData fmd, CollectionTable joinTable, ClassLoaderResolver clr) {
        super((StoreManager)joinTable.getStoreManager(), clr);
        this.containerTable = joinTable;
        this.setOwnerMemberMetaData(fmd);
        this.listName = "list";
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        if (this.ownerMemberMetaData.getOrderMetaData() != null && !this.ownerMemberMetaData.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.orderMapping == null && this.indexedList) {
            throw new NucleusUserException(LOCALISER.msg("056044", (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)joinTable.toString()));
        }
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = fmd.getCollection().getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType((Class)element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 3, clr);
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null ? (!this.elementsAreEmbedded ? this.getElementInformationForClass() : null) : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAdd(StateManager sm, int start, boolean atEnd, Collection c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int shift = c.size();
        for (Object element : c) {
            StateManager elementSM;
            this.validateElementForWriting(sm, element, null);
            if (this.ownerMemberMetaData.getRelationType(this.clr) != 4 || !sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") || (elementSM = sm.getObjectManager().findStateManager(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.JDO.info((Object)LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
                continue;
            }
            if (elementOwner == sm.getObject() || sm.getReferencedPC() != null) continue;
            throw new NucleusUserException(LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject()), (Object)StringUtils.toJVMIDString((Object)elementOwner)));
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(sm) : size;
        String addStmt = this.getRDBMSAssociationStrategy().getAddStmt(this);
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
            try {
                if (!atEnd && start != currentListSize) {
                    boolean batched = currentListSize - start > 0;
                    for (int i = currentListSize - 1; i >= start; --i) {
                        this.internalShift(sm, mconn, batched, i, shift, i == start);
                    }
                } else {
                    start = currentListSize;
                }
                int jdbcPosition = 1;
                boolean batched = c.size() > 1;
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, addStmt, batched);
                    try {
                        jdbcPosition = 1;
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                        jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                        if (this.orderMapping != null) {
                            jdbcPosition = this.populateOrderInStatement(om, ps, start, jdbcPosition);
                        }
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
                        }
                        ++start;
                        sqlControl.executeStatementUpdate(mconn, addStmt, ps, !iter.hasNext());
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)addStmt), (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(StateManager sm, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(sm, element, null);
        Object o = this.get(sm, index);
        String setStmt = this.getSetStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, setStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                    jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(mconn, setStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056015", (Object)setStmt), (Throwable)e);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement() && allowDependentField && o != null && !this.contains(sm, o)) {
            sm.getObjectManager().deleteObjectInternal(o);
        }
        return o;
    }

    protected String getSetStmt() {
        if (this.setStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            stmt.append(this.containerTable.toString());
            stmt.append(" SET ");
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.setStmt = stmt.toString();
        }
        return this.setStmt;
    }

    public void update(StateManager sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(sm);
            this.addAll(sm, coll, 0);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(sm);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (((Object)existing).equals(coll)) {
            return;
        }
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean internalRemove(StateManager ownerSM, Object element, int size) {
        boolean modified = false;
        if (this.indexedList) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.add(element);
            int[] indices = this.getIndicesOf(ownerSM, elements);
            for (int i = 0; i < indices.length; ++i) {
                this.removeAt(ownerSM, indices[i], size);
                modified = true;
            }
            return modified;
        } else {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                int[] rcs = this.internalRemove(ownerSM, mconn, false, element, true);
                if (rcs == null || rcs[0] <= 0) return modified;
                modified = true;
                return modified;
            }
            catch (SQLException sqe) {
                String msg = LOCALISER.msg("056012", (Object)this.getRemoveStmt());
                NucleusLogger.DATASTORE.error((Object)msg, (Throwable)sqe);
                throw new NucleusDataStoreException(msg, (Throwable)sqe, ownerSM.getObject());
            }
            finally {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        int currentListSize = this.size(sm);
        int[] indices = this.getIndicesOf(sm, elements);
        String removeAllStmt = this.getRemoveAllStmt(elements);
        SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeAllStmt, false);
                try {
                    int jdbcPosition = 1;
                    for (Object element : elements) {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                        jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
                    }
                    int[] number = sqlControl.executeStatementUpdate(mconn, removeAllStmt, ps, true);
                    if (number[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)removeAllStmt), (Throwable)e);
        }
        try {
            boolean batched = this.allowsBatching();
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                for (int i = 0; i < currentListSize; ++i) {
                    int shift = 0;
                    boolean removed = false;
                    for (int j = 0; j < indices.length; ++j) {
                        if (indices[j] == i) {
                            removed = true;
                            break;
                        }
                        if (indices[j] >= i) continue;
                        ++shift;
                    }
                    if (removed || shift <= 0) continue;
                    this.internalShift(sm, mconn, batched, i, -1 * shift, i == currentListSize - 1);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)removeAllStmt), (Throwable)e);
        }
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObjects(elements.toArray());
        }
        return modified;
    }

    protected void removeAt(StateManager sm, int index, int size) {
        this.internalRemoveAt(sm, index, this.getRemoveAtStmt(), size);
    }

    protected String getRemoveAllStmt(Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        Iterator elementsIter = elements.iterator();
        boolean first = true;
        while (elementsIter.hasNext()) {
            int i;
            elementsIter.next();
            if (first) {
                stmt.append("(");
            } else {
                stmt.append(" OR (");
            }
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(")");
            first = false;
        }
        return stmt.toString();
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM, int start_index, int end_index) {
        QueryExpression stmt = null;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            stmt = this.dba.newQueryStatement(this.containerTable, null, clr);
            stmt.select(this.elementMapping);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            stmt = this.dba.newQueryStatement(this.containerTable, null, clr);
        } else if (this.elementInfo != null) {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementInfo[elementNo].getClassName());
                QueryExpression elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    if (ClassUtils.isReferenceType((Class)clr.classForName(this.ownerMemberMetaData.getCollection().getElementType()))) {
                        String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getCollection().getElementType(), clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = clr.classForName(clsNames[j]);
                        }
                        elementStmt = new DiscriminatorIteratorStatement(clr, cls, true, (StoreManager)this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement(null);
                    } else {
                        elementStmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, (StoreManager)this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement(null);
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    elementStmt = new UnionIteratorStatement(clr, elementCls, true, (StoreManager)this.storeMgr, elementCls, this.elementMapping, this.containerTable, false, Boolean.TRUE, true, this.allowsNull).getQueryStatement(null);
                }
                if (stmt == null) {
                    stmt = elementStmt;
                    continue;
                }
                stmt.union(elementStmt);
            }
        } else {
            throw new NucleusUserException("Attempt to get iterator for List when insufficient information is available to perform the operation.");
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        if (this.indexedList) {
            ScalarExpression indexVal;
            ScalarExpression indexExpr;
            boolean returning_range = false;
            if (start_index == -1 && end_index == -1) {
                returning_range = true;
            } else if (start_index == end_index && start_index >= 0) {
                indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
                indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                stmt.andCondition(indexExpr.eq(indexVal), true);
            } else {
                if (start_index >= 0) {
                    indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
                    indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                    stmt.andCondition(indexExpr.gteq(indexVal), true);
                }
                if (end_index >= 0) {
                    indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
                    indexVal = this.orderMapping.newLiteral(stmt, new Integer(end_index));
                    stmt.andCondition(indexExpr.lt(indexVal), true);
                }
                returning_range = true;
            }
            if (returning_range) {
                ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
                exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression()).getExpressionList().toArray();
                stmt.setOrdering(exprIndex, descendingOrder);
            }
        } else if (this.elementInfo != null) {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerMemberMetaData.getOrderMetaData().getFieldOrders();
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getFieldMapping(this.elementInfo[0].getAbstractClassMetaData().getMetaDataForMember(fieldName));
                ScalarExpression[] exprIndex = new ScalarExpression[fieldMapping.getNumberOfDatastoreFields()];
                boolean[] descendingOrder = new boolean[fieldMapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < descendingOrder.length; ++j) {
                    descendingOrder[j] = !orderComponents[i].isForward();
                }
                exprIndex = fieldMapping.newScalarExpression(stmt, stmt.getTableExpression(this.elmIdentifier)).getExpressionList().toArray();
                stmt.setOrdering(exprIndex, descendingOrder);
            }
        }
        return stmt;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass, DatastoreIdentifier candidateAlias) {
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            throw new NucleusUserException(LOCALISER.msg("056021"));
        }
        if (!this.clr.isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreIdentifier listTableAlias = this.storeMgr.getIdentifierFactory().newIdentifier(0, this.listName);
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, listTableAlias, clr);
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(candidateClass)) {
            stmt.select(listTableAlias, this.elementMapping);
        } else {
            DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, clr);
            DatastoreIdentifier elementTblAlias = this.storeMgr.getIdentifierFactory().newIdentifier(0, "LIST_ELEMENTS");
            LogicSetExpression elementTblExpr = stmt.newTableExpression(candidateTable, elementTblAlias);
            JavaTypeMapping elementTableID = candidateTable.getIDMapping();
            ScalarExpression elmListExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
            ScalarExpression elmExpr = elementTableID.newScalarExpression(stmt, elementTblExpr);
            stmt.innerJoin(elmExpr, elmListExpr, elementTblExpr, true, true);
            stmt.selectScalarExpression(elementTableID.newScalarExpression(stmt, elementTblExpr));
        }
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTblExpr, DatastoreIdentifier listTableAlias, Class filteredElementType, ScalarExpression elementExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        if (!existsQuery) {
            LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, listTableAlias);
            if (!parentStmt.hasCrossJoin(ownTblExpr) && !stmt.getMainTableExpression().equals(ownTblExpr)) {
                stmt.crossJoin(ownTblExpr, true);
            }
            ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTblExpr);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        }
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), clr);
        DatastoreClass joiningClass = elementExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elementExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementTableAlias);
        if (elmTblExpr == null) {
            if (!(elementExpr instanceof UnboundVariable) && parentStmt != stmt) {
                elmTblExpr = parentStmt.getTableExpression(elementTableAlias);
            }
            if (elmTblExpr == null) {
                elmTblExpr = stmt.newTableExpression(elementTable, elementTableAlias);
            }
        }
        if (!parentStmt.getMainTableExpression().equals(elmTblExpr) && !parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        ScalarExpression elmListExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        if (elementExpr.getLogicSetExpression() != null && !elementTable.equals(elementExpr.getLogicSetExpression().getMainTable())) {
            if (existsQuery) {
                stmt.andCondition(elmListExpr.eq(elementExpr), true);
                return elmListExpr;
            }
            return elmListExpr;
        }
        if (existsQuery) {
            ScalarExpression elementIdExpr = elementTableID.newScalarExpression(stmt, elmTblExpr);
            stmt.andCondition(elmListExpr.eq(elementIdExpr), true);
            return elementIdExpr;
        }
        return elmListExpr;
    }
}

