/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractArrayStore;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.ArrayTable;
import org.datanucleus.util.ClassUtils;

public class JoinArrayStore
extends AbstractArrayStore {
    public JoinArrayStore(ArrayTable joinTable, ClassLoaderResolver clr) {
        super((StoreManager)joinTable.getStoreManager(), clr);
        this.containerTable = joinTable;
        this.setOwnerMemberMetaData(joinTable.getOwnerFieldMetaData());
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = joinTable.getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType((Class)element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 4, clr);
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                if (this.emd != null) {
                    this.elementType = this.emd.getFullClassName();
                    if (!this.elementsAreEmbedded && !this.elementsAreSerialised) {
                        this.elementInfo = this.getElementInformationForClass();
                        if (this.elementInfo != null && this.elementInfo.length > 1) {
                            throw new NucleusUserException(LOCALISER.msg("056045", (Object)this.ownerMemberMetaData.getFullFieldName()));
                        }
                    } else {
                        this.elementInfo = null;
                    }
                } else {
                    this.elementInfo = null;
                }
            }
        }
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        QueryExpression stmt = null;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            stmt = this.dba.newQueryStatement(this.containerTable, null, clr);
            stmt.select(this.elementMapping);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            stmt = this.dba.newQueryStatement(this.containerTable, null, clr);
        } else if (this.elementInfo != null) {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementInfo[elementNo].getClassName());
                QueryExpression elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    if (ClassUtils.isReferenceType((Class)clr.classForName(this.ownerMemberMetaData.getCollection().getElementType()))) {
                        String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getCollection().getElementType(), clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = clr.classForName(clsNames[j]);
                        }
                        elementStmt = new DiscriminatorIteratorStatement(clr, cls, true, (StoreManager)this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement(null);
                    } else {
                        elementStmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, (StoreManager)this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement(null);
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    elementStmt = new UnionIteratorStatement(clr, elementCls, true, (StoreManager)this.storeMgr, elementCls, this.elementMapping, this.containerTable, false, Boolean.TRUE, true, this.allowsNull).getQueryStatement(null);
                }
                if (stmt == null) {
                    stmt = elementStmt;
                    continue;
                }
                stmt.union(elementStmt);
            }
        } else {
            throw new NucleusUserException("Attempt to get iterator for an array when insufficient information is available to perform the operation.");
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
        boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
        exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression()).getExpressionList().toArray();
        stmt.setOrdering(exprIndex, descendingOrder);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listTableAlias, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        Class primitiveType = ClassUtils.getWrapperTypeForPrimitiveType((Class)clr.classForName(this.elementType));
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType) && primitiveType != null && clr.isAssignableFrom(this.elementType, primitiveType.getName())) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, listTableAlias);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        if (!parentStmt.hasCrossJoin(ownTblExpr)) {
            stmt.crossJoin(ownTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        DatastoreClass joiningClass = elmExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elmExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementTableAlias);
        if (elmTblExpr == null) {
            elmTblExpr = stmt.newTableExpression(elementTable, elementTableAlias);
        }
        ScalarExpression elmSetExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        if (!parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        if (elmExpr.getLogicSetExpression() != null && !elementTable.equals(elmExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(elmSetExpr.eq(elmExpr), true);
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        ScalarExpression elementExpr = elementTableID.newScalarExpression(stmt, stmt.getTableExpression(elementTableAlias));
        stmt.andCondition(elmSetExpr.eq(elementExpr), true);
        return elementExpr;
    }
}

