/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractSetStore;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FKSetStore
extends AbstractSetStore {
    private final int ownerFieldNumber;
    private String updateFkStmt;
    private String clearNullifyStmt;

    public FKSetStore(AbstractMemberMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super((StoreManager)storeMgr, clr);
        this.setOwnerMemberMetaData(fmd);
        CollectionMetaData colmd = fmd.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056001", (Object)fmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.elementIsPersistentInterface = storeMgr.getOMFContext().getMetaDataManager().isPersistentInterface(element_class.getName());
            if (this.elementIsPersistentInterface) {
                this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForInterface(element_class, clr);
            } else {
                this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
                if (this.emd != null) {
                    // empty if block
                }
            }
        } else {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        if (fmd.getMappedBy() != null) {
            AbstractMemberMetaData eofmd = this.emd.getMetaDataForMember(fmd.getMappedBy());
            if (eofmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)fmd.getFullFieldName(), (Object)fmd.getMappedBy(), (Object)element_class.getName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getAbsolutePositionOfMember(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getFieldMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056029", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)fmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056030", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
            }
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.containerTable) {
            this.containerTable = this.ownerMapping.getDatastoreContainer();
        }
        this.setName = "inverseSet";
    }

    protected String getSizeStmt() {
        return this.getRDBMSAssociationStrategy().getSizeStmt(this);
    }

    protected String getContainsStmt() {
        return super.getContainsStmt();
    }

    protected String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("<TABLE NAME>");
            } else {
                stmt.append(this.containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            this.clearNullifyStmt = stmt.toString();
        }
        return this.clearNullifyStmt;
    }

    private String getUpdateFkStmt() {
        if (this.updateFkStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("<TABLE NAME>");
            } else {
                stmt.append(this.containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            this.updateFkStmt = stmt.toString();
        }
        return this.updateFkStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(StateManager sm, Object element, Object owner) {
        boolean retval;
        if (element == null) {
            return false;
        }
        this.validateElementForWriting(sm, element, null);
        ObjectManager om = sm.getObjectManager();
        String stmt = this.getUpdateFkStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
            try {
                int jdbcPosition = 1;
                if (this.elementInfo.length > 1) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                    if (table != null) {
                        stmt = StringUtils.replaceAll((String)stmt, (String)"<TABLE NAME>", (String)((Object)table).toString());
                    } else {
                        NucleusLogger.PERSISTENCE.warn((Object)("FKSetStore.updateElementFK : need to set table in statement but dont know table where to store " + element));
                    }
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null);
                        }
                    } else if (this.ownerMemberMetaData != null) {
                        this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), sm.getObject(), sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                    } else {
                        this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), sm.getObject());
                    }
                    jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
                    }
                    this.elementMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.elementMapping), element);
                    jdbcPosition += this.elementMapping.getNumberOfDatastoreFields();
                    sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)stmt), (Throwable)e);
        }
        return retval;
    }

    protected int getFieldNumberInElementForBidirectional(StateManager sm) {
        if (this.ownerFieldNumber < 0) {
            return -1;
        }
        return sm.getClassMetaData().getAbsolutePositionOfMember(this.ownerMemberMetaData.getMappedBy());
    }

    public void update(StateManager sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        Iterator elemIter = this.iterator(sm);
        HashSet existing = new HashSet();
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(sm, elem, 0);
            }
        }
    }

    public boolean add(final StateManager sm, Object element, int size) {
        if (element == null) {
            throw new NucleusUserException(LOCALISER.msg("056039"));
        }
        final Object newOwner = sm.getObject();
        ObjectManager om = sm.getObjectManager();
        boolean inserted = this.validateElementForWriting(sm, element, new FieldValues(){

            public void fetchFields(StateManager esm) {
                boolean isPersistentInterface = FKSetStore.this.storeMgr.getOMFContext().getMetaDataManager().isPersistentInterface(FKSetStore.this.elementType);
                DatastoreClass elementTable = null;
                elementTable = isPersistentInterface ? FKSetStore.this.storeMgr.getDatastoreClass(FKSetStore.this.storeMgr.getOMFContext().getMetaDataManager().getImplementationNameForPersistentInterface(FKSetStore.this.elementType), FKSetStore.this.clr) : FKSetStore.this.storeMgr.getDatastoreClass(FKSetStore.this.elementType, FKSetStore.this.clr);
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKSetStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        esm.setAssociatedValue((Object)externalFKMapping, sm.getObject());
                    }
                    if (FKSetStore.this.relationDiscriminatorMapping != null) {
                        esm.setAssociatedValue((Object)FKSetStore.this.relationDiscriminatorMapping, (Object)FKSetStore.this.relationDiscriminatorValue);
                    }
                }
                if (FKSetStore.this.getFieldNumberInElementForBidirectional(esm) >= 0 && sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships")) {
                    Object currentOwner = esm.provideField(FKSetStore.this.getFieldNumberInElementForBidirectional(esm));
                    if (currentOwner == null) {
                        NucleusLogger.JDO.info((Object)BaseContainerStore.LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)FKSetStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)esm.getObject())));
                        esm.replaceField(FKSetStore.this.getFieldNumberInElementForBidirectional(esm), newOwner, true);
                    } else if (currentOwner != newOwner && sm.getReferencedPC() == null) {
                        throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)FKSetStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)esm.getObject()), (Object)StringUtils.toJVMIDString((Object)currentOwner)));
                    }
                }
            }

            public void fetchNonLoadedFields(StateManager sm2) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        if (inserted) {
            return true;
        }
        StateManager elementSM = om.findStateManager(element);
        if (this.getFieldNumberInElementForBidirectional(elementSM) >= 0 && om.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships")) {
            om.getApiAdapter().isLoaded(elementSM, this.getFieldNumberInElementForBidirectional(elementSM));
            Object oldOwner = elementSM.provideField(this.getFieldNumberInElementForBidirectional(elementSM));
            if (oldOwner != newOwner) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("055009", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)element)));
                }
                PersistenceCapable pcElement = (PersistenceCapable)element;
                elementSM.setObjectField(pcElement, this.getFieldNumberInElementForBidirectional(elementSM), oldOwner, newOwner);
                if (om.isFlushing()) {
                    elementSM.flush();
                }
            }
            return oldOwner != newOwner;
        }
        boolean contained = this.contains(sm, element);
        return contained ? false : this.updateElementFk(sm, element, newOwner);
    }

    public boolean addAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean success = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!this.add(sm, iter.next(), -1)) continue;
            success = true;
        }
        return success;
    }

    public boolean remove(StateManager ownerSM, Object element, int size, boolean allowDependentField) {
        if (element == null) {
            return false;
        }
        if (!this.validateElementForReading(ownerSM, element)) {
            return false;
        }
        ObjectManager om = ownerSM.getObjectManager();
        StateManager elementSM = om.findStateManager(element);
        Object oldOwner = null;
        if (this.ownerFieldNumber >= 0 && !om.getApiAdapter().isDeleted(element)) {
            om.getApiAdapter().isLoaded(elementSM, this.ownerFieldNumber);
            oldOwner = elementSM.provideField(this.ownerFieldNumber);
        }
        if (this.ownerFieldNumber >= 0 && oldOwner != ownerSM.getObject()) {
            return false;
        }
        boolean deleteElement = this.checkRemovalOfElementShouldDelete(ownerSM);
        if (deleteElement) {
            if (om.getApiAdapter().isPersistable(element) && om.getApiAdapter().isDeleted(element)) {
                elementSM.flush();
            } else {
                om.deleteObjectInternal(element);
            }
        } else {
            this.manageRemovalOfElement(ownerSM, element);
            this.updateElementFk(ownerSM, element, null);
        }
        return true;
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean success = true;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!this.remove(sm, iter.next(), -1, true)) continue;
            success = false;
        }
        return success;
    }

    protected boolean checkRemovalOfElementShouldDelete(StateManager ownerSM) {
        boolean delete = false;
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056034"));
            }
            delete = true;
        } else if (this.ownerMapping.isNullable()) {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056036"));
            }
            delete = false;
        } else {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056035"));
            }
            delete = true;
        }
        return delete;
    }

    protected void manageRemovalOfElement(StateManager ownerSM, Object element) {
        StateManager elementSM;
        ObjectManager om = ownerSM.getObjectManager();
        int relationType = this.ownerMemberMetaData.getRelationType(this.clr);
        if (relationType == 4 && om.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && !om.getApiAdapter().isDeleted(element) && (elementSM = om.findStateManager(element)) != null) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("055010", (Object)StringUtils.toJVMIDString((Object)ownerSM.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)element)));
            }
            elementSM.replaceField(this.getFieldNumberInElementForBidirectional(elementSM), null, true);
            if (om.isFlushing()) {
                elementSM.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        ObjectManager om = ownerSM.getObjectManager();
        boolean deleteElements = this.checkRemovalOfElementShouldDelete(ownerSM);
        if (deleteElements) {
            Iterator elementsIter = this.iterator(ownerSM);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (om.getApiAdapter().isPersistable(element) && om.getApiAdapter().isDeleted(element)) {
                        StateManager elementSM = om.findStateManager(element);
                        elementSM.flush();
                        continue;
                    }
                    om.deleteObjectInternal(element);
                }
            }
        } else {
            om.getApiAdapter().isLoaded(ownerSM, this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Collection value = (Collection)ownerSM.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Iterator elementsIter = null;
            elementsIter = value != null && !value.isEmpty() ? value.iterator() : this.iterator(ownerSM);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    this.manageRemovalOfElement(ownerSM, element);
                }
            }
            String stmt = this.getClearNullifyStmt();
            try {
                if (this.elementInfo.length > 1) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(this.elementInfo[0].getClassName(), this.clr);
                    if (table != null) {
                        stmt = StringUtils.replaceAll((String)stmt, (String)"<TABLE NAME>", (String)((Object)table).toString());
                    } else {
                        NucleusLogger.PERSISTENCE.warn((Object)("FKSetStore.updateElementFK : need to set table in statement but dont know table where to store " + this.elementInfo[0].getClassName()));
                    }
                }
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, this);
                        sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)stmt), (Throwable)e);
            }
        }
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        if (this.elementInfo == null || this.elementInfo.length == 0) {
            return null;
        }
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        QueryExpression stmt = null;
        if (this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            if (ClassUtils.isReferenceType((Class)clr.classForName(this.ownerMemberMetaData.getCollection().getElementType()))) {
                String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getCollection().getElementType(), clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, (StoreManager)this.storeMgr, true).getQueryStatement(null);
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{clr.classForName(this.elementInfo[0].getClassName())}, true, (StoreManager)this.storeMgr, true).getQueryStatement(null);
            }
            this.iterateUsingDiscriminator = true;
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elementCls = clr.classForName(this.elementInfo[i].getClassName());
                int elementNo = i;
                QueryExpression subStmt = new UnionIteratorStatement(clr, elementCls, true, (StoreManager)this.storeMgr, elementCls, this.elementMapping, this.elementInfo[elementNo].getDatastoreClass(), false, null, true, false).getQueryStatement(null);
                if (stmt == null) {
                    stmt = subStmt;
                    continue;
                }
                stmt.union(subStmt);
            }
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        if (this.orderMapping != null) {
            ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
            exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression()).getExpressionList().toArray();
            stmt.setOrdering(exprIndex, descendingOrder);
        }
        return stmt;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass, DatastoreIdentifier candidateAlias) {
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, clr);
        QueryExpression stmt = this.dba.newQueryStatement(candidateTable, null, clr);
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        stmt.select(this.elementMapping);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier setTableAlias, Class filteredElementType, ScalarExpression elementExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        ScalarExpression ownerExpr;
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), clr);
        if (stmt.getTableExpression(elementTableAlias) == null) {
            stmt.newTableExpression(filteredElementTable, elementTableAlias);
        }
        DatastoreIdentifier containerRangeVar = setTableAlias;
        if (existsQuery) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                // empty if block
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
        } else if (parentStmt != stmt) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        } else if (elementExpr.getLogicSetExpression().getMainTable() == filteredElementTable) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        } else {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.innerJoin(ownerExpr, ownerSetExpr, stmt.getTableExpression(containerRangeVar), true, true);
        }
        JavaTypeMapping elementTableID = filteredElementTable.getIDMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }
}

