/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.scostore.AssociationStrategy;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.util.ClassUtils;

public abstract class ElementContainerStore
extends BaseContainerStore {
    protected boolean iterateUsingDiscriminator = false;
    protected ElementInfo[] elementInfo;
    protected AbstractClassMetaData emd;
    protected DatastoreContainerObject containerTable;
    protected JavaTypeMapping elementMapping;
    protected String elementType;
    protected boolean elementsAreEmbedded;
    protected boolean elementsAreSerialised;
    protected boolean elementIsPersistentInterface = false;
    protected JavaTypeMapping orderMapping;
    protected JavaTypeMapping relationDiscriminatorMapping;
    protected String relationDiscriminatorValue;
    protected final DatastoreIdentifier elmIdentifier;
    protected ClassLoaderResolver clr;
    protected String sizeStmt;
    protected String clearStmt;
    protected String addStmt;
    protected String removeStmt;
    protected boolean usingDiscriminatorInSizeStmt = false;
    protected final AssociationStrategy associationStrategy;

    protected ElementContainerStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr);
        this.clr = clr;
        this.elmIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "ELEMENT");
        this.associationStrategy = this.storeMgr.newAssociationStrategy(LOCALISER, clr);
    }

    protected ElementInfo[] getElementInformationForClass() {
        String[] clsNames;
        DatastoreClass tbl;
        ElementInfo[] info = null;
        if (!this.clr.classForName(this.elementType).isInterface()) {
            tbl = this.storeMgr.getDatastoreClass(this.elementType, this.clr);
            clsNames = new String[]{this.elementType};
        } else {
            clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.elementType, this.clr);
            tbl = this.storeMgr.getDatastoreClass(clsNames[0], this.clr);
        }
        if (tbl == null) {
            AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(this.emd, this.clr);
            info = new ElementInfo[subclassCmds.length];
            for (int i = 0; i < subclassCmds.length; ++i) {
                DatastoreClass table = this.storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), this.clr);
                info[i] = new ElementInfo(subclassCmds[i], table);
            }
        } else {
            info = new ElementInfo[clsNames.length];
            for (int i = 0; i < clsNames.length; ++i) {
                AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(clsNames[i], this.clr);
                DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                info[i] = new ElementInfo(cmd, table);
            }
        }
        return info;
    }

    public boolean hasOrderMapping() {
        return this.orderMapping != null;
    }

    public String getElementType() {
        return this.elementType;
    }

    protected boolean validateElementType(ClassLoaderResolver clr, Object element) {
        if (element == null) {
            return true;
        }
        Class primitiveElementClass = ClassUtils.getPrimitiveTypeForType(element.getClass());
        if (primitiveElementClass != null) {
            String elementTypeWrapper = this.elementType;
            Class elementTypeClass = clr.classForName(this.elementType);
            if (elementTypeClass.isPrimitive()) {
                elementTypeWrapper = ClassUtils.getWrapperTypeForPrimitiveType((Class)elementTypeClass).getName();
            }
            return clr.isAssignableFrom(elementTypeWrapper, element.getClass());
        }
        return clr.isAssignableFrom(this.elementType, element.getClass());
    }

    protected boolean validateElementForReading(StateManager sm, Object element) {
        ObjectManager om;
        if (!this.validateElementType(sm.getObjectManager().getClassLoaderResolver(), element)) {
            return false;
        }
        return element == null || this.elementsAreEmbedded || this.elementsAreSerialised || (om = sm.getObjectManager()).getApiAdapter().isPersistent(element) && om == ObjectManagerHelper.getObjectManager((Object)element) || om.getApiAdapter().isDetached(element);
    }

    protected boolean validateElementForWriting(StateManager sm, Object element, FieldValues fieldValues) {
        if (!this.elementIsPersistentInterface && !this.validateElementType(sm.getObjectManager().getClassLoaderResolver(), element)) {
            throw new ClassCastException(LOCALISER.msg("056033", (Object)element.getClass().getName(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)this.elementType));
        }
        boolean persisted = false;
        if (!this.elementsAreEmbedded && !this.elementsAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            StateManager elementSM = om.findStateManager(element);
            if (elementSM != null && elementSM.isEmbedded()) {
                throw new NucleusUserException(LOCALISER.msg("056028", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
            }
            persisted = SCOUtils.validateObjectForWriting((ObjectManager)om, (Object)element, (FieldValues)fieldValues);
        }
        return persisted;
    }

    protected int populateElementInStatement(ObjectManager om, Object ps, Object element, int jdbcPosition) {
        if (!this.storeMgr.insertValuesOnInsert(this.elementMapping.getDataStoreMapping(0))) {
            return jdbcPosition;
        }
        this.elementMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.elementMapping), element);
        return jdbcPosition + this.elementMapping.getNumberOfDatastoreFields();
    }

    protected int populateOrderInStatement(ObjectManager om, Object ps, int idx, int jdbcPosition) {
        this.orderMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.orderMapping), new Integer(idx));
        return jdbcPosition + this.orderMapping.getNumberOfDatastoreFields();
    }

    protected int populateEmbeddedElementFieldsInStatement(StateManager sm, Object element, Object ps, int jdbcPosition, AbstractMemberMetaData ownerFieldMetaData) {
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)this.elementMapping;
        StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[this.emd.getNoOfManagedMembers() + this.emd.getNoOfInheritedManagedMembers()];
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = this.emd.getAbsolutePositionOfMember(fieldMapping.getFieldMetaData().getName());
            if (fieldMapping == null) continue;
            statementExpressionIndex[absFieldNum] = new StatementExpressionIndex();
            statementExpressionIndex[absFieldNum].setMapping(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            statementExpressionIndex[absFieldNum].setParameterIndex(jdbcParamPositions);
        }
        StateManager elementSM = this.getStateManagerForEmbeddedPCObject(sm, element, ownerFieldMetaData);
        elementSM.setPcObjectType(2);
        FieldManager fm = this.storeMgr.getFieldManagerForStatementGeneration(elementSM, ps, statementExpressionIndex, true);
        elementSM.provideFields(elementFieldNumbers, fm);
        return jdbcPosition;
    }

    public abstract Iterator iterator(StateManager var1);

    public void clear(StateManager ownerSM) {
        HashSet dependentElements = null;
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement() && !collmd.isSerializedElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        this.associationStrategy.executeClear(ownerSM, this);
        if (dependentElements != null && dependentElements.size() > 0) {
            for (Object obj : dependentElements) {
                if (ownerSM.getObjectManager().getApiAdapter().isDeleted(obj)) continue;
                ownerSM.getObjectManager().deleteObjectInternal(obj);
            }
        }
    }

    public int size(StateManager sm) {
        return this.associationStrategy.getSize(sm, this);
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        JavaTypeMapping verMapping;
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.storeMgr.newResultObjectFactory(null, null, this.emd, null, null, null, ignoreCache, false, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
        }
        if (this.elementMapping instanceof ReferenceMapping) {
            JavaTypeMapping[] implMappings = ((ReferenceMapping)this.elementMapping).getJavaTypeMapping();
            for (int i = 0; i < implMappings.length; ++i) {
                stmt.select(implMappings[i]);
            }
            return this.storeMgr.newResultObjectFactory(this.elementInfo != null ? this.elementInfo[0].getDatastoreClass() : null, null, this.emd, null, null, null, ignoreCache, false, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
        }
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            if (this.elementInfo[0].getDatastoreClass().getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(this.elmIdentifier, this.elementInfo[0].getDatastoreClass().getDataStoreObjectIdMapping(), true);
            }
            if ((verMapping = this.elementInfo[0].getDatastoreClass().getVersionMapping(true)) != null) {
                versionIndex = stmt.select(this.elmIdentifier, verMapping, true);
            }
        } else {
            if (this.elementInfo[0].getDatastoreClass().getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(stmt.getMainTableAlias(), this.elementInfo[0].getDatastoreClass().getDataStoreObjectIdMapping(), true);
            }
            if ((verMapping = this.elementInfo[0].getDatastoreClass().getVersionMapping(true)) != null) {
                versionIndex = stmt.select(stmt.getMainTableAlias(), verMapping, true);
            }
        }
        StatementExpressionIndex[] statementExpressionIndex = null;
        int[] prefetchFieldNumbers = null;
        int[] pkFieldNumbers = null;
        if (this.emd.getIdentityType() == IdentityType.APPLICATION) {
            pkFieldNumbers = new int[this.emd.getPKMemberPositions().length];
            for (int i = 0; i < pkFieldNumbers.length; ++i) {
                pkFieldNumbers[i] = this.emd.getPKMemberPositions()[i];
            }
        }
        if (useFetchPlan) {
            FetchPlan fp = sm.getObjectManager().getFetchPlan();
            fp.manageFetchPlanForClass(this.emd);
            FetchPlan.FetchPlanForClass fpc = fp.getFetchPlanForClass(this.emd);
            int[] fpFieldNumbers = fpc.getFieldsInActualFetchPlan();
            if (pkFieldNumbers != null) {
                int i;
                int totalFieldCount = pkFieldNumbers.length + fpFieldNumbers.length;
                for (int i2 = 0; i2 < pkFieldNumbers.length; ++i2) {
                    if (Arrays.binarySearch(fpFieldNumbers, pkFieldNumbers[i2]) < 0) continue;
                    --totalFieldCount;
                }
                int prefetchNum = 0;
                prefetchFieldNumbers = new int[totalFieldCount];
                for (i = 0; i < pkFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[prefetchNum++] = pkFieldNumbers[i];
                }
                for (i = 0; i < fpFieldNumbers.length; ++i) {
                    if (Arrays.binarySearch(pkFieldNumbers, fpFieldNumbers[i]) >= 0) continue;
                    prefetchFieldNumbers[prefetchNum++] = fpFieldNumbers[i];
                }
            } else {
                prefetchFieldNumbers = fpFieldNumbers;
            }
        } else {
            prefetchFieldNumbers = pkFieldNumbers != null ? pkFieldNumbers : new int[]{};
        }
        int[] fn = new int[prefetchFieldNumbers.length];
        int prefetchFieldCount = 0;
        statementExpressionIndex = new StatementExpressionIndex[this.emd.getNoOfInheritedManagedMembers() + this.emd.getNoOfManagedMembers()];
        for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
            JavaTypeMapping m;
            AbstractMemberMetaData fmd = this.emd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]);
            if (fmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || (m = this.elementInfo[0].getDatastoreClass().getFieldMapping(fmd)) == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
            statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
            statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
            fn[prefetchFieldCount++] = prefetchFieldNumbers[i];
        }
        int[] fieldNumbers = new int[prefetchFieldCount];
        System.arraycopy(fn, 0, fieldNumbers, 0, prefetchFieldCount);
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
        } else {
            Mappings.selectMapping(stmt, statementExpressionIndex);
        }
        return this.storeMgr.newResultObjectFactory(this.elementInfo != null ? this.elementInfo[0].getDatastoreClass() : null, fieldNumbers, this.emd, statementExpressionIndex, datastoreIndex, versionIndex, ignoreCache, this.iterateUsingDiscriminator, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
    }

    public class ElementInfo {
        AbstractClassMetaData cmd;
        DatastoreClass table;

        public ElementInfo(AbstractClassMetaData cmd, DatastoreClass table) {
            this.cmd = cmd;
            this.table = table;
        }

        public String getClassName() {
            return this.cmd.getFullClassName();
        }

        public AbstractClassMetaData getAbstractClassMetaData() {
            return this.cmd;
        }

        public DatastoreClass getDatastoreClass() {
            return this.table;
        }

        public DiscriminatorStrategy getDiscriminatorStrategy() {
            return this.cmd.getDiscriminatorStrategy();
        }

        public JavaTypeMapping getDiscriminatorMapping() {
            return this.table.getDiscriminatorMapping(false);
        }
    }
}

