/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.CollectionStoreQueryable;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.scostore.RDBMSAssociationStrategy;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.scostore.CollectionStore;

public abstract class AbstractCollectionStore
extends ElementContainerStore
implements CollectionStore,
CollectionStoreQueryable {
    protected String containsStmt;

    protected AbstractCollectionStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    protected String getUpdateEmbeddedElementStmt(JavaTypeMapping fieldMapping) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.containerTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)this.elementMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedElement(StateManager sm, Object element, int fieldNumber, Object value) {
        boolean modified = false;
        if (this.elementMapping != null && this.elementMapping instanceof EmbeddedElementPCMapping) {
            String fieldName = this.emd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedElementPCMapping)this.elementMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            String stmt = this.getUpdateEmbeddedElementStmt(fieldMapping);
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        fieldMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, fieldMapping), value);
                        jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                        jdbcPosition = this.populateEmbeddedElementFieldsInStatement(sm, element, ps, jdbcPosition, ((JoinTable)this.containerTable).getOwnerFieldMetaData());
                        sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                        modified = true;
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)stmt), (Throwable)e);
            }
        }
        return modified;
    }

    protected String getContainsStmt() {
        if (this.containsStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            String containerAlias = "THIS";
            String joinedElementAlias = "ELEM";
            stmt.append("SELECT ");
            for (int i2 = 0; i2 < this.ownerMapping.getNumberOfDatastoreFields(); ++i2) {
                if (i2 > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier()).toString());
            }
            stmt.append(" FROM ");
            stmt.append(this.containerTable.toString()).append(" ").append(containerAlias);
            boolean joinedDiscrim = false;
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerAlias).append(".").append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.elementInfo != null && this.containerTable == this.elementInfo[0].getDatastoreClass() && this.elementInfo[0].getDiscriminatorMapping() != null) {
                stmt.append(" AND (");
                HashSet subclasses = this.storeMgr.getSubClassesForClass(this.elementInfo[0].getClassName(), true, this.clr);
                for (int i3 = 0; i3 < subclasses.size() + 1; ++i3) {
                    JavaTypeMapping discrimMapping = this.elementInfo[0].getDiscriminatorMapping();
                    for (int j = 0; j < discrimMapping.getNumberOfDatastoreFields(); ++j) {
                        if (joinedDiscrim) {
                            stmt.append(joinedElementAlias);
                        } else {
                            stmt.append(containerAlias);
                        }
                        stmt.append(".").append(((Object)discrimMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                        stmt.append(" = ");
                        stmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(j)).getUpdateInputParameter());
                        if (j == discrimMapping.getNumberOfDatastoreFields() - 1 && i3 == subclasses.size()) continue;
                        stmt.append(" OR ");
                    }
                }
                stmt.append(")");
            }
            if (this.relationDiscriminatorMapping != null) {
                for (int i4 = 0; i4 < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i4) {
                    stmt.append(" AND ");
                    stmt.append(containerAlias).append(".").append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i4).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i4)).getUpdateInputParameter());
                }
            }
            this.containsStmt = stmt.toString();
        }
        return this.containsStmt;
    }

    public void update(StateManager sm, Collection coll) {
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(StateManager sm, Object element) {
        boolean retval;
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        String stmt = this.getContainsStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    if (this.elementInfo != null && this.elementInfo[0].getDiscriminatorMapping() != null && this.elementInfo[0].getDatastoreClass() == this.containerTable) {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateElementDiscriminatorInStatement(om, ps, jdbcPosition, true, this.elementInfo[0]);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        retval = rs.next();
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056008", (Object)stmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalRemove(StateManager ownerSM, ManagedConnection conn, boolean batched, Object element, boolean executeNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
        String removeStmt = this.getRemoveStmt();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, this);
            jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
            }
            int[] nArray = sqlControl.executeStatementUpdate(conn, removeStmt, ps, executeNow);
            return nArray;
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    protected String getRemoveStmt() {
        if (this.removeStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("DELETE FROM ");
            stmt.append(this.containerTable.toString());
            boolean joinedDiscrim = false;
            if (this.elementInfo != null && this.elementInfo[0].getDatastoreClass() != this.containerTable && this.elementInfo[0].getDiscriminatorMapping() != null) {
                joinedDiscrim = true;
                stmt.append(" USING ");
                stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.containerTable.toString()).append(".");
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(this.containerTable.toString()).append(".");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.elementInfo != null && this.elementInfo[0].getDiscriminatorMapping() != null) {
                JavaTypeMapping discrimMapping = this.elementInfo[0].getDiscriminatorMapping();
                for (int i2 = 0; i2 < discrimMapping.getNumberOfDatastoreFields(); ++i2) {
                    stmt.append(" AND ");
                    if (joinedDiscrim) {
                        stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
                    } else {
                        stmt.append(this.containerTable.toString());
                    }
                    stmt.append(".");
                    stmt.append(((Object)discrimMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(i2)).getUpdateInputParameter());
                }
            }
            this.removeStmt = stmt.toString();
        }
        return this.removeStmt;
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, collectionTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(collectionTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        stmt.select(collectionTableAlias, this.elementMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, collectionTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(collectionTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(String.class);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    protected RDBMSAssociationStrategy getRDBMSAssociationStrategy() {
        return (RDBMSAssociationStrategy)this.associationStrategy;
    }
}

