/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;

public final class PersistentIDROF
implements ResultObjectFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    private final DatastoreClass table;
    private final boolean ignoreCache;
    protected int[] fieldNumbers;
    protected StatementExpressionIndex[] statementExpressionIndex;
    protected final int[] datastoreIdentityExpressionIndex;
    protected final int[] versionIndex;
    protected boolean discriminator;
    protected final boolean hasMetaDataInResults;
    protected final FetchPlan fetchPlan;
    protected final AbstractClassMetaData acmd;
    private Map resolvedClasses = new SoftValueMap();
    private Map stmtExprIndexes = new SoftValueMap();
    private Class persistentClass;

    public PersistentIDROF(DatastoreClass table, int[] fieldNumbers, AbstractClassMetaData acmd, StatementExpressionIndex[] statementExpressionIndex, int[] datastoreIdentityExpressionIndex, int[] versionIndex, boolean ignoreCache, boolean discriminator, boolean hasMetaDataInResults, FetchPlan fetchPlan, Class persistentClass) {
        this.statementExpressionIndex = statementExpressionIndex;
        this.fieldNumbers = fieldNumbers == null ? new int[0] : fieldNumbers;
        this.acmd = acmd;
        this.table = table;
        this.datastoreIdentityExpressionIndex = datastoreIdentityExpressionIndex;
        this.versionIndex = versionIndex;
        this.ignoreCache = ignoreCache;
        this.discriminator = discriminator;
        this.hasMetaDataInResults = hasMetaDataInResults;
        this.fetchPlan = fetchPlan;
        this.persistentClass = persistentClass;
    }

    public void setPersistentClass(Class cls) {
        this.persistentClass = cls;
    }

    public Object getObject(ObjectManager om, Object rs) {
        String[] subclasses;
        boolean requiresInheritanceCheck = true;
        String className = null;
        if (this.discriminator) {
            className = RDBMSQueryUtils.getClassNameFromDiscriminatorResultSetRow(this.table, (ResultSet)rs, om);
        } else if (this.hasMetaDataInResults) {
            try {
                className = RDBMSQueryUtils.getClassNameFromMetaDataResultSetRow((ResultSet)rs);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class pcClassForObject = this.persistentClass;
        if (className != null) {
            Class cls = (Class)this.resolvedClasses.get(className);
            if (cls != null) {
                pcClassForObject = cls;
            } else {
                pcClassForObject = this.persistentClass.getName().equals(className) ? this.persistentClass : clr.classForName(className, this.persistentClass.getClassLoader());
                this.resolvedClasses.put(className, pcClassForObject);
            }
            requiresInheritanceCheck = false;
        }
        if (Modifier.isAbstract(pcClassForObject.getModifiers()) && (subclasses = om.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) != null) {
            for (int i = 0; i < subclasses.length; ++i) {
                Class subcls = clr.classForName(subclasses[i]);
                if (!Modifier.isAbstract(subcls.getModifiers())) {
                    NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("052300", (Object)pcClassForObject.getName(), (Object)subcls.getName()));
                    pcClassForObject = subcls;
                    break;
                }
                if (i != subclasses.length - 1) continue;
                throw new NucleusUserException(LOCALISER.msg("052301", (Object)pcClassForObject.getName()));
            }
        }
        int[] fieldNumbers = new int[this.fieldNumbers.length];
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr);
        for (int i = 0; i < this.fieldNumbers.length; ++i) {
            if (this.acmd instanceof InterfaceMetaData) {
                fieldNumbers[i] = cmd.getAbsolutePositionOfMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumbers[i]).getName());
                continue;
            }
            fieldNumbers[i] = cmd.getAbsolutePositionOfMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumbers[i]).getClassName(), this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumbers[i]).getName());
            if (fieldNumbers[i] != -1) continue;
            fieldNumbers[i] = cmd.getAbsolutePositionOfMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumbers[i]).getName());
        }
        Object obj = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            obj = this.getObjectByAID(om, (ResultSet)rs, fieldNumbers, cmd, pcClassForObject, requiresInheritanceCheck);
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            OIDMapping mapping = new OIDMapping();
            mapping.initialize(this.table.getStoreManager().getDatastoreAdapter(), pcClassForObject.getName());
            mapping.addDataStoreMapping(this.table.getDataStoreObjectIdMapping().getDataStoreMapping(0));
            Object id = ((JavaTypeMapping)mapping).getObject(om, rs, this.datastoreIdentityExpressionIndex);
            obj = fieldNumbers == null ? om.findObject(id, false, requiresInheritanceCheck, null) : (requiresInheritanceCheck ? this.getObjectById(om, (ResultSet)rs, fieldNumbers, cmd, id, null) : this.getObjectById(om, (ResultSet)rs, fieldNumbers, cmd, id, pcClassForObject));
        } else if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            Object id = om.newObjectId(className, null);
            obj = fieldNumbers == null ? om.findObject(id, false, requiresInheritanceCheck, null) : this.getObjectById(om, (ResultSet)rs, fieldNumbers, cmd, id, pcClassForObject);
        }
        int versionFieldNumber = -1;
        VersionMetaData vermd = this.table.getVersionMetaData();
        if (vermd != null && vermd.getFieldName() != null) {
            versionFieldNumber = this.acmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber();
            StateManager objSM = om.findStateManager(obj);
            Object verFieldValue = objSM.provideField(versionFieldNumber);
            if (verFieldValue != null) {
                objSM.setVersion(verFieldValue);
            }
        }
        if (this.versionIndex != null) {
            JavaTypeMapping mapping = this.table.getVersionMapping(true);
            Object version = mapping.getObject(om, rs, this.versionIndex);
            StateManager objSM = om.findStateManager(obj);
            objSM.setVersion(version);
        }
        return obj;
    }

    private Object getObjectByAID(ObjectManager om, final ResultSet rs, final int[] fieldNumbers, AbstractClassMetaData cmd, Class pcClass, boolean requiresInheritanceCheck) {
        StatementExpressionIndex[] indexes = (StatementExpressionIndex[])this.stmtExprIndexes.get(cmd.getFullClassName());
        if (indexes == null) {
            indexes = new StatementExpressionIndex[cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers()];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                indexes[fieldNumbers[i]] = this.statementExpressionIndex[this.fieldNumbers[i]];
            }
            this.stmtExprIndexes.put(cmd.getFullClassName(), indexes);
        }
        final StatementExpressionIndex[] stmtExprIndex = indexes;
        return om.findObjectUsingAID(pcClass, new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(fieldNumbers, (FieldManager)new ResultSetGetter(sm, rs, stmtExprIndex), false);
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(fieldNumbers, (FieldManager)new ResultSetGetter(sm, rs, stmtExprIndex));
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentIDROF.this.fetchPlan;
            }
        }, this.ignoreCache, requiresInheritanceCheck);
    }

    private Object getObjectById(ObjectManager om, final ResultSet rs, final int[] fieldNumbers, AbstractClassMetaData cmd, Object oid, Class pcClass) {
        if (oid == null) {
            return null;
        }
        StatementExpressionIndex[] indexes = (StatementExpressionIndex[])this.stmtExprIndexes.get(cmd.getFullClassName());
        if (indexes == null) {
            indexes = new StatementExpressionIndex[cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers()];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                indexes[fieldNumbers[i]] = this.statementExpressionIndex[this.fieldNumbers[i]];
            }
            this.stmtExprIndexes.put(cmd.getFullClassName(), indexes);
        }
        final StatementExpressionIndex[] stmtExprIndex = indexes;
        if (pcClass == null) {
            return om.findObject(oid, new FieldValues(){

                public void fetchFields(StateManager sm) {
                    sm.replaceFields(fieldNumbers, (FieldManager)new ResultSetGetter(sm, rs, stmtExprIndex), false);
                }

                public void fetchNonLoadedFields(StateManager sm) {
                    sm.replaceNonLoadedFields(fieldNumbers, (FieldManager)new ResultSetGetter(sm, rs, stmtExprIndex));
                }

                public FetchPlan getFetchPlanForLoading() {
                    return PersistentIDROF.this.fetchPlan;
                }
            });
        }
        return om.findObject(oid, new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(fieldNumbers, (FieldManager)new ResultSetGetter(sm, rs, stmtExprIndex), false);
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(fieldNumbers, (FieldManager)new ResultSetGetter(sm, rs, stmtExprIndex));
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentIDROF.this.fetchPlan;
            }
        }, pcClass, this.ignoreCache);
    }
}

