/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.JPQLSingleStringParser;
import org.datanucleus.store.Extent;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.query.CollectionCandidates;
import org.datanucleus.store.rdbms.query.JPQLQueryCompiler;
import org.datanucleus.store.rdbms.query.PersistentIDROF;
import org.datanucleus.store.rdbms.query.SQLEvaluator;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    protected transient QueryExpression queryStmt = null;
    protected transient Queryable candidates = null;
    protected transient String candidateAlias = "this";
    protected transient ResultObjectFactory rof = null;
    protected transient boolean isCompiled = false;

    public JPQLQuery(ObjectManager om) {
        this(om, (JPQLQuery)null);
    }

    public JPQLQuery(ObjectManager om, JPQLQuery q) {
        super(om, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(ObjectManager om, String query) {
        super(om);
        new JPQLSingleStringParser((Query)this, query).parse();
    }

    public Queryable getCandidates() {
        return this.candidates;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JPQLQuery && super.equals(obj);
    }

    protected void discardCompiled() {
        this.isCompiled = false;
        this.rof = null;
        this.queryStmt = null;
        super.discardCompiled();
    }

    protected boolean isCompiled() {
        return this.isCompiled;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.isCompiled) {
            return;
        }
        try {
            if (forExecute) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021044", (Object)"JPQL", (Object)this.getSingleStringQuery(), (Object)"execution"));
                }
                JPQLQueryCompiler c = new JPQLQueryCompiler(this, this.getParsedImports(), parameterValues);
                this.queryStmt = (QueryExpression)c.compile(4);
                if (this.resultDistinct) {
                    this.queryStmt.setDistinctResults(true);
                }
                this.resultMetaData = c.getResultMetaData();
                this.candidateClass = c.getCandidateClass();
                this.candidateAlias = c.getCandidateAlias();
                this.candidates = c.getCandidates();
                this.resultClass = c.getResultClass();
                this.fromInclNo = c.getRangeFromIncl();
                this.toExclNo = c.getRangeToExcl();
                c.close();
                c = null;
            } else {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021044", (Object)"JPQL", (Object)this.getSingleStringQuery(), (Object)"precompile"));
                }
                JPQLQueryCompiler c = new JPQLQueryCompiler(this, this.getParsedImports(), parameterValues);
                c.compile(3);
                this.resultMetaData = c.getResultMetaData();
                this.candidateClass = c.getCandidateClass();
                this.candidateAlias = c.getCandidateAlias();
                this.candidates = c.getCandidates();
                this.resultClass = c.getResultClass();
                this.fromInclNo = c.getRangeFromIncl();
                this.toExclNo = c.getRangeToExcl();
                c.close();
                c = null;
            }
            this.isCompiled = true;
        }
        catch (NucleusException jpe) {
            this.discardCompiled();
            this.isCompiled = false;
            throw jpe;
        }
    }

    protected Object executeQuery(Map parameters) {
        this.discardCompiled();
        HashMap params = new HashMap();
        if (this.implicitParameters != null) {
            params.putAll(this.implicitParameters);
        }
        if (parameters != null) {
            params.putAll(parameters);
        }
        return super.executeQuery(params);
    }

    protected Object performExecute(Map executeParameters) {
        boolean useFetchPlan;
        if (this.candidates.isEmpty()) {
            return new ArrayList();
        }
        if (this.candidates instanceof CollectionCandidates) {
            ((CollectionCandidates)this.candidates).getFetchPlan().setGroups((Collection)this.getFetchPlan().getGroups());
        } else if (this.candidates instanceof Extent) {
            ((Extent)this.candidates).getFetchPlan().setGroups((Collection)this.getFetchPlan().getGroups());
        }
        Boolean useFPVal = this.getBooleanExtensionProperty("datanucleus.query.useFetchPlan");
        boolean bl = useFetchPlan = useFPVal != null ? useFPVal : true;
        if (this.type == 1 || this.type == 2) {
            useFetchPlan = false;
        }
        this.rof = this.candidates.newResultObjectFactory(this.queryStmt, this.getIgnoreCache(), this.resultClass, useFetchPlan);
        if (this.rof instanceof PersistentIDROF) {
            ((PersistentIDROF)this.rof).setPersistentClass(this.candidateClass);
        }
        this.prepareDatastore();
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery()));
        }
        SQLEvaluator eval = new SQLEvaluator((Query)this, this.rof, this.candidateCollection);
        QueryResult qr = (QueryResult)eval.evaluate(this.queryStmt);
        this.queryResults.add(qr);
        return qr;
    }

    protected long performDeletePersistentAll(Map parameters) {
        this.discardCompiled();
        return super.performDeletePersistentAll(parameters);
    }
}

