/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.Extent;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.query.CollectionCandidates;
import org.datanucleus.store.rdbms.query.JDOQLQueryCompiler;
import org.datanucleus.store.rdbms.query.PersistentIDROF;
import org.datanucleus.store.rdbms.query.SQLEvaluator;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    protected transient QueryExpression queryStmt = null;
    protected transient Queryable candidates = null;
    protected transient ResultObjectFactory rof = null;
    protected transient boolean isCompiled = false;

    public JDOQLQuery(ObjectManager om) {
        this(om, (JDOQLQuery)null);
    }

    public JDOQLQuery(ObjectManager om, JDOQLQuery q) {
        super(om, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(ObjectManager om, String query) {
        super(om, query);
    }

    public Queryable getCandidates() {
        return this.candidates;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JDOQLQuery && super.equals(obj);
    }

    protected void discardCompiled() {
        this.isCompiled = false;
        this.rof = null;
        this.queryStmt = null;
        super.discardCompiled();
    }

    protected boolean isCompiled() {
        return this.isCompiled;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.isCompiled) {
            return;
        }
        try {
            if (forExecute) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021044", (Object)"JDOQL", (Object)this.getSingleStringQuery(), (Object)"execution"));
                }
                JDOQLQueryCompiler c = new JDOQLQueryCompiler(this, this.getParsedImports(), parameterValues);
                this.queryStmt = (QueryExpression)c.compile(4);
                if (this.resultDistinct) {
                    this.queryStmt.setDistinctResults(true);
                }
                this.resultMetaData = c.getResultMetaData();
                this.candidateClass = c.getCandidateClass();
                this.candidates = c.getCandidates();
                this.resultClass = c.getResultClass();
                this.fromInclNo = c.getRangeFromIncl();
                this.toExclNo = c.getRangeToExcl();
                c.close();
                c = null;
            } else {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021044", (Object)"JDOQL", (Object)this.getSingleStringQuery(), (Object)"precompile"));
                }
                JDOQLQueryCompiler c = new JDOQLQueryCompiler(this, this.getParsedImports(), null);
                c.compile(3);
                this.resultMetaData = c.getResultMetaData();
                this.candidateClass = c.getCandidateClass();
                this.candidates = c.getCandidates();
                this.resultClass = c.getResultClass();
                this.fromInclNo = c.getRangeFromIncl();
                this.toExclNo = c.getRangeToExcl();
                c.close();
                c = null;
            }
            this.isCompiled = true;
        }
        catch (NucleusException jpe) {
            this.discardCompiled();
            this.isCompiled = false;
            throw jpe;
        }
    }

    protected Object executeQuery(Map parameters) {
        this.discardCompiled();
        return super.executeQuery(parameters);
    }

    protected Object performExecute(Map parameters) {
        boolean useFetchPlan;
        if (this.candidates.isEmpty()) {
            return new ArrayList();
        }
        if (this.candidates instanceof CollectionCandidates) {
            ((CollectionCandidates)this.candidates).getFetchPlan().setGroups((Collection)this.getFetchPlan().getGroups());
        } else if (this.candidates instanceof Extent) {
            ((Extent)this.candidates).getFetchPlan().setGroups((Collection)this.getFetchPlan().getGroups());
        }
        Boolean useFPVal = this.getBooleanExtensionProperty("datanucleus.query.useFetchPlan");
        boolean bl = useFetchPlan = useFPVal != null ? useFPVal : true;
        if (this.type == 1 || this.type == 2) {
            useFetchPlan = false;
        }
        this.rof = this.candidates.newResultObjectFactory(this.queryStmt, this.getIgnoreCache(), this.resultClass, useFetchPlan);
        if (this.rof instanceof PersistentIDROF) {
            ((PersistentIDROF)this.rof).setPersistentClass(this.candidateClass);
        }
        this.prepareDatastore();
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery()));
        }
        SQLEvaluator eval = new SQLEvaluator((Query)this, this.rof, this.candidateCollection);
        QueryResult qr = (QueryResult)eval.evaluate(this.queryStmt);
        this.queryResults.add(qr);
        return qr;
    }

    protected long performDeletePersistentAll(Map parameters) {
        this.discardCompiled();
        return super.performDeletePersistentAll(parameters);
    }

    protected boolean applyRangeChecks() {
        boolean range_specified;
        boolean bl = range_specified = this.fromInclNo >= 0L && this.toExclNo >= 0L && (this.fromInclNo != 0L || this.toExclNo != Long.MAX_VALUE);
        if (!range_specified) {
            return false;
        }
        RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        boolean using_limit_select_clause = dba.getRangeByLimitSelectClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_limit_where_clause = dba.getRangeByLimitWhereClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_rownum = dba.getRangeByRowNumberColumn().length() > 0;
        boolean applyRangeChecks = range_specified && !using_limit_select_clause && !using_limit_where_clause && !using_rownum;
        return applyRangeChecks;
    }
}

