/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUserException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.JDOQLQuery;
import org.datanucleus.store.rdbms.query.JPQLQuery;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class ForwardQueryResult
extends AbstractRDBMSQueryResult
implements QueryResult,
Serializable {
    private int size = -1;
    protected boolean moreResultSetRows;
    protected List resultObjs = new ArrayList();
    private Collection candidates;
    private boolean loadResultsAtCommit = true;
    private String resultSizeMethod = "last";

    public ForwardQueryResult(QueryExpression qs, Query query, ResultObjectFactory rof, ResultSet rs, Collection candidates) throws SQLException {
        super(qs, query, rof, rs);
        String ext;
        if (candidates != null) {
            this.candidates = new ArrayList(candidates);
        }
        if ((ext = (String)query.getExtension("datanucleus.query.resultSizeMethod")) != null) {
            this.resultSizeMethod = ext;
        }
        if ((ext = (String)query.getExtension("datanucleus.query.loadResultsAtCommit")) != null) {
            this.loadResultsAtCommit = new Boolean(ext);
        }
        int fetchSize = query.getFetchPlan().getFetchSize();
        this.moreResultSetRows = rs.next();
        if (!this.moreResultSetRows) {
            this.closeResults();
        } else if (!query.getObjectManager().getTransaction().isActive() || fetchSize == -1) {
            this.advanceToEndOfResultSet();
        } else if (fetchSize > 0) {
            Iterator it = this.iterator();
            for (int i = 0; i < fetchSize; ++i) {
                if (!it.hasNext()) continue;
                it.next();
            }
        }
    }

    private void advanceToEndOfResultSet() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
        }
    }

    protected Object nextResultSetElement() {
        if (this.rof == null) {
            return null;
        }
        Object nextElement = this.rof.getObject(this.query.getObjectManager(), (Object)this.rs);
        SQLWarnings.log(this.rs);
        this.resultObjs.add(nextElement);
        try {
            this.moreResultSetRows = this.rs.next();
            if (!this.moreResultSetRows) {
                this.closeResults();
            }
        }
        catch (SQLException e) {
            if (this.query.getObjectManager().getOMFContext().getApi().equalsIgnoreCase("JDO")) {
                throw new JDODataStoreException(LOCALISER.msg("052601", (Object)e));
            }
            throw new NucleusDataStoreException(LOCALISER.msg("052601", (Object)e));
        }
        return nextElement;
    }

    public synchronized void close() {
        this.moreResultSetRows = false;
        this.resultObjs.clear();
        super.close();
    }

    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen() && this.moreResultSetRows) {
            NucleusLogger.QUERY.info((Object)LOCALISER.msg("052606", (Object)this.query.toString()));
            try {
                this.advanceToEndOfResultSet();
            }
            catch (NucleusUserException jpue) {
                NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + jpue.getMessage()));
            }
            catch (JDOUserException ue) {
                NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + ue.getMessage()));
            }
        }
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public synchronized boolean contains(Object o) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.contains(o);
    }

    public synchronized boolean containsAll(Collection c) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.containsAll(c);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ForwardQueryResult)) {
            return false;
        }
        ForwardQueryResult other = (ForwardQueryResult)o;
        if (this.qs != null) {
            return other.qs == this.qs;
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)other).equals(StringUtils.toJVMIDString((Object)this));
    }

    public synchronized Object get(int index) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.get(index);
    }

    public synchronized boolean isEmpty() {
        this.assertIsOpen();
        return this.resultObjs.isEmpty() && !this.moreResultSetRows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int size() {
        this.assertIsOpen();
        if (this.size >= 0) return this.size;
        if (this.resultSizeMethod.equalsIgnoreCase("LAST")) {
            this.advanceToEndOfResultSet();
            this.size = this.resultObjs.size();
            return this.size;
        } else {
            if (!this.resultSizeMethod.equalsIgnoreCase("COUNT")) throw new NucleusUserException("DataNucleus doesnt currently support any method \"" + this.resultSizeMethod + "\" for determining the size of the query results");
            if (this.query instanceof JDOQLQuery) {
                JDOQLQuery countQuery = new JDOQLQuery(this.query.getObjectManager(), (JDOQLQuery)this.query);
                countQuery.setResult("count(this)");
                countQuery.setOrdering(null);
                Map queryParams = this.query.getInputParameters();
                long count = queryParams != null ? ((Long)countQuery.executeWithMap(queryParams)).longValue() : ((Long)countQuery.execute()).longValue();
                countQuery.closeAll();
                this.size = (int)count;
                return this.size;
            } else {
                if (!(this.query instanceof JPQLQuery)) throw new NucleusUserException("datanucleus.query.resultSizeMethod is only valid for use with JDOQL or JPQL currently");
                JPQLQuery countQuery = new JPQLQuery(this.query.getObjectManager(), (JPQLQuery)this.query);
                countQuery.setResult("count(" + ((JPQLQuery)this.query).candidateAlias + ")");
                countQuery.setOrdering(null);
                Map queryParams = this.query.getInputParameters();
                long count = queryParams != null ? ((Long)countQuery.executeWithMap(queryParams)).longValue() : ((Long)countQuery.execute()).longValue();
                countQuery.closeAll();
                this.size = (int)count;
            }
        }
        return this.size;
    }

    public synchronized Object[] toArray() {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray(a);
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator {
        private int nextRowNum = 0;
        Object nextElement = null;

        private QueryResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                if (!ForwardQueryResult.this.isOpen()) {
                    return false;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    return true;
                }
                if (ForwardQueryResult.this.candidates != null && this.nextElement != null && !ForwardQueryResult.this.moreResultSetRows) {
                    return ForwardQueryResult.this.candidates.contains(this.nextElement);
                }
                return ForwardQueryResult.this.moreResultSetRows;
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object next() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                if (!ForwardQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (ForwardQueryResult.this.candidates != null && this.nextElement != null && ForwardQueryResult.this.candidates.remove(this.nextElement)) {
                    ForwardQueryResult.this.resultObjs.add(this.nextElement);
                    return this.nextElement;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    this.nextElement = ForwardQueryResult.this.resultObjs.get(this.nextRowNum);
                    ++this.nextRowNum;
                    return this.nextElement;
                }
                if (ForwardQueryResult.this.moreResultSetRows) {
                    this.nextElement = ForwardQueryResult.this.nextResultSetElement();
                    ++this.nextRowNum;
                    if (ForwardQueryResult.this.candidates != null) {
                        ForwardQueryResult.this.candidates.remove(this.nextElement);
                    }
                    return this.nextElement;
                }
                throw new NoSuchElementException(LOCALISER.msg("052602"));
            }
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

