/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOUserException;
import javax.jdo.datastore.JDOConnection;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.util.Localiser;

public final class JDOConnectionImpl
implements Connection,
JDOConnection,
NucleusConnection {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.jdo.Localisation", (ClassLoader)JDOPersistenceManagerFactory.class.getClassLoader());
    private final Connection conn;
    private final Runnable onClose;
    private boolean isAvailable = true;

    public JDOConnectionImpl(Object conn, Runnable onClose) {
        this.conn = (Connection)conn;
        this.onClose = onClose;
    }

    public int getHoldability() throws SQLException {
        this.assertAvailable();
        return this.conn.getHoldability();
    }

    public int getTransactionIsolation() throws SQLException {
        this.assertAvailable();
        return this.conn.getTransactionIsolation();
    }

    public void clearWarnings() throws SQLException {
        this.assertAvailable();
        this.conn.clearWarnings();
    }

    public void close() {
        this.assertAvailable();
        this.isAvailable = false;
        this.onClose.run();
    }

    public void commit() throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"commit"));
    }

    public void rollback() throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"rollback"));
    }

    public boolean getAutoCommit() throws SQLException {
        this.assertAvailable();
        return this.conn.getAutoCommit();
    }

    public boolean isClosed() throws SQLException {
        if (this.isAvailable) {
            return this.conn.isClosed();
        }
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        this.assertAvailable();
        return this.conn.isReadOnly();
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"setHoldability"));
    }

    public void setTransactionIsolation(int level) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"setTransactionIsolation"));
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"setAutoCommit"));
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"setReadOnly"));
    }

    public String getCatalog() throws SQLException {
        this.assertAvailable();
        return this.conn.getCatalog();
    }

    public void setCatalog(String catalog) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"setCatalog"));
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"getMetaData"));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.assertAvailable();
        return this.conn.getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"setSavepoint"));
    }

    public void releaseSavepoint(Savepoint pt) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"releaseSavepoint"));
    }

    public void rollback(Savepoint pt) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"rollback"));
    }

    public Statement createStatement() throws SQLException {
        this.assertAvailable();
        return this.conn.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertAvailable();
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertAvailable();
        return this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Map getTypeMap() throws SQLException {
        this.assertAvailable();
        return this.conn.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"setTypeMap"));
    }

    public String nativeSQL(String sql) throws SQLException {
        this.assertAvailable();
        return this.conn.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareCall(arg0, arg1, arg2, arg3);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(arg0, arg1);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(arg0, arg1, arg2, arg3);
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(arg0, arg1);
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new JDOUserException(LOCALISER.msg("046000", (Object)"setSavepoint"));
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(arg0, arg1);
    }

    public void assertAvailable() {
        if (!this.isAvailable) {
            throw new JDOUserException(LOCALISER.msg("046001"));
        }
    }

    public Object getNativeConnection() {
        return this.conn;
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    public Blob createBlob() throws SQLException {
        return null;
    }

    public Clob createClob() throws SQLException {
        return null;
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    public Properties getClientInfo() throws SQLException {
        return null;
    }

    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    public void setClientInfo(Properties properties) {
    }

    public void setClientInfo(String name, String value) {
    }

    public NClob createNClob() throws SQLException {
        return null;
    }

    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return Connection.class.equals((Object)iface);
    }

    public Object unwrap(Class iface) throws SQLException {
        if (!Connection.class.equals((Object)iface)) {
            throw new SQLException("Connection of type [" + this.getClass().getName() + "] can only be unwrapped as [java.sql.Connection], not as [" + iface.getName() + "]");
        }
        return this;
    }
}

