/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.util.StringUtils;

public class InterfaceMapping
extends ReferenceMapping {
    private String implementationClasses;

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        Class fieldTypeCls;
        super.initialize(dba, mmd, container, clr);
        if (mmd.getType().isInterface() && mmd.getFieldTypes() != null && mmd.getFieldTypes().length == 1 && (fieldTypeCls = clr.classForName(mmd.getFieldTypes()[0])).isInterface()) {
            this.type = mmd.getFieldTypes()[0];
        }
    }

    public void setImplementationClasses(String implementationClasses) {
        this.implementationClasses = implementationClasses;
    }

    public Object getObject(ObjectManager om, Object rs, int[] pos) {
        if (om.getMetaDataManager().isPersistentInterface(this.type)) {
            String[] implTypes = null;
            implTypes = this.implementationClasses != null ? StringUtils.split((String)this.implementationClasses, (String)",") : om.getMetaDataManager().getClassesImplementingInterface(this.getType(), om.getClassLoaderResolver());
            int n = 0;
            for (int i = 0; i < implTypes.length; ++i) {
                JavaTypeMapping mapping;
                if (implTypes.length > this.javaTypeMappings.length) {
                    int j;
                    PersistenceCapableMapping m = (PersistenceCapableMapping)this.javaTypeMappings[0];
                    MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
                    mapping = storeMgr.getMappingManager().getMapping(om.getClassLoaderResolver().classForName(implTypes[i]));
                    for (j = 0; j < m.getDataStoreMappings().length; ++j) {
                        mapping.addDataStoreMapping(m.getDataStoreMappings()[j]);
                    }
                    for (j = 0; j < m.getJavaTypeMapping().length; ++j) {
                        ((PersistenceCapableMapping)mapping).addJavaTypeMapping(m.getJavaTypeMapping()[j]);
                    }
                    ((PersistenceCapableMapping)mapping).setReferenceMapping(m.getReferenceMapping());
                } else {
                    mapping = this.javaTypeMappings[i];
                }
                if (n >= pos.length) {
                    n = 0;
                }
                int[] posMapping = mapping.getReferenceMapping() != null ? new int[mapping.getReferenceMapping().getNumberOfDatastoreFields()] : new int[mapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = pos[n++];
                }
                Object value = null;
                try {
                    value = mapping.getObject(om, rs, posMapping);
                }
                catch (NullValueException e) {
                }
                catch (NucleusObjectNotFoundException onfe) {
                    // empty catch block
                }
                if (value == null) continue;
                if (value instanceof OID) {
                    String className = mapping.getReferenceMapping() != null ? mapping.getReferenceMapping().getDataStoreMapping(0).getDatastoreField().getStoredJavaType() : mapping.getDataStoreMapping(0).getDatastoreField().getStoredJavaType();
                    value = OIDFactory.getInstance((ObjectManager)om, (String)className, (Object)((OID)value).getKeyValue());
                    return om.findObject(value, false, true, null);
                }
                if (!om.getClassLoaderResolver().classForName(this.getType()).isAssignableFrom(value.getClass())) continue;
                return value;
            }
            return null;
        }
        return super.getObject(om, rs, pos);
    }
}

