/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.expression.JoinExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class ClassExpression
extends ScalarExpression {
    private Class cls;
    private List joinExprs;

    public ClassExpression(QueryExpression qs, Class cls) {
        super(qs);
        this.cls = cls;
    }

    public Class getCls() {
        return this.cls;
    }

    public ScalarExpression accessField(String fieldName, boolean innerJoin) {
        try {
            Field fld = this.cls.getField(fieldName);
            if (!(Modifier.isStatic(fld.getModifiers()) && Modifier.isFinal(fld.getModifiers()) && Modifier.isPublic(fld.getModifiers()))) {
                throw new NucleusUserException(LOCALISER.msg("037008", (Object)fieldName, (Object)this.cls.getName()));
            }
            Object value = fld.get(null);
            if (value == null) {
                return new NullLiteral(this.qs);
            }
            JavaTypeMapping m = null;
            ApiAdapter api = this.qs.getStoreManager().getApiAdapter();
            if (api.isPersistable(this.cls)) {
                try {
                    DatastoreClass clsTable = this.qs.getStoreManager().getDatastoreClass(this.cls.getName(), this.qs.getClassLoaderResolver());
                    m = clsTable.getFieldMapping(fieldName);
                }
                catch (Exception e) {
                    m = this.qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(value.getClass(), false, false, this.qs.getClassLoaderResolver());
                }
            } else {
                m = this.qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(value.getClass(), false, false, this.qs.getClassLoaderResolver());
            }
            return m.newLiteral(this.qs, value);
        }
        catch (IllegalAccessException iae) {
        }
        catch (NoSuchFieldException nsfe) {
            throw new NucleusUserException(LOCALISER.msg("037009", (Object)fieldName, (Object)this.cls.getName()));
        }
        return null;
    }

    public ScalarExpression join(JoinExpression expr) {
        if (this.joinExprs == null) {
            this.joinExprs = new ArrayList();
        }
        this.joinExprs.add(expr);
        return this;
    }

    public JoinExpression[] getJoins() {
        if (this.joinExprs == null) {
            return null;
        }
        return this.joinExprs.toArray(new JoinExpression[this.joinExprs.size()]);
    }
}

