/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class StringIndexOf5Method
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(LOCALISER.msg("060003", (Object)"indexOf", (Object)"StringExpression", (Object)0, (Object)"StringExpression/CharacterExpression"));
        }
        SQLExpression substrExpr = (SQLExpression)args.get(0);
        if (!(substrExpr instanceof StringExpression) && !(substrExpr instanceof CharacterExpression)) {
            throw new NucleusException(LOCALISER.msg("060003", (Object)"indexOf", (Object)"StringExpression", (Object)0, (Object)"StringExpression/CharacterExpression"));
        }
        SQLExpression one = ExpressionUtils.getLiteralForOne(expr.getSQLStatement());
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(expr);
        funcArgs.add(substrExpr);
        if (args.size() == 2) {
            throw new NucleusUserException("PostgreSQL doesnt currently provide a function for providing indexOf(str, from). Your workaround is to miss off the 'from' position");
        }
        NumericExpression locateExpr = new NumericExpression("STRPOS", funcArgs);
        return new NumericExpression(locateExpr, Expression.OP_SUB, one);
    }
}

