/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MapStoreQueryable;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.PersistentIDROF;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.scostore.MapStore;

abstract class AbstractMapStore
extends BaseContainerStore
implements MapStore,
MapStoreQueryable {
    protected boolean iterateUsingDiscriminator = false;
    protected DatastoreContainerObject mapTable;
    protected DatastoreClass valueTable;
    protected AbstractClassMetaData kmd;
    protected AbstractClassMetaData vmd;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    protected String keyType;
    protected String valueType;
    protected boolean keysAreEmbedded;
    protected boolean keysAreSerialised;
    protected boolean valuesAreEmbedded;
    protected boolean valuesAreSerialised;
    protected String containsValueStmt;
    protected final DatastoreIdentifier elmIdentifier;

    public AbstractMapStore(StoreManager storeMgr) {
        super(storeMgr);
        this.elmIdentifier = ((MappedStoreManager)storeMgr).getIdentifierFactory().newIdentifier(0, "ELEMENT");
    }

    protected void initialiseStatements() {
        this.containsValueStmt = this.getContainsValueStmt();
    }

    public boolean keysAreEmbedded() {
        return this.keysAreEmbedded;
    }

    public boolean keysAreSerialised() {
        return this.keysAreSerialised;
    }

    public boolean valuesAreEmbedded() {
        return this.valuesAreEmbedded;
    }

    public boolean valuesAreSerialised() {
        return this.valuesAreSerialised;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public boolean containsKey(StateManager sm, Object key) {
        if (key == null) {
            return false;
        }
        try {
            this.getValue(sm, key);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(StateManager sm, Object value) {
        if (value == null) {
            return false;
        }
        if (!this.validateValueForReading(sm, value)) {
            return false;
        }
        boolean exists = false;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, this.containsValueStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateValueInStatement(om, ps, value, jdbcPosition);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, this.containsValueStmt, ps);
                    try {
                        if (rs.next()) {
                            exists = true;
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056019", (Object)this.containsValueStmt), (Throwable)e);
        }
        return exists;
    }

    public Object get(StateManager sm, Object key) {
        try {
            return this.getValue(sm, key);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void putAll(StateManager sm, Map m) {
        for (Map.Entry e : m.entrySet()) {
            this.put(sm, e.getKey(), e.getValue());
        }
    }

    private String getContainsValueStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    protected void validateKeyType(ClassLoaderResolver clr, Object key) {
        if (key == null) {
            throw new NullPointerException(LOCALISER.msg("056062"));
        }
        if (!clr.isAssignableFrom(this.keyType, key.getClass())) {
            throw new ClassCastException(LOCALISER.msg("056064", (Object)key.getClass().getName(), (Object)this.keyType));
        }
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value != null && !clr.isAssignableFrom(this.valueType, value.getClass())) {
            throw new ClassCastException(LOCALISER.msg("056065", (Object)value.getClass().getName(), (Object)this.valueType));
        }
    }

    protected boolean validateKeyForReading(StateManager sm, Object key) {
        this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), key);
        if (!this.keysAreEmbedded && !this.keysAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            if (!(key == null || om.getApiAdapter().isPersistent(key) && om == ObjectManagerHelper.getObjectManager((Object)key) || om.getApiAdapter().isDetached(key))) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateValueForReading(StateManager sm, Object value) {
        this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), value);
        if (!this.valuesAreEmbedded && !this.valuesAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            if (!(value == null || om.getApiAdapter().isPersistent(value) && om == ObjectManagerHelper.getObjectManager((Object)value) || om.getApiAdapter().isDetached(value))) {
                return false;
            }
        }
        return true;
    }

    protected void validateKeyForWriting(StateManager sm, Object key) {
        this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), key);
        if (!this.keysAreEmbedded && !this.keysAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            SCOUtils.validateObjectForWriting((ObjectManager)om, (Object)key, null);
        }
    }

    protected void validateValueForWriting(StateManager sm, Object value) {
        this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), value);
        if (!this.valuesAreEmbedded && !this.valuesAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            SCOUtils.validateObjectForWriting((ObjectManager)om, (Object)value, null);
        }
    }

    protected QueryExpression getGetStatement(StateManager ownerSm, Object key) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue(StateManager sm, Object key) throws NoSuchElementException {
        if (!this.validateKeyForReading(sm, key)) {
            return null;
        }
        QueryExpression stmt = this.getGetStatement(sm, key);
        ResultObjectFactory rof = this.newResultObjectFactory(sm, stmt, false, true);
        ObjectManager om = sm.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        String statement = this.storeMgr.getStatementTextForQuery(stmt, useUpdateLock);
        Object value = null;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = this.storeMgr.getStatementForQuery(stmt, om, mconn, useUpdateLock, null, null);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                    try {
                        boolean found = rs.next();
                        if (!found) {
                            throw new NoSuchElementException();
                        }
                        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            if (this.valueMapping instanceof SerialisedPCMapping || this.valueMapping instanceof SerialisedReferenceMapping || this.valueMapping instanceof EmbeddedKeyPCMapping) {
                                int ownerFieldNumber = -1;
                                if (this.mapTable != null) {
                                    ownerFieldNumber = ((JoinTable)this.mapTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                                }
                                value = this.valueMapping.getObject(om, rs, param, sm, ownerFieldNumber);
                            } else {
                                value = this.valueMapping.getObject(om, rs, param);
                            }
                        } else if (this.valueMapping instanceof ReferenceMapping) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            value = this.valueMapping.getObject(om, rs, param);
                        } else {
                            value = rof.getObject(om, (Object)rs);
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056014", (Object)statement), (Throwable)e);
        }
        return value;
    }

    protected int populateKeyInStatement(ObjectManager om, PreparedStatement ps, Object key, int jdbcPosition) {
        if (!((RDBMSMapping)this.keyMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        this.keyMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.keyMapping), key);
        return jdbcPosition + this.keyMapping.getNumberOfDatastoreFields();
    }

    protected int populateValueInStatement(ObjectManager om, PreparedStatement ps, Object value, int jdbcPosition) {
        if (!((RDBMSMapping)this.valueMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        this.valueMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.valueMapping), value);
        return jdbcPosition + this.valueMapping.getNumberOfDatastoreFields();
    }

    protected int populateEmbeddedKeyFieldsInStatement(StateManager sm, Object key, PreparedStatement ps, int jdbcPosition, JoinTable joinTable) {
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)this.keyMapping;
        StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[this.kmd.getNoOfManagedMembers() + this.kmd.getNoOfInheritedManagedMembers()];
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = this.kmd.getAbsolutePositionOfMember(fieldMapping.getFieldMetaData().getName());
            if (fieldMapping == null) continue;
            statementExpressionIndex[absFieldNum] = new StatementExpressionIndex();
            statementExpressionIndex[absFieldNum].setMapping(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            statementExpressionIndex[absFieldNum].setParameterIndex(jdbcParamPositions);
        }
        StateManager elementSM = this.getStateManagerForEmbeddedPCObject(sm, key, joinTable);
        elementSM.setPcObjectType(3);
        elementSM.provideFields(elementFieldNumbers, (FieldManager)new ParameterSetter(elementSM, ps, statementExpressionIndex, true));
        return jdbcPosition;
    }

    protected int populateEmbeddedValueFieldsInStatement(StateManager sm, Object value, PreparedStatement ps, int jdbcPosition, JoinTable joinTable) {
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)this.valueMapping;
        StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[this.vmd.getNoOfManagedMembers() + this.vmd.getNoOfInheritedManagedMembers()];
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = this.vmd.getAbsolutePositionOfMember(fieldMapping.getFieldMetaData().getName());
            if (fieldMapping == null) continue;
            statementExpressionIndex[absFieldNum] = new StatementExpressionIndex();
            statementExpressionIndex[absFieldNum].setMapping(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            statementExpressionIndex[absFieldNum].setParameterIndex(jdbcParamPositions);
        }
        StateManager elementSM = this.getStateManagerForEmbeddedPCObject(sm, value, joinTable);
        elementSM.setPcObjectType(4);
        elementSM.provideFields(elementFieldNumbers, (FieldManager)new ParameterSetter(elementSM, ps, statementExpressionIndex, true));
        return jdbcPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedKey(StateManager sm, Object key, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.keyMapping != null && this.keyMapping instanceof EmbeddedKeyPCMapping) {
            String fieldName = this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedKeyPCMapping)this.keyMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            String stmt = this.getUpdateEmbeddedKeyStmt(fieldMapping);
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        fieldMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, fieldMapping), key);
                        jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateEmbeddedKeyFieldsInStatement(sm, key, ps, jdbcPosition, (JoinTable)this.mapTable);
                        sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                        modified = true;
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new NucleusDataStoreException(LOCALISER.msg("056010", (Object)stmt), (Throwable)e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedValue(StateManager sm, Object value, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.valueMapping != null && this.valueMapping instanceof EmbeddedValuePCMapping) {
            String fieldName = this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedValuePCMapping)this.valueMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            String stmt = this.getUpdateEmbeddedValueStmt(fieldMapping);
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        fieldMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, fieldMapping), newValue);
                        jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateEmbeddedValueFieldsInStatement(sm, value, ps, jdbcPosition, (JoinTable)this.mapTable);
                        sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                        modified = true;
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new NucleusDataStoreException(LOCALISER.msg("056011", (Object)stmt), (Throwable)e);
            }
        }
        return modified;
    }

    protected String getUpdateEmbeddedKeyStmt(JavaTypeMapping fieldMapping) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)this.keyMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getUpdateEmbeddedValueStmt(JavaTypeMapping fieldMapping) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)this.valueMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        MappedStoreManager storeMgr = (MappedStoreManager)sm.getObjectManager().getStoreManager();
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            return new PersistentIDROF(this.valueTable, null, this.vmd, null, null, null, ignoreCache, false, stmt.hasMetaDataExpression(), null, clr.classForName(this.valueType));
        }
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            if (this.valueTable.getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(this.elmIdentifier, this.valueTable.getDataStoreObjectIdMapping(), true);
            }
            if (this.valueTable.getVersionMapping(true) != null) {
                versionIndex = stmt.select(this.elmIdentifier, this.valueTable.getVersionMapping(true), true);
            }
        } else {
            if (this.valueTable.getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(stmt.getMainTableAlias(), this.valueTable.getDataStoreObjectIdMapping(), true);
            }
            if (this.valueTable.getVersionMapping(true) != null) {
                versionIndex = stmt.select(stmt.getMainTableAlias(), this.valueTable.getVersionMapping(true), true);
            }
        }
        StatementExpressionIndex[] statementExpressionIndex = null;
        int[] prefetchFieldNumbers = null;
        if (useFetchPlan) {
            FetchPlan fp = sm.getObjectManager().getFetchPlan();
            fp.manageFetchPlanForClass(this.vmd);
            FetchPlan.FetchPlanForClass fpc = fp.getFetchPlanForClass(this.vmd);
            int[] fieldNumbers = fpc.getFieldsInActualFetchPlan();
            int[] fn = new int[fieldNumbers.length];
            int prefetchFieldCount = 0;
            int fieldCount = this.vmd.getNoOfInheritedManagedMembers() + this.vmd.getNoOfManagedMembers();
            statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                JavaTypeMapping m = this.valueTable.getFieldMapping(this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]));
                if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                statementExpressionIndex[fieldNumbers[i]] = new StatementExpressionIndex();
                statementExpressionIndex[fieldNumbers[i]].setMapping(m);
                fn[prefetchFieldCount++] = fieldNumbers[i];
            }
            prefetchFieldNumbers = new int[prefetchFieldCount];
            System.arraycopy(fn, 0, prefetchFieldNumbers, 0, prefetchFieldCount);
        } else {
            AbstractClassMetaData cmd = this.vmd;
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPKMemberPositions().length];
                int fieldCount = cmd.getNoOfInheritedManagedMembers() + cmd.getNoOfManagedMembers();
                statementExpressionIndex = new StatementExpressionIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPKMemberPositions()[i];
                    JavaTypeMapping m = this.valueTable.getFieldMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                    statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
                    statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
                }
            }
        }
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
        } else {
            Mappings.selectMapping(stmt, statementExpressionIndex);
        }
        return new PersistentIDROF(storeMgr.getDatastoreClass(this.getValueType(), clr), prefetchFieldNumbers, this.vmd, statementExpressionIndex, datastoreIndex, versionIndex, ignoreCache, this.iterateUsingDiscriminator, stmt.hasMetaDataExpression(), null, clr.classForName(this.valueType));
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInMapExpr));
        stmt.select(mapTableAlias, this.valueMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.dba.getMapping(String.class, this.storeMgr);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    public ScalarExpression[] joinKeysToGet(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier mapTableAlias, Class filteredKeyType, DatastoreIdentifier keyTableAlias, DatastoreIdentifier valueTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        Class value_class = clr.classForName(this.valueType);
        return this.joinKeysValuesTo(stmt, parentStmt, ownerMapping, te, mapTableAlias, filteredKeyType, value_class, null, null, keyTableAlias, valueTableAlias);
    }
}

