/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SimpleDatastoreRepresentation;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public class VersionMapping
extends SingleFieldMapping
implements SimpleDatastoreRepresentation {
    private final JavaTypeMapping delegate;

    public VersionMapping(DatastoreAdapter dba, DatastoreContainerObject datastoreContainer, JavaTypeMapping delegate) {
        ColumnMetaData colmd;
        this.initialize(dba, delegate.getType());
        this.delegate = delegate;
        VersionMetaData vermd = datastoreContainer.getVersionMetaData();
        ColumnMetaData[] versionColumnMetaData = vermd.getColumnMetaData();
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier id = null;
        if (versionColumnMetaData.length == 0) {
            id = idFactory.newVersionFieldIdentifier();
            colmd = new ColumnMetaData((MetaData)vermd, id.getIdentifier());
            datastoreContainer.getVersionMetaData().addColumn(colmd);
        } else {
            colmd = versionColumnMetaData[0];
            id = idFactory.newDatastoreFieldIdentifier(colmd.getName());
        }
        DatastoreField column = datastoreContainer.addDatastoreField(this.getType(), id, this, (MetaData)colmd);
        datastoreContainer.getStoreManager().getMappingManager().createDatastoreMapping(delegate, datastoreContainer.getStoreManager(), column, this.getType());
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return this.delegate.getSampleValue(clr);
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return this.delegate.newLiteral(qs, value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return this.delegate.newScalarExpression(qs, te);
    }

    public boolean includeInFetchStatement() {
        return false;
    }

    public int getNumberOfDatastoreFields() {
        return this.delegate.getNumberOfDatastoreFields();
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        return this.delegate.getDataStoreMapping(index);
    }

    public void addDataStoreMapping(DatastoreMapping datastoreMapping) {
        this.delegate.addDataStoreMapping(datastoreMapping);
    }

    public Class getJavaType() {
        return VersionMapping.class;
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        this.delegate.setObject(om, preparedStatement, exprIndex, value);
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        return this.delegate.getObject(om, resultSet, exprIndex);
    }
}

