/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.sql.Timestamp;
import java.util.Date;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SqlTemporalExpression;
import org.datanucleus.store.mapped.expression.SqlTimestampLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SimpleDatastoreRepresentation;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public class SqlTimestampMapping
extends SingleFieldMapping
implements SimpleDatastoreRepresentation {
    private static Timestamp mappingSampleValue = new Timestamp(new Date().getTime());

    public Object getSampleValue(ClassLoaderResolver clr) {
        return mappingSampleValue;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return new SqlTimestampLiteral(qs, (JavaTypeMapping)this, (Timestamp)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return new SqlTemporalExpression(qs, this, te);
    }

    public Class getJavaType() {
        return Timestamp.class;
    }

    public int getDefaultLength(int index) {
        if (this.datastoreMappings != null && this.datastoreMappings.length > 0 && this.datastoreMappings[0].isStringBased()) {
            return 29;
        }
        return super.getDefaultLength(index);
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.datastoreMappings != null && this.datastoreMappings.length > 0 && this.datastoreMappings[0].isStringBased()) {
            return ClassNameConstants.JAVA_LANG_STRING;
        }
        return super.getJavaTypeForDatastoreMapping(index);
    }
}

