/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;

public class MappedStoreData
extends StoreData {
    public MappedStoreData(String name, String tableName, boolean tableOwner, int type, String interfaceName) {
        super(name, null, type, interfaceName);
        this.addProperty("table", tableName);
        this.addProperty("table-owner", tableOwner ? "true" : "false");
    }

    public MappedStoreData(ClassMetaData cmd, DatastoreContainerObject table, boolean tableOwner) {
        super(cmd.getFullClassName(), (MetaData)cmd, 1, null);
        this.addProperty("table", table != null ? table.toString() : null);
        this.addProperty("table-owner", tableOwner ? "true" : "false");
        if (table != null) {
            this.addProperty("tableObject", table);
            this.addProperty("tableId", table.getIdentifier());
        }
        String interfaces = null;
        for (int i = 0; i < cmd.getImplementsMetaData().length; ++i) {
            interfaces = interfaces == null ? "" : interfaces + ",";
            interfaces = interfaces + cmd.getImplementsMetaData()[i].getName();
        }
        this.addProperty("interface-name", interfaces);
    }

    public MappedStoreData(AbstractMemberMetaData fmd, DatastoreContainerObject table) {
        super(fmd.getFullFieldName(), (MetaData)fmd, 2, null);
        String interfaceName;
        this.addProperty("table", table != null ? table.toString() : null);
        this.addProperty("table-owner", "true");
        if (table != null) {
            this.addProperty("tableObject", table);
            this.addProperty("tableId", table.getIdentifier());
        }
        String string = interfaceName = table.getStoreManager().getMetaDataManager().isPersistentInterface(fmd.getType().getName()) ? fmd.getType().getName() : null;
        if (interfaceName != null) {
            this.addProperty("interface-name", interfaceName);
        }
    }

    public String getTableName() {
        return (String)this.properties.get("table");
    }

    public boolean isTableOwner() {
        return ((String)this.properties.get("table-owner")).equals("true");
    }

    public boolean hasTable() {
        return this.properties.get("table") != null;
    }

    public DatastoreContainerObject getDatastoreContainerObject() {
        return (DatastoreContainerObject)this.properties.get("tableObject");
    }

    public DatastoreIdentifier getDatastoreIdentifier() {
        return (DatastoreIdentifier)this.properties.get("tableId");
    }

    public void setDatastoreContainerObject(DatastoreClass table) {
        if (table != null) {
            this.addProperty("table", ((Object)table).toString());
            this.addProperty("tableObject", table);
            this.addProperty("tableId", table.getIdentifier());
        }
    }

    public String toString() {
        String tableName = (String)this.properties.get("table");
        MetaData metadata = this.getMetaData();
        if (metadata instanceof ClassMetaData) {
            ClassMetaData cmd = (ClassMetaData)metadata;
            return LOCALISER.msg("035004", (Object)this.name, (Object)(tableName != null ? tableName : "(none)"), (Object)cmd.getInheritanceMetaData().getStrategyValue().toString());
        }
        if (metadata instanceof AbstractMemberMetaData) {
            return LOCALISER.msg("035005", (Object)this.name, (Object)tableName);
        }
        return LOCALISER.msg("035004", (Object)this.name, (Object)tableName);
    }
}

