/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.sqlidentifier.SQLIdentifier;
import org.datanucleus.store.rdbms.table.SequenceTable;
import org.datanucleus.store.rdbms.valuegenerator.AbstractRDBMSGenerator;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.NucleusLogger;

public final class TableGenerator
extends AbstractRDBMSGenerator {
    private SequenceTable sequenceTable = null;
    private final String sequenceName;
    private static final String DEFAULT_TABLE_NAME = "SEQUENCE_TABLE";

    public TableGenerator(String name, Properties props) {
        super(name, props);
        ((AbstractGenerator)this).allocationSize = 5;
        if (((AbstractGenerator)this).properties != null) {
            if (((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size") != null) {
                try {
                    ((AbstractGenerator)this).allocationSize = Integer.parseInt((String)((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size"));
                }
                catch (Exception e) {
                    throw new ValueGenerationException(AbstractGenerator.LOCALISER.msg("Sequence040006", ((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size")));
                }
            }
            if (((Hashtable)((AbstractGenerator)this).properties).get("key-initial-size") != null) {
                try {
                    ((AbstractGenerator)this).initialValue = new Integer(((AbstractGenerator)this).properties.getProperty("key-initial-value"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.sequenceName = ((AbstractGenerator)this).properties.getProperty("sequence-name") != null ? ((AbstractGenerator)this).properties.getProperty("sequence-name") : (((AbstractGenerator)this).properties.getProperty("sequence-table-basis") != null && ((AbstractGenerator)this).properties.getProperty("sequence-table-basis").equalsIgnoreCase("table") ? ((AbstractGenerator)this).properties.getProperty("table-name") : ((AbstractGenerator)this).properties.getProperty("root-class-name"));
    }

    public ValueGenerationBlock reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        ArrayList<Long> oid = new ArrayList<Long>();
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            SQLIdentifier sourceTableIdentifier = null;
            if (((AbstractGenerator)this).properties.getProperty("table-name") != null) {
                sourceTableIdentifier = (SQLIdentifier)((MappedStoreManager)this.storeMgr).getIdentifierFactory().newDatastoreContainerIdentifier(((AbstractGenerator)this).properties.getProperty("table-name"));
            }
            Long nextId = this.sequenceTable.getNextVal(this.sequenceName, this.connection, (int)size, sourceTableIdentifier, ((AbstractGenerator)this).properties.getProperty("column-name"), ((AbstractGenerator)this).initialValue);
            int i = 0;
            while ((long)i < size) {
                oid.add(nextId);
                nextId = new Long(nextId + 1L);
                ++i;
            }
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug((Object)AbstractGenerator.LOCALISER.msg("040004", (Object)("" + size)));
            }
            return new ValueGenerationBlock(oid);
        }
        catch (SQLException e) {
            throw new ValueGenerationException(AbstractRDBMSGenerator.LOCALISER_RDBMS.msg("061001", (Object)e.getMessage()));
        }
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected boolean repositoryExists() {
        return super.repositoryExists();
    }

    protected boolean createRepository() {
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            this.sequenceTable.exists((Connection)this.connection.getConnection(), true);
            return true;
        }
        catch (SQLException sqle) {
            throw new ValueGenerationException("Exception thrown calling table.exists() for " + this.sequenceTable, (Throwable)sqle);
        }
    }

    protected void initialiseSequenceTable() {
        DatastoreClass table;
        String schemaName;
        String catalogName = ((AbstractGenerator)this).properties.getProperty("sequence-catalog-name");
        if (catalogName == null) {
            catalogName = ((AbstractGenerator)this).properties.getProperty("catalog-name");
        }
        if ((schemaName = ((AbstractGenerator)this).properties.getProperty("sequence-schema-name")) == null) {
            schemaName = ((AbstractGenerator)this).properties.getProperty("schema-name");
        }
        String tableName = ((AbstractGenerator)this).properties.getProperty("sequence-table-name") == null ? DEFAULT_TABLE_NAME : ((AbstractGenerator)this).properties.getProperty("sequence-table-name");
        MappedStoreManager storeMgr = (MappedStoreManager)this.storeMgr;
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        SQLIdentifier identifier = (SQLIdentifier)storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(tableName);
        if (dba.supportsOption("CatalogInTableDefinition") && catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        if (dba.supportsOption("SchemaInTableDefinition") && schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if ((table = storeMgr.getDatastoreClass(identifier)) != null) {
            this.sequenceTable = (SequenceTable)((Object)table);
        } else {
            String sequenceNameColumnName = "SEQUENCE_NAME";
            String nextValColumnName = "NEXT_VAL";
            if (((AbstractGenerator)this).properties.getProperty("sequence-name-column-name") != null) {
                sequenceNameColumnName = ((AbstractGenerator)this).properties.getProperty("sequence-name-column-name");
            }
            if (((AbstractGenerator)this).properties.getProperty("sequence-nextval-column-name") != null) {
                nextValColumnName = ((AbstractGenerator)this).properties.getProperty("sequence-nextval-column-name");
            }
            this.sequenceTable = new SequenceTable(identifier, (RDBMSManager)storeMgr, sequenceNameColumnName, nextValColumnName);
            this.sequenceTable.initialize(storeMgr.getOMFContext().getClassLoaderResolver(null));
            storeMgr.addDatastoreContainer(this.sequenceTable);
        }
    }
}

