/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.exceptions.MissingColumnException;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.datanucleus.store.rdbms.exceptions.NotAViewException;
import org.datanucleus.store.rdbms.exceptions.PrimaryKeyColumnNotAllowedException;
import org.datanucleus.store.rdbms.exceptions.UnexpectedColumnException;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaHandler;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.NucleusLogger;

public abstract class ViewImpl
extends AbstractTable {
    public ViewImpl(DatastoreIdentifier name, RDBMSManager storeMgr) {
        super(name, storeMgr);
    }

    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
    }

    public void postInitialize(ClassLoaderResolver clr) {
        this.assertIsInitialized();
    }

    public boolean validate(Connection conn, boolean validateColumnStructure, boolean autoCreate, Collection autoCreateErrors) throws SQLException {
        this.assertIsInitialized();
        RDBMSSchemaHandler handler = (RDBMSSchemaHandler)this.storeMgr.getSchemaHandler();
        String tableType = handler.getTableType(conn, this);
        if (tableType == null) {
            throw new MissingTableException(this.getCatalogName(), this.getSchemaName(), this.toString());
        }
        if (!tableType.equals("VIEW")) {
            throw new NotAViewException(this.toString(), tableType);
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)AbstractTable.LOCALISER.msg("031004", (Object)this));
        }
        HashMap unvalidated = new HashMap(this.columnsByName);
        Iterator i = this.storeMgr.getColumnInfoForTable(this, conn).iterator();
        while (i.hasNext()) {
            RDBMSColumnInfo ci = (RDBMSColumnInfo)i.next();
            DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newIdentifier(1, ci.getColumnName());
            Column col = (Column)unvalidated.get(colName);
            if (col == null) {
                if (this.hasColumnName(colName)) continue;
                throw new UnexpectedColumnException(this.toString(), colName.getIdentifier(), this.getSchemaName(), this.getCatalogName());
            }
            if (validateColumnStructure) {
                col.validate(ci);
                unvalidated.remove(colName);
                continue;
            }
            unvalidated.remove(colName);
        }
        if (unvalidated.size() > 0) {
            throw new MissingColumnException(this, unvalidated.values());
        }
        this.state = 4;
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)AbstractTable.LOCALISER.msg("045000", System.currentTimeMillis() - startTime));
        }
        return false;
    }

    protected List getSQLDropStatements() {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add(this.dba.getDropViewStatement(this));
        return stmts;
    }

    protected synchronized void addColumnInternal(Column col) {
        if (col.isPrimaryKey()) {
            throw new PrimaryKeyColumnNotAllowedException(this.toString(), ((Object)col.getIdentifier()).toString());
        }
        super.addColumnInternal(col);
    }
}

