/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.ClassDefinitionException;
import org.datanucleus.store.exceptions.NoSuchPersistentFieldException;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.IndexMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.VersionMapping;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.exceptions.DuplicateColumnNameException;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.datanucleus.store.rdbms.sqlidentifier.SQLIdentifier;
import org.datanucleus.store.rdbms.table.AbstractClassTable;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.ColumnCreator;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.store.rdbms.table.TableUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.MacroString;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;

public class ClassTable
extends AbstractClassTable
implements DatastoreClass {
    private final ClassMetaData cmd;
    private final Collection managedClassMetaData = new HashSet();
    private ClassTable supertable;
    private Map secondaryTables;
    private HashMap externalFkMappings;
    private HashMap externalFkDiscriminatorMappings;
    private HashMap externalOrderMappings;
    private MacroString tableDef;
    private String createStatementDDL;
    private static MultiMap callbacks = new MultiMap();
    HashMap candidateKeysByMapField = new HashMap();
    HashSet unmappedColumns = null;
    protected transient String managingClassCurrent = null;
    protected boolean runCallbacksAfterManageClass = false;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Integer;

    public ClassTable(DatastoreIdentifier tableName, RDBMSManager storeMgr, ClassMetaData cmd) {
        super(tableName, storeMgr);
        this.cmd = cmd;
        if (cmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.NEW_TABLE && cmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.COMPLETE_TABLE) {
            throw new NucleusUserException(AbstractTable.LOCALISER.msg("057003", (Object)cmd.getFullClassName(), (Object)cmd.getInheritanceMetaData().getStrategyValue().toString())).setFatal();
        }
        this.highestFieldNumber = cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers();
        String tableImpStr = cmd.getValueForExtension("ddl-imports");
        String tableDefStr = null;
        if (this.dba.getVendorID() != null) {
            tableDefStr = cmd.getValueForExtension("ddl-definition-" + this.dba.getVendorID());
        }
        if (tableDefStr == null) {
            tableDefStr = cmd.getValueForExtension("ddl-definition");
        }
        if (tableDefStr != null) {
            this.tableDef = new MacroString(cmd.getFullClassName(), tableImpStr, tableDefStr);
        }
    }

    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsPKUninitialized();
        if (this.cmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.COMPLETE_TABLE) {
            this.supertable = this.getSupertable((AbstractClassMetaData)this.cmd, clr);
            if (this.supertable != null && !this.supertable.isInitialized() && !this.supertable.isPKInitialized()) {
                this.supertable.preInitialize(clr);
            }
        }
        if (!this.isPKInitialized()) {
            this.initializePK(clr);
        }
    }

    public void initialize(ClassLoaderResolver clr) {
        DiscriminatorMetaData dismd;
        this.assertIsUninitialized();
        this.initializeForClass((AbstractClassMetaData)this.cmd, clr);
        this.versionMetaData = this.cmd.getVersionMetaDataForTable();
        if (this.versionMetaData != null && this.versionMetaData.getFieldName() == null) {
            if (this.versionMetaData.getVersionStrategy() == VersionStrategy.NONE) {
                this.versionMapping = new VersionMapping(this.dba, this, this.dba.getMapping(class$java$lang$Long == null ? (class$java$lang$Long = ClassTable.class$("java.lang.Long")) : class$java$lang$Long, this.storeMgr));
            } else if (this.versionMetaData.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                this.versionMapping = new VersionMapping(this.dba, this, this.dba.getMapping(class$java$lang$Long == null ? (class$java$lang$Long = ClassTable.class$("java.lang.Long")) : class$java$lang$Long, this.storeMgr));
            } else if (this.versionMetaData.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                if (!this.dba.supportsOption("DateTimeStoresMillisecs")) {
                    throw new NucleusException("Class " + this.cmd.getFullClassName() + " is defined " + "to use date-time versioning, yet this datastore doesnt support storing " + "milliseconds in DATETIME/TIMESTAMP columns. Use version-number");
                }
                this.versionMapping = new VersionMapping(this.dba, this, this.dba.getMapping(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ClassTable.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, this.storeMgr));
            }
        }
        if ((dismd = this.cmd.getDiscriminatorMetaDataForTable()) != null) {
            this.discriminatorMetaData = dismd;
            if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.discriminatorPerSubclassTable")) {
                if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                    this.discriminatorMapping = new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr));
                } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                    ColumnMetaData disColmd = dismd.getColumnMetaData();
                    this.discriminatorMapping = disColmd != null && disColmd.getJdbcType() != null ? (disColmd.getJdbcType().equalsIgnoreCase("INTEGER") || disColmd.getJdbcType().equalsIgnoreCase("BIGINT") || disColmd.getJdbcType().equalsIgnoreCase("NUMERIC") ? new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$Long == null ? (class$java$lang$Long = ClassTable.class$("java.lang.Long")) : class$java$lang$Long, this.storeMgr)) : new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr))) : new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr));
                }
            } else {
                ClassTable tableWithDiscrim = this.getTableWithDiscriminator();
                if (tableWithDiscrim == this) {
                    if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                        this.discriminatorMapping = new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr));
                    } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                        ColumnMetaData disColmd = dismd.getColumnMetaData();
                        this.discriminatorMapping = disColmd != null && disColmd.getJdbcType() != null ? (disColmd.getJdbcType().equalsIgnoreCase("INTEGER") || disColmd.getJdbcType().equalsIgnoreCase("BIGINT") || disColmd.getJdbcType().equalsIgnoreCase("NUMERIC") ? new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$Long == null ? (class$java$lang$Long = ClassTable.class$("java.lang.Long")) : class$java$lang$Long, this.storeMgr)) : new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr))) : new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr));
                    }
                }
            }
        }
        if (this.secondaryTables != null) {
            Set secondaryTableNames = this.secondaryTables.keySet();
            Iterator secondaryTableNamesIter = secondaryTableNames.iterator();
            while (secondaryTableNamesIter.hasNext()) {
                String secondaryTableName = (String)secondaryTableNamesIter.next();
                SecondaryTable second = (SecondaryTable)this.secondaryTables.get(secondaryTableName);
                if (second.isInitialized()) continue;
                second.initialize(clr);
            }
        }
        this.state = 2;
    }

    public void postInitialize(final ClassLoaderResolver clr) {
        this.assertIsInitialized();
        this.runCallBacks(clr);
        if (this.tableDef != null) {
            this.createStatementDDL = this.tableDef.substituteMacros(new MacroString.MacroHandler(){

                public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                    ClassTable.this.storeMgr.resolveIdentifierMacro(im, clr);
                }

                public void onParameterMacro(MacroString.ParameterMacro pm) {
                    throw new NucleusUserException(AbstractTable.LOCALISER.msg("057033", (Object)ClassTable.this.cmd.getFullClassName(), (Object)pm));
                }
            }, clr);
        }
    }

    public void manageClass(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)AbstractTable.LOCALISER.msg("057024", (Object)this.toString(), (Object)theCmd.getFullClassName(), (Object)theCmd.getInheritanceMetaData().getStrategyValue().toString()));
        }
        this.managingClassCurrent = theCmd.getFullClassName();
        this.managedClassMetaData.add(theCmd);
        this.manageFields(theCmd, clr, theCmd.getManagedMembers());
        this.manageFields(theCmd, clr, theCmd.getOverriddenMembers());
        this.manageUnmappedColumns(theCmd, clr);
        this.managingClassCurrent = null;
        if (this.runCallbacksAfterManageClass) {
            this.runCallBacks(clr);
            this.runCallbacksAfterManageClass = false;
        }
    }

    public String[] getManagedClasses() {
        String[] classNames = new String[this.managedClassMetaData.size()];
        Iterator iter = this.managedClassMetaData.iterator();
        int i = 0;
        while (iter.hasNext()) {
            classNames[i++] = ((ClassMetaData)iter.next()).getFullClassName();
        }
        return classNames;
    }

    private void manageFields(AbstractClassMetaData theCmd, ClassLoaderResolver clr, AbstractMemberMetaData[] fields) {
        for (int fieldNumber = 0; fieldNumber < fields.length; ++fieldNumber) {
            DatastoreClass dc;
            AbstractMemberMetaData fmd = fields[fieldNumber];
            if (fmd.isPrimaryKey()) continue;
            if (this.managesField(fmd.getFullFieldName())) {
                if (fmd.getClassName(true).equals(theCmd.getFullClassName())) continue;
                JavaTypeMapping fieldMapping = this.getMappingForFieldName(fmd.getFullFieldName());
                ColumnMetaData[] colmds = fmd.getColumnMetaData();
                if (colmds == null || colmds.length <= 0) continue;
                int colnum = 0;
                IdentifierFactory idFactory = this.getStoreManager().getIdentifierFactory();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    Column col = (Column)fieldMapping.getDataStoreMapping(i).getDatastoreField();
                    col.setIdentifier(idFactory.newDatastoreFieldIdentifier(colmds[colnum].getName()));
                    col.setMetaData((MetaData)colmds[colnum]);
                    if (++colnum == colmds.length) break;
                }
                if (!NucleusLogger.DATASTORE.isDebugEnabled()) continue;
                StringBuffer columnsStr = new StringBuffer();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    if (i > 0) {
                        columnsStr.append(",");
                    }
                    columnsStr.append(fieldMapping.getDataStoreMapping(i).getDatastoreField());
                }
                if (fieldMapping.getNumberOfDatastoreFields() == 0) {
                    columnsStr.append("[none]");
                }
                StringBuffer datastoreMappingTypes = new StringBuffer();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    if (i > 0) {
                        datastoreMappingTypes.append(',');
                    }
                    datastoreMappingTypes.append(fieldMapping.getDataStoreMapping(i).getClass().getName());
                }
                NucleusLogger.DATASTORE.debug((Object)AbstractTable.LOCALISER.msg("057010", (Object)fmd.getFullFieldName(), (Object)columnsStr.toString(), (Object)fieldMapping.getClass().getName(), (Object)datastoreMappingTypes.toString()));
                continue;
            }
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                boolean isPrimary = true;
                if (fmd.getTable() != null && fmd.getJoinMetaData() == null) {
                    isPrimary = false;
                }
                if (isPrimary) {
                    this.addFieldMapping(this.dba.getMappingManager().getMapping(this, fmd, this.dba, clr, 0));
                } else {
                    SecondaryTable secTable;
                    if (this.secondaryTables == null) {
                        this.secondaryTables = new HashMap();
                    }
                    if ((secTable = (SecondaryTable)this.secondaryTables.get(fmd.getTable())) == null) {
                        String schemaName;
                        JoinMetaData[] joinmds = theCmd.getJoinMetaData();
                        JoinMetaData joinmd = null;
                        if (joinmds != null) {
                            for (int j = 0; j < joinmds.length; ++j) {
                                if (!joinmds[j].getTable().equalsIgnoreCase(fmd.getTable()) || joinmds[j].getCatalog() != null && (joinmds[j].getCatalog() == null || !joinmds[j].getCatalog().equalsIgnoreCase(fmd.getCatalog())) || joinmds[j].getSchema() != null && (joinmds[j].getSchema() == null || !joinmds[j].getSchema().equalsIgnoreCase(fmd.getSchema()))) continue;
                                joinmd = joinmds[j];
                                break;
                            }
                        }
                        SQLIdentifier secTableIdentifier = (SQLIdentifier)this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(fmd.getTable());
                        String catalogName = fmd.getCatalog();
                        if (catalogName == null) {
                            catalogName = this.getCatalogName();
                        }
                        if ((schemaName = fmd.getSchema()) == null) {
                            schemaName = this.getSchemaName();
                        }
                        secTableIdentifier.setCatalogName(catalogName);
                        secTableIdentifier.setSchemaName(schemaName);
                        secTable = new SecondaryTable(secTableIdentifier, this.storeMgr, this, joinmd, clr);
                        secTable.preInitialize(clr);
                        secTable.initialize(clr);
                        secTable.postInitialize(clr);
                        this.secondaryTables.put(fmd.getTable(), secTable);
                    }
                    secTable.addFieldMapping(this.dba.getMappingManager().getMapping(secTable, fmd, this.dba, clr, 0));
                }
            } else if (fmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                throw new NucleusException(AbstractTable.LOCALISER.msg("057006", (Object)fmd.getName())).setFatal();
            }
            boolean needsFKToContainerOwner = false;
            int relationType = fmd.getRelationType(clr);
            if (relationType == 4) {
                AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
                if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                    needsFKToContainerOwner = true;
                }
            } else if (relationType == 3 && fmd.getJoinMetaData() == null) {
                needsFKToContainerOwner = true;
            }
            if (!needsFKToContainerOwner) continue;
            if (fmd.getCollection() != null && !SCOUtils.collectionHasSerialisedElements((AbstractMemberMetaData)fmd) || fmd.getArray() != null && !SCOUtils.arrayIsStoredInSingleColumn((AbstractMemberMetaData)fmd)) {
                AbstractClassMetaData elementCmd = null;
                elementCmd = fmd.hasCollection() ? this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getCollection().getElementType(), clr) : this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getType().getComponentType(), clr);
                if (elementCmd == null) {
                    if (fmd.hasCollection()) {
                        NucleusLogger.METADATA.warn((Object)AbstractTable.LOCALISER.msg("057016", (Object)theCmd.getFullClassName(), (Object)fmd.getCollection().getElementType()));
                        continue;
                    }
                    NucleusLogger.METADATA.warn((Object)AbstractTable.LOCALISER.msg("057014", (Object)theCmd.getFullClassName(), (Object)fmd.getType().getComponentType().getName()));
                    continue;
                }
                Object[] elementCmds = null;
                elementCmds = elementCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(elementCmd, clr) : new ClassMetaData[]{elementCmd};
                for (int i = 0; i < elementCmds.length; ++i) {
                    callbacks.put((Object)elementCmds[i].getFullClassName(), (Object)new CallBack(fmd));
                    dc = this.storeMgr.getDatastoreClass(elementCmds[i].getFullClassName(), clr);
                    ClassTable ct = (ClassTable)dc;
                    if (!ct.isInitialized()) continue;
                    ct.runCallBacks(clr);
                }
                continue;
            }
            if (fmd.getMap() == null || SCOUtils.mapHasSerialisedKeysAndValues((AbstractMemberMetaData)fmd)) continue;
            if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
                AbstractClassMetaData valueCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getMap().getValueType(), clr);
                if (valueCmd == null) {
                    NucleusLogger.METADATA.warn((Object)AbstractTable.LOCALISER.msg("057018", (Object)theCmd.getFullClassName(), (Object)fmd.getMap().getValueType()));
                    continue;
                }
                Object[] valueCmds = null;
                valueCmds = valueCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(valueCmd, clr) : new ClassMetaData[]{valueCmd};
                for (int i = 0; i < valueCmds.length; ++i) {
                    callbacks.put((Object)valueCmds[i].getFullClassName(), (Object)new CallBack(fmd));
                    dc = this.storeMgr.getDatastoreClass(valueCmds[i].getFullClassName(), clr);
                    ClassTable ct = (ClassTable)dc;
                    if (!ct.isInitialized()) continue;
                    ct.runCallBacks(clr);
                }
                continue;
            }
            if (fmd.getValueMetaData() == null || fmd.getValueMetaData().getMappedBy() == null) continue;
            AbstractClassMetaData keyCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getMap().getKeyType(), clr);
            if (keyCmd == null) {
                NucleusLogger.METADATA.warn((Object)AbstractTable.LOCALISER.msg("057019", (Object)theCmd.getFullClassName(), (Object)fmd.getMap().getKeyType()));
                continue;
            }
            Object[] keyCmds = null;
            keyCmds = keyCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(keyCmd, clr) : new ClassMetaData[]{keyCmd};
            for (int i = 0; i < keyCmds.length; ++i) {
                callbacks.put((Object)keyCmds[i].getFullClassName(), (Object)new CallBack(fmd));
                dc = this.storeMgr.getDatastoreClass(keyCmds[i].getFullClassName(), clr);
                ClassTable ct = (ClassTable)dc;
                if (!ct.isInitialized()) continue;
                ct.runCallBacks(clr);
            }
        }
    }

    private void manageUnmappedColumns(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        List cols = theCmd.getUnmappedColumns();
        if (cols != null && cols.size() > 0) {
            Iterator colsIter = cols.iterator();
            while (colsIter.hasNext()) {
                ColumnMetaData colmd = (ColumnMetaData)colsIter.next();
                if (colmd.getJdbcType().equals("VARCHAR") && colmd.getLength() == null) {
                    colmd.setLength(this.getStoreManager().getOMFContext().getPersistenceConfiguration().getIntProperty("datanucleus.rdbms.stringDefaultLength"));
                }
                IdentifierFactory idFactory = this.getStoreManager().getIdentifierFactory();
                DatastoreIdentifier colIdentifier = idFactory.newIdentifier(1, colmd.getName());
                Column col = (Column)this.addDatastoreField(null, colIdentifier, null, (MetaData)colmd);
                SQLTypeInfo sqlTypeInfo = this.storeMgr.getSQLTypeInfoForJDBCType(JDBCUtils.getJDBCTypeForName(colmd.getJdbcType()));
                col.setTypeInfo(sqlTypeInfo);
                if (this.unmappedColumns == null) {
                    this.unmappedColumns = new HashSet();
                }
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE.debug((Object)AbstractTable.LOCALISER.msg("057011", (Object)col.toString(), (Object)colmd.getJdbcType()));
                }
                this.unmappedColumns.add(col);
            }
        }
    }

    public boolean managesClass(String className) {
        if (className == null) {
            return false;
        }
        Iterator iter = this.managedClassMetaData.iterator();
        while (iter.hasNext()) {
            ClassMetaData managedCmd = (ClassMetaData)iter.next();
            if (!managedCmd.getFullClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    protected void initializePK(ClassLoaderResolver clr) {
        this.assertIsPKUninitialized();
        AbstractMemberMetaData[] fieldsToAdd = new AbstractMemberMetaData[this.cmd.getNoOfPrimaryKeyMembers()];
        int pkFieldNum = 0;
        int fieldCount = this.cmd.getNoOfManagedMembers();
        boolean hasPrimaryKeyInThisClass = false;
        if (this.cmd.getNoOfPrimaryKeyMembers() > 0) {
            this.pkMappings = new JavaTypeMapping[this.cmd.getNoOfPrimaryKeyMembers()];
            if (this.cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
                AbstractClassMetaData baseCmd = this.cmd.getBaseAbstractClassMetaData();
                fieldCount = baseCmd.getNoOfManagedMembers();
                for (int relFieldNum = 0; relFieldNum < fieldCount; ++relFieldNum) {
                    AbstractMemberMetaData mmd = baseCmd.getMetaDataForManagedMemberAtPosition(relFieldNum);
                    if (!mmd.isPrimaryKey()) continue;
                    if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                        fieldsToAdd[pkFieldNum++] = mmd;
                        hasPrimaryKeyInThisClass = true;
                    } else if (mmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                        throw new NucleusException(AbstractTable.LOCALISER.msg("057006", (Object)mmd.getName())).setFatal();
                    }
                    if (mmd.getValueStrategy() != IdentityStrategy.IDENTITY || this.dba.supportsOption("IdentityColumns")) continue;
                    throw new NucleusException(AbstractTable.LOCALISER.msg("057020", (Object)this.cmd.getFullClassName(), (Object)mmd.getName())).setFatal();
                }
            } else {
                for (int relFieldNum = 0; relFieldNum < fieldCount; ++relFieldNum) {
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtPosition(relFieldNum);
                    if (!fmd.isPrimaryKey()) continue;
                    if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                        fieldsToAdd[pkFieldNum++] = fmd;
                        hasPrimaryKeyInThisClass = true;
                    } else if (fmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                        throw new NucleusException(AbstractTable.LOCALISER.msg("057006", (Object)fmd.getName())).setFatal();
                    }
                    if (fmd.getValueStrategy() != IdentityStrategy.IDENTITY || this.dba.supportsOption("IdentityColumns")) continue;
                    throw new NucleusException(AbstractTable.LOCALISER.msg("057020", (Object)this.cmd.getFullClassName(), (Object)fmd.getName())).setFatal();
                }
            }
        }
        if (!hasPrimaryKeyInThisClass) {
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
                DatastoreClass elementCT = this.storeMgr.getDatastoreClass(this.cmd.getPersistenceCapableSuperclass(), clr);
                if (elementCT != null) {
                    JoinMetaData colContainer = null;
                    if (this.cmd.getInheritanceMetaData() != null) {
                        colContainer = this.cmd.getInheritanceMetaData().getJoinMetaData();
                    }
                    if (colContainer == null) {
                        colContainer = this.cmd.getPrimaryKeyMetaData();
                    }
                    this.addApplicationIdUsingClassTableId((ColumnMetaDataContainer)colContainer, elementCT, clr, (AbstractClassMetaData)this.cmd);
                } else {
                    AbstractClassMetaData pkCmd = this.storeMgr.getClassWithPrimaryKeyForClass(this.cmd.getSuperAbstractClassMetaData(), clr);
                    if (pkCmd != null) {
                        this.pkMappings = new JavaTypeMapping[pkCmd.getNoOfPrimaryKeyMembers()];
                        pkFieldNum = 0;
                        fieldCount = pkCmd.getNoOfInheritedManagedMembers() + pkCmd.getNoOfManagedMembers();
                        for (int absFieldNum = 0; absFieldNum < fieldCount; ++absFieldNum) {
                            AbstractMemberMetaData fmd = pkCmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNum);
                            if (!fmd.isPrimaryKey()) continue;
                            AbstractMemberMetaData overriddenFmd = this.cmd.getOverriddenMember(fmd.getName());
                            if (overriddenFmd != null) {
                                fmd = overriddenFmd;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                                fieldsToAdd[pkFieldNum++] = fmd;
                                continue;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                            throw new NucleusException(AbstractTable.LOCALISER.msg("057006", (Object)fmd.getName())).setFatal();
                        }
                    }
                }
            } else if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                PrimaryKeyMetaData colContainer = null;
                if (this.cmd.getIdentityMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData().length > 0) {
                    colContainer = this.cmd.getIdentityMetaData();
                }
                if (colContainer == null) {
                    colContainer = this.cmd.getPrimaryKeyMetaData();
                }
                this.addDatastoreId((ColumnMetaDataContainer)colContainer, null, (AbstractClassMetaData)this.cmd);
            } else if (this.cmd.getIdentityType() == IdentityType.NONDURABLE) {
                // empty if block
            }
        }
        for (int i = 0; i < fieldsToAdd.length; ++i) {
            if (fieldsToAdd[i] == null) continue;
            try {
                DatastoreClass datastoreClass = this.getStoreManager().getDatastoreClass(fieldsToAdd[i].getType().getName(), clr);
                if (datastoreClass.getIDMapping() == null) {
                    throw new NucleusException("Unsupported relationship with field " + fieldsToAdd[i].getFullFieldName()).setFatal();
                }
            }
            catch (NoTableManagedException ex) {
                // empty catch block
            }
            JavaTypeMapping fieldMapping = this.dba.getMappingManager().getMapping(this, fieldsToAdd[i], this.dba, clr, 0);
            this.addFieldMapping(fieldMapping);
            this.pkMappings[i] = fieldMapping;
        }
        this.initializeIDMapping();
        this.state = 1;
    }

    private void initializeForClass(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        AbstractClassMetaData parentCmd = theCmd.getSuperAbstractClassMetaData();
        this.manageClass(theCmd, clr);
        if (parentCmd != null) {
            if (this.cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
                this.initializeForClass(parentCmd, clr);
            } else if (parentCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                this.initializeForClass(parentCmd, clr);
            }
        }
    }

    private void runCallBacks(ClassLoaderResolver clr) {
        Iterator cmdIter = this.managedClassMetaData.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData managedCmd = (ClassMetaData)cmdIter.next();
            if (this.managingClassCurrent != null && this.managingClassCurrent.equals(managedCmd.getFullClassName())) {
                this.runCallbacksAfterManageClass = true;
                break;
            }
            Collection c = (Collection)callbacks.remove(managedCmd.getFullClassName());
            this.runSpecifiedCallbacks(managedCmd, c, clr);
        }
    }

    private void runSpecifiedCallbacks(ClassMetaData classCmd, Collection callbacks, ClassLoaderResolver clr) {
        if (callbacks != null) {
            Iterator it = callbacks.iterator();
            while (it.hasNext()) {
                Map.Entry entry;
                JavaTypeMapping orderMapping;
                JavaTypeMapping fkDiscrimMapping;
                CallBack callback = (CallBack)it.next();
                if (callback.fmd.getJoinMetaData() != null) continue;
                AbstractMemberMetaData ownerFmd = callback.fmd;
                if (ownerFmd.getMappedBy() != null) {
                    AbstractMemberMetaData fmd = classCmd.getMetaDataForMember(ownerFmd.getMappedBy());
                    if (fmd == null) {
                        throw new NucleusUserException(AbstractTable.LOCALISER.msg("057036", (Object)ownerFmd.getMappedBy(), (Object)classCmd.getFullClassName(), (Object)ownerFmd.getFullFieldName()));
                    }
                    if (ownerFmd.getMap() != null && this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.uniqueConstraints.mapInverse")) {
                        this.initializeFKMapUniqueConstraints(ownerFmd);
                    }
                    boolean duplicate = false;
                    fkDiscrimMapping = null;
                    orderMapping = null;
                    if (ownerFmd.hasExtension("relation-discriminator-column")) {
                        String colName = ownerFmd.getValueForExtension("relation-discriminator-column");
                        if (colName == null) {
                            colName = "RELATION_DISCRIM";
                        }
                        Set fkDiscrimEntries = this.getExternalFkDiscriminatorMappings().entrySet();
                        Iterator discrimMappingIter = fkDiscrimEntries.iterator();
                        while (discrimMappingIter.hasNext()) {
                            entry = discrimMappingIter.next();
                            JavaTypeMapping discrimMapping = (JavaTypeMapping)entry.getValue();
                            String discrimColName = ((ColumnMetaData)discrimMapping.getDataStoreMapping(0).getDatastoreField().getMetaData()).getName();
                            if (!discrimColName.equalsIgnoreCase(colName)) continue;
                            duplicate = true;
                            fkDiscrimMapping = discrimMapping;
                            orderMapping = (JavaTypeMapping)this.getExternalOrderMappings().get(entry.getKey());
                            break;
                        }
                        if (!duplicate) {
                            ColumnMetaData colmd = new ColumnMetaData(null, colName);
                            colmd.setAllowsNull(Boolean.TRUE);
                            fkDiscrimMapping = this.dba.getMapping(class$java$lang$String == null ? ClassTable.class$("java.lang.String") : class$java$lang$String, this.storeMgr);
                            ColumnCreator.createIndexColumn(fkDiscrimMapping, this.storeMgr, clr, this, colmd, false);
                        }
                        if (fkDiscrimMapping != null) {
                            this.getExternalFkDiscriminatorMappings().put(ownerFmd, fkDiscrimMapping);
                        }
                    }
                    this.addOrderMapping(ownerFmd, orderMapping, clr);
                    continue;
                }
                String ownerClassName = ownerFmd.getAbstractClassMetaData().getFullClassName();
                JavaTypeMapping fkMapping = new PersistenceCapableMapping();
                fkMapping.initialize(this.dba, ownerClassName);
                fkDiscrimMapping = null;
                orderMapping = null;
                boolean duplicate = false;
                try {
                    JavaTypeMapping ownerIdMapping = this.storeMgr.getDatastoreClass(ownerClassName, clr).getIDMapping();
                    ElementMetaData colmdContainer = null;
                    if (ownerFmd.hasCollection() || ownerFmd.hasArray()) {
                        colmdContainer = ownerFmd.getElementMetaData();
                    } else if (ownerFmd.hasMap() && ownerFmd.getKeyMetaData() != null && ownerFmd.getKeyMetaData().getMappedBy() != null) {
                        colmdContainer = ownerFmd.getValueMetaData();
                    } else if (ownerFmd.hasMap() && ownerFmd.getValueMetaData() != null && ownerFmd.getValueMetaData().getMappedBy() != null) {
                        colmdContainer = ownerFmd.getKeyMetaData();
                    }
                    CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper((ColumnMetaDataContainer)colmdContainer, ownerIdMapping, true);
                    int countIdFields = ownerIdMapping.getNumberOfDatastoreFields();
                    for (int i = 0; i < countIdFields; ++i) {
                        DatastoreMapping refDatastoreMapping = ownerIdMapping.getDataStoreMapping(i);
                        JavaTypeMapping mapping = this.dba.getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType(), this.storeMgr);
                        ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(((Column)refDatastoreMapping.getDatastoreField()).getIdentifier());
                        if (colmd == null) {
                            throw new NucleusUserException(AbstractTable.LOCALISER.msg("057035", (Object)((Column)refDatastoreMapping.getDatastoreField()).getIdentifier(), (Object)this.toString())).setFatal();
                        }
                        DatastoreIdentifier identifier = null;
                        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
                        identifier = colmd.getName() == null || colmd.getName().length() < 1 ? ((RDBMSIdentifierFactory)idFactory).newForeignKeyFieldIdentifier(ownerFmd, null, refDatastoreMapping.getDatastoreField().getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(mapping.getJavaType()), 1) : idFactory.newDatastoreFieldIdentifier(colmd.getName());
                        DatastoreField refColumn = this.addDatastoreField(mapping.getJavaType().getName(), identifier, mapping, (MetaData)colmd);
                        ((Column)refDatastoreMapping.getDatastoreField()).copyConfigurationTo(refColumn);
                        if (colmd == null || colmd != null && !colmd.isAllowsNullSet() || colmd != null && colmd.isAllowsNullSet() && colmd.isAllowsNull()) {
                            refColumn.setNullable();
                        }
                        fkMapping.addDataStoreMapping(this.getStoreManager().getMappingManager().createDatastoreMapping(mapping, this.storeMgr, refColumn, refDatastoreMapping.getJavaTypeMapping().getJavaType().getName()));
                        ((PersistenceCapableMapping)fkMapping).addJavaTypeMapping(mapping);
                    }
                }
                catch (DuplicateColumnNameException dcne) {
                    if (!ownerFmd.hasExtension("relation-discriminator-column")) {
                        throw dcne;
                    }
                    Iterator fkIter = this.getExternalFkMappings().entrySet().iterator();
                    fkMapping = null;
                    block5: while (fkIter.hasNext()) {
                        entry = fkIter.next();
                        JavaTypeMapping existingFkMapping = (JavaTypeMapping)entry.getValue();
                        for (int j = 0; j < existingFkMapping.getNumberOfDatastoreFields(); ++j) {
                            if (!((Object)existingFkMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString().equals(((Object)dcne.getConflictingColumn().getIdentifier()).toString())) continue;
                            fkMapping = existingFkMapping;
                            fkDiscrimMapping = (JavaTypeMapping)this.externalFkDiscriminatorMappings.get(entry.getKey());
                            orderMapping = (JavaTypeMapping)this.getExternalOrderMappings().get(entry.getKey());
                            continue block5;
                        }
                    }
                    if (fkMapping == null) {
                        throw dcne;
                    }
                    duplicate = true;
                }
                if (!duplicate && ownerFmd.hasExtension("relation-discriminator-column")) {
                    String colName = ownerFmd.getValueForExtension("relation-discriminator-column");
                    if (colName == null) {
                        colName = "RELATION_DISCRIM";
                    }
                    ColumnMetaData colmd = new ColumnMetaData(null, colName);
                    colmd.setAllowsNull(Boolean.TRUE);
                    fkDiscrimMapping = this.dba.getMapping(class$java$lang$String == null ? ClassTable.class$("java.lang.String") : class$java$lang$String, this.storeMgr);
                    ColumnCreator.createIndexColumn(fkDiscrimMapping, this.storeMgr, clr, this, colmd, false);
                }
                this.getExternalFkMappings().put(ownerFmd, fkMapping);
                if (fkDiscrimMapping != null) {
                    this.getExternalFkDiscriminatorMappings().put(ownerFmd, fkDiscrimMapping);
                }
                this.addOrderMapping(ownerFmd, orderMapping, clr);
            }
        }
    }

    private JavaTypeMapping addOrderMapping(AbstractMemberMetaData fmd, JavaTypeMapping orderMapping, ClassLoaderResolver clr) {
        boolean needsOrderMapping = false;
        OrderMetaData omd = fmd.getOrderMetaData();
        if (fmd.hasArray()) {
            needsOrderMapping = true;
        } else if ((class$java$util$List == null ? (class$java$util$List = ClassTable.class$("java.util.List")) : class$java$util$List).isAssignableFrom(fmd.getType())) {
            needsOrderMapping = true;
            if (omd != null && !omd.isIndexedList()) {
                needsOrderMapping = false;
            }
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = ClassTable.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(fmd.getType()) && omd != null && omd.isIndexedList() && omd.getMappedBy() == null) {
            needsOrderMapping = true;
        }
        if (needsOrderMapping) {
            this.state = 0;
            if (orderMapping == null) {
                orderMapping = this.addOrderColumn(fmd, clr);
            }
            this.getExternalOrderMappings().put(fmd, orderMapping);
            this.state = 2;
        }
        return orderMapping;
    }

    public String getType() {
        return this.cmd.getFullClassName();
    }

    public IdentityType getIdentityType() {
        return this.cmd.getIdentityType();
    }

    public final VersionMetaData getVersionMetaData() {
        return this.versionMetaData;
    }

    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        return this.discriminatorMetaData;
    }

    public final ClassTable getTableWithDiscriminator() {
        ClassTable tbl;
        if (this.supertable != null && (tbl = this.supertable.getTableWithDiscriminator()) != null) {
            return tbl;
        }
        if (this.discriminatorMetaData != null) {
            return this;
        }
        if (this.cmd.getInheritanceMetaData() != null && this.cmd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
            return this;
        }
        return null;
    }

    public boolean isObjectIDDatastoreAttributed() {
        boolean attributed = this.storeMgr.isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getValueStrategy(), this.cmd.getIdentityType() == IdentityType.DATASTORE);
        if (attributed) {
            return true;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = (Column)this.columns.get(i);
            if (!col.isPrimaryKey() || !col.isAutoIncrement()) continue;
            return true;
        }
        return false;
    }

    public boolean isBaseDatastoreClass() {
        return this.supertable == null;
    }

    public DatastoreClass getSuperDatastoreClass() {
        this.assertIsInitialized();
        return this.supertable;
    }

    public Collection getSecondaryDatastoreClasses() {
        return this.secondaryTables != null ? this.secondaryTables.values() : null;
    }

    public JavaTypeMapping getVersionMapping(boolean allowSuperclasses) {
        if (this.versionMapping != null) {
            return this.versionMapping;
        }
        if (allowSuperclasses && this.supertable != null) {
            return this.supertable.getVersionMapping(allowSuperclasses);
        }
        return null;
    }

    public JavaTypeMapping getDiscriminatorMapping(boolean allowSuperclasses) {
        if (this.discriminatorMapping != null) {
            return this.discriminatorMapping;
        }
        if (allowSuperclasses && this.supertable != null) {
            return this.supertable.getDiscriminatorMapping(allowSuperclasses);
        }
        return null;
    }

    private ClassTable getSupertable(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        if (this.cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
            return null;
        }
        AbstractClassMetaData superCmd = theCmd.getSuperAbstractClassMetaData();
        if (superCmd != null) {
            if (superCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
                return (ClassTable)this.storeMgr.getDatastoreClass(superCmd.getFullClassName(), clr);
            }
            if (superCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                return this.getSupertable(superCmd, clr);
            }
            return this.getSupertable(superCmd, clr);
        }
        return null;
    }

    public DatastoreClass getBaseDatastoreClassWithField(AbstractMemberMetaData fmd) {
        if (fmd.isPrimaryKey() && this.getSuperDatastoreClass() != null) {
            return this.getSuperDatastoreClass().getBaseDatastoreClassWithField(fmd);
        }
        if (this.fieldMappingsMap.get(fmd) != null) {
            return this;
        }
        if (this.getSuperDatastoreClass() == null) {
            return this;
        }
        return this.getSuperDatastoreClass().getBaseDatastoreClassWithField(fmd);
    }

    ClassMetaData getClassMetaData() {
        return this.cmd;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        DiscriminatorMetaData dismd;
        IndexMetaData idxmd;
        IndexMetaData idxmd2;
        Index index;
        int i;
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        HashSet<Index> indices = new HashSet<Index>();
        Set fieldNumbersSet = this.fieldMappingsMap.keySet();
        Iterator iter = fieldNumbersSet.iterator();
        while (iter.hasNext()) {
            Index index2;
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
            if (fieldMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)fieldMapping;
                for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                    JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                    IndexMetaData imd = embFieldMapping.getFieldMetaData().getIndexMetaData();
                    if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                    indices.add(index);
                }
                continue;
            }
            IndexMetaData imd = fmd.getIndexMetaData();
            if (imd == null || (index2 = TableUtils.getIndexForField(this, imd, fieldMapping)) == null) continue;
            indices.add(index2);
        }
        if (this.versionMapping != null && (idxmd2 = this.getVersionMetaData().getIndexMetaData()) != null) {
            Index index3 = new Index(this, idxmd2.isUnique() != null ? idxmd2.isUnique() : false, idxmd2.getValueForExtension("extended-setting"));
            if (idxmd2.getName() != null) {
                index3.setName(idxmd2.getName());
            }
            int countVersionFields = this.versionMapping.getNumberOfDatastoreFields();
            for (i = 0; i < countVersionFields; ++i) {
                index3.addDatastoreField(this.versionMapping.getDataStoreMapping(i).getDatastoreField());
            }
            indices.add(index3);
        }
        if (this.discriminatorMapping != null && (idxmd = (dismd = this.getDiscriminatorMetaData()).getIndexMetaData()) != null) {
            Index index4 = new Index(this, idxmd.isUnique() != null ? idxmd.isUnique() : false, idxmd.getValueForExtension("extended-setting"));
            if (idxmd.getName() != null) {
                index4.setName(idxmd.getName());
            }
            int countDiscrimFields = this.discriminatorMapping.getNumberOfDatastoreFields();
            for (int i2 = 0; i2 < countDiscrimFields; ++i2) {
                index4.addDatastoreField(this.discriminatorMapping.getDataStoreMapping(i2).getDatastoreField());
            }
            indices.add(index4);
        }
        Set orderMappingsEntries = this.getExternalOrderMappings().entrySet();
        Iterator orderMappingsEntriesIter = orderMappingsEntries.iterator();
        while (orderMappingsEntriesIter.hasNext()) {
            Map.Entry entry = orderMappingsEntriesIter.next();
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)entry.getKey();
            JavaTypeMapping mapping = (JavaTypeMapping)entry.getValue();
            OrderMetaData omd = fmd.getOrderMetaData();
            if (omd == null || omd.getIndexMetaData() == null || (index = this.getIndexForIndexMetaDataAndMapping(omd.getIndexMetaData(), mapping)) == null) continue;
            indices.add(index);
        }
        Iterator cmdIter = this.managedClassMetaData.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData thisCmd = (ClassMetaData)cmdIter.next();
            IndexMetaData[] classIndices = thisCmd.getIndexMetaData();
            if (classIndices == null) continue;
            for (int i3 = 0; i3 < classIndices.length; ++i3) {
                index = this.getIndexForIndexMetaData(classIndices[i3]);
                if (index == null) continue;
                indices.add(index);
            }
        }
        if (autoMode) {
            indices.addAll(super.getExpectedIndices(clr));
        }
        return indices;
    }

    private Index getIndexForIndexMetaDataAndMapping(IndexMetaData imd, JavaTypeMapping mapping) {
        boolean unique = false;
        if (imd.isUnique() != null && imd.isUnique().booleanValue()) {
            unique = true;
        }
        Index index = new Index(this, unique, imd.getValueForExtension("extended-setting"));
        if (imd.getName() != null) {
            index.setName(imd.getName());
        }
        int numCols = mapping.getNumberOfDatastoreFields();
        for (int i = 0; i < numCols; ++i) {
            index.addDatastoreField(mapping.getDataStoreMapping(i).getDatastoreField());
        }
        return index;
    }

    private Index getIndexForIndexMetaData(IndexMetaData imd) {
        boolean unique = false;
        if (imd.isUnique() != null && imd.isUnique().booleanValue()) {
            unique = true;
        }
        Index index = new Index(this, unique, imd.getValueForExtension("extended-setting"));
        if (imd.getName() != null) {
            index.setName(imd.getName());
        }
        ColumnMetaData[] colmds = imd.getColumnMetaData();
        AbstractMemberMetaData[] fmds = imd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (int i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column col = (Column)this.columnsByName.get(colName);
                if (col == null) {
                    NucleusLogger.DATASTORE.warn((Object)AbstractTable.LOCALISER.msg("058001", (Object)this.toString(), (Object)index.getName(), (Object)colmds[i].getName()));
                    break;
                }
                index.addDatastoreField(col);
            }
        } else if (fmds != null && fmds.length > 0) {
            for (int i = 0; i < fmds.length; ++i) {
                AbstractMemberMetaData realFmd = this.getFieldMetaData(fmds[i].getName());
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(realFmd);
                int countFields = fieldMapping.getNumberOfDatastoreFields();
                for (int j = 0; j < countFields; ++j) {
                    index.addDatastoreField(fieldMapping.getDataStoreMapping(j).getDatastoreField());
                }
            }
        } else {
            NucleusLogger.DATASTORE.warn((Object)AbstractTable.LOCALISER.msg("058002", (Object)this.toString(), (Object)index.getName()));
            return null;
        }
        return index;
    }

    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        ForeignKeyMetaData idFkmd;
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        Set fieldNumbersSet = this.fieldMappingsMap.keySet();
        Iterator iter = fieldNumbersSet.iterator();
        while (iter.hasNext()) {
            ForeignKey fk;
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
            if (fmd.getEmbeddedMetaData() != null && fieldMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)fieldMapping;
                this.addExpectedForeignKeysForEmbeddedPCField(foreignKeys, autoMode, clr, embMapping);
                continue;
            }
            if (ClassUtils.isReferenceType((Class)fmd.getType()) && fieldMapping instanceof ReferenceMapping) {
                Collection fks = TableUtils.getForeignKeysForReferenceField(fieldMapping, fmd, autoMode, this.storeMgr, clr);
                foreignKeys.addAll(fks);
                continue;
            }
            if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getType(), clr) == null || fieldMapping.getNumberOfDatastoreFields() <= 0 || !(fieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(fieldMapping, fmd, autoMode, this.storeMgr, clr)) == null) continue;
            foreignKeys.add(fk);
        }
        ForeignKeyMetaData foreignKeyMetaData = idFkmd = this.cmd.getInheritanceMetaData().getJoinMetaData() != null ? this.cmd.getInheritanceMetaData().getJoinMetaData().getForeignKeyMetaData() : null;
        if (this.supertable != null && (autoMode || idFkmd != null && idFkmd.getDeleteAction() != ForeignKeyAction.NONE)) {
            ForeignKey fk = new ForeignKey(this.getIDMapping(), this.dba, this.supertable, false);
            if (idFkmd != null && idFkmd.getName() != null) {
                fk.setName(idFkmd.getName());
            }
            foreignKeys.add(0, fk);
        }
        Iterator cmdIter = this.managedClassMetaData.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData thisCmd = (ClassMetaData)cmdIter.next();
            ForeignKeyMetaData[] fkmds = thisCmd.getForeignKeyMetaData();
            if (fkmds == null) continue;
            for (int i = 0; i < fkmds.length; ++i) {
                ForeignKey fk = this.getForeignKeyForForeignKeyMetaData(fkmds[i]);
                if (fk == null) continue;
                foreignKeys.add(fk);
            }
        }
        HashMap externalFks = this.getExternalFkMappings();
        if (!externalFks.isEmpty()) {
            Set externalFkKeys = externalFks.keySet();
            Iterator externalFkKeysIter = externalFkKeys.iterator();
            while (externalFkKeysIter.hasNext()) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)externalFkKeysIter.next();
                DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(fmd.getAbstractClassMetaData().getFullClassName(), clr);
                if (referencedTable == null) continue;
                ForeignKeyMetaData fkmd = fmd.getForeignKeyMetaData();
                if (fkmd == null && fmd.getElementMetaData() != null) {
                    fkmd = fmd.getElementMetaData().getForeignKeyMetaData();
                }
                if ((fkmd == null || fkmd.getDeleteAction() == ForeignKeyAction.NONE) && !autoMode) continue;
                JavaTypeMapping fkMapping = (JavaTypeMapping)externalFks.get(fmd);
                ForeignKey fk = new ForeignKey(fkMapping, this.dba, referencedTable, true);
                fk.setForMetaData(fkmd);
                if (foreignKeys.contains(fk)) continue;
                foreignKeys.add(fk);
            }
        }
        return foreignKeys;
    }

    private void addExpectedForeignKeysForEmbeddedPCField(List foreignKeys, boolean autoMode, ClassLoaderResolver clr, EmbeddedPCMapping embeddedMapping) {
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            ForeignKey fk;
            JavaTypeMapping embFieldMapping = embeddedMapping.getJavaTypeMapping(i);
            if (embFieldMapping instanceof EmbeddedPCMapping) {
                this.addExpectedForeignKeysForEmbeddedPCField(foreignKeys, autoMode, clr, (EmbeddedPCMapping)embFieldMapping);
                continue;
            }
            AbstractMemberMetaData embFmd = embFieldMapping.getFieldMetaData();
            if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                Collection fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                foreignKeys.addAll(fks);
                continue;
            }
            if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreFields() <= 0 || !(embFieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
            foreignKeys.add(fk);
        }
    }

    private ForeignKey getForeignKeyForForeignKeyMetaData(ForeignKeyMetaData fkmd) {
        int j;
        int i;
        if (fkmd == null) {
            return null;
        }
        ForeignKey fk = new ForeignKey(fkmd.isDeferred());
        fk.setForMetaData(fkmd);
        ClassMetaData acmd = this.cmd;
        if (fkmd.getTable() == null) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)AbstractTable.LOCALISER.msg("058105", (Object)acmd.getFullClassName()));
            return null;
        }
        DatastoreIdentifier tableId = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(fkmd.getTable());
        ClassTable refTable = (ClassTable)this.storeMgr.getDatastoreClass(tableId);
        if (refTable == null) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)AbstractTable.LOCALISER.msg("058106", (Object)acmd.getFullClassName(), (Object)fkmd.getTable()));
            return null;
        }
        PrimaryKey pk = refTable.getPrimaryKey();
        List targetCols = pk.getColumns();
        ArrayList<DatastoreField> sourceCols = new ArrayList<DatastoreField>();
        ColumnMetaData[] colmds = fkmd.getColumnMetaData();
        AbstractMemberMetaData[] fmds = fkmd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colId = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column sourceCol = (Column)this.columnsByName.get(colId);
                if (sourceCol == null) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)AbstractTable.LOCALISER.msg("058107", (Object)acmd.getFullClassName(), (Object)fkmd.getTable(), (Object)colmds[i].getName(), (Object)this.toString()));
                    return null;
                }
                sourceCols.add(sourceCol);
            }
        } else if (fmds != null && fmds.length > 0) {
            for (i = 0; i < fmds.length; ++i) {
                AbstractMemberMetaData realFmd = this.getFieldMetaData(fmds[i].getName());
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(realFmd);
                int countDatastoreFields = fieldMapping.getNumberOfDatastoreFields();
                for (j = 0; j < countDatastoreFields; ++j) {
                    sourceCols.add(fieldMapping.getDataStoreMapping(i).getDatastoreField());
                }
            }
        }
        if (sourceCols.size() != targetCols.size()) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)AbstractTable.LOCALISER.msg("058108", (Object)acmd.getFullClassName(), (Object)fkmd.getTable(), (Object)("" + sourceCols.size()), (Object)("" + targetCols.size())));
        }
        if (sourceCols.size() > 0) {
            for (i = 0; i < sourceCols.size(); ++i) {
                Column source = (Column)sourceCols.get(i);
                String targetColName = colmds[i].getTarget();
                Column target = (Column)targetCols.get(i);
                if (targetColName != null) {
                    for (j = 0; j < targetCols.size(); ++j) {
                        Column targetCol = (Column)targetCols.get(j);
                        if (!targetCol.getIdentifier().getIdentifier().equalsIgnoreCase(targetColName)) continue;
                        target = targetCol;
                        break;
                    }
                }
                fk.addDatastoreField(source, target);
            }
        }
        return fk;
    }

    protected List getExpectedCandidateKeys() {
        int i;
        this.assertIsInitialized();
        List candidateKeys = super.getExpectedCandidateKeys();
        Set fieldNumbersSet = this.fieldMappingsMap.keySet();
        Iterator iter = fieldNumbersSet.iterator();
        while (iter.hasNext()) {
            CandidateKey ck;
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
            if (fieldMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)fieldMapping;
                for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                    CandidateKey ck2;
                    JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                    UniqueMetaData umd = embFieldMapping.getFieldMetaData().getUniqueMetaData();
                    if (umd == null || (ck2 = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                    candidateKeys.add(ck2);
                }
                continue;
            }
            UniqueMetaData umd = fmd.getUniqueMetaData();
            if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, fieldMapping)) == null) continue;
            candidateKeys.add(ck);
        }
        Iterator cmdIter = this.managedClassMetaData.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData thisCmd = (ClassMetaData)cmdIter.next();
            UniqueMetaData[] classCKs = thisCmd.getUniqueMetaData();
            if (classCKs == null) continue;
            for (i = 0; i < classCKs.length; ++i) {
                CandidateKey ck = this.getCandidateKeyForUniqueMetaData(classCKs[i]);
                if (ck == null) continue;
                candidateKeys.add(ck);
            }
        }
        return candidateKeys;
    }

    private CandidateKey getCandidateKeyForUniqueMetaData(UniqueMetaData umd) {
        CandidateKey ck = new CandidateKey(this);
        if (umd.getName() != null) {
            ck.setName(umd.getName());
        }
        ColumnMetaData[] colmds = umd.getColumnMetaData();
        AbstractMemberMetaData[] fmds = umd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (int i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column col = (Column)this.columnsByName.get(colName);
                if (col == null) {
                    NucleusLogger.DATASTORE.warn((Object)AbstractTable.LOCALISER.msg("058202", (Object)this.toString(), (Object)ck.getName(), (Object)colmds[i].getName()));
                    break;
                }
                ck.addDatastoreField(col);
            }
        } else if (fmds != null && fmds.length > 0) {
            for (int i = 0; i < fmds.length; ++i) {
                AbstractMemberMetaData realFmd = this.getFieldMetaData(fmds[i].getName());
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(realFmd);
                int countFields = fieldMapping.getNumberOfDatastoreFields();
                for (int j = 0; j < countFields; ++j) {
                    ck.addDatastoreField(fieldMapping.getDataStoreMapping(j).getDatastoreField());
                }
            }
        } else {
            NucleusLogger.DATASTORE.warn((Object)AbstractTable.LOCALISER.msg("058203", (Object)this.toString(), (Object)ck.getName()));
            return null;
        }
        return ck;
    }

    public PrimaryKey getPrimaryKey() {
        PrimaryKey pk = super.getPrimaryKey();
        PrimaryKeyMetaData pkmd = this.cmd.getPrimaryKeyMetaData();
        if (pkmd != null && pkmd.getName() != null) {
            pk.setName(pkmd.getName());
        }
        return pk;
    }

    protected List getSQLCreateStatements(Properties props) {
        List<String> stmts;
        Properties tableProps = null;
        if (this.createStatementDDL != null) {
            stmts = new ArrayList();
            StringTokenizer tokens = new StringTokenizer(this.createStatementDDL, ";");
            while (tokens.hasMoreTokens()) {
                stmts.add(tokens.nextToken());
            }
        } else {
            if (this.cmd.getExtensions() != null) {
                tableProps = new Properties();
                ExtensionMetaData[] emds = this.cmd.getExtensions();
                for (int i = 0; i < emds.length; ++i) {
                    if (!emds[i].getVendorName().equalsIgnoreCase("datanucleus")) continue;
                    ((Hashtable)tableProps).put(emds[i].getKey(), emds[i].getValue());
                }
            }
            stmts = super.getSQLCreateStatements(tableProps);
        }
        if (this.secondaryTables != null) {
            Set secondaryTableNames = this.secondaryTables.keySet();
            Iterator iter = secondaryTableNames.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)this.secondaryTables.get(iter.next());
                stmts.addAll(secTable.getSQLCreateStatements(tableProps));
            }
        }
        stmts.addAll(this.getSQLAddUniqueConstraintsStatements());
        return stmts;
    }

    protected List getSQLDropStatements() {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        if (this.secondaryTables != null) {
            Set secondaryTableNames = this.secondaryTables.keySet();
            Iterator iter = secondaryTableNames.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)this.secondaryTables.get(iter.next());
                stmts.addAll(secTable.getSQLDropStatements());
            }
        }
        stmts.add(this.dba.getDropTableStatement(this));
        return stmts;
    }

    private List getSQLAddUniqueConstraintsStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        Iterator cks = this.candidateKeysByMapField.values().iterator();
        int ckNum = 0;
        RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
        while (cks.hasNext()) {
            DatastoreIdentifier ckName = idFactory.newCandidateKeyIdentifier(this, ++ckNum);
            CandidateKey ck = (CandidateKey)cks.next();
            ck.setName(ckName.getIdentifier());
            stmts.add(this.dba.getAddCandidateKeyStatement(ck, idFactory));
        }
        return stmts;
    }

    private void initializeFKMapUniqueConstraints(AbstractMemberMetaData ownerfmd) {
        AbstractMemberMetaData mfmd = null;
        String map_field_name = ownerfmd.getMappedBy();
        if (map_field_name != null) {
            mfmd = this.cmd.getMetaDataForMember(map_field_name);
            if (mfmd == null) {
                ClassMetaData managedCmd;
                Iterator cmdIter = this.managedClassMetaData.iterator();
                while (cmdIter.hasNext() && (mfmd = (managedCmd = (ClassMetaData)cmdIter.next()).getMetaDataForMember(map_field_name)) == null) {
                }
            }
            if (mfmd == null) {
                throw new NucleusUserException(AbstractTable.LOCALISER.msg("057036", (Object)map_field_name, (Object)this.cmd.getFullClassName(), (Object)ownerfmd.getFullFieldName()));
            }
            if (mfmd != null && ownerfmd.getJoinMetaData() == null) {
                if (ownerfmd.getKeyMetaData() != null && ownerfmd.getKeyMetaData().getMappedBy() != null) {
                    AbstractMemberMetaData kmd = null;
                    String key_field_name = ownerfmd.getKeyMetaData().getMappedBy();
                    if (key_field_name != null) {
                        kmd = this.cmd.getMetaDataForMember(key_field_name);
                    }
                    if (kmd == null) {
                        ClassMetaData managedCmd;
                        Iterator cmdIter = this.managedClassMetaData.iterator();
                        while (cmdIter.hasNext() && (kmd = (managedCmd = (ClassMetaData)cmdIter.next()).getMetaDataForMember(key_field_name)) == null) {
                        }
                    }
                    if (kmd == null) {
                        throw new ClassDefinitionException(AbstractTable.LOCALISER.msg("057007", (Object)mfmd.getFullFieldName(), (Object)key_field_name));
                    }
                    JavaTypeMapping ownerMapping = this.getFieldMapping(map_field_name);
                    JavaTypeMapping keyMapping = this.getFieldMapping(kmd.getName());
                    if ((this.dba.supportsOption("NullsInCandidateKeys") || !ownerMapping.isNullable() && !keyMapping.isNullable()) && keyMapping.getDatastoreContainer() == this && ownerMapping.getDatastoreContainer() == this) {
                        CandidateKey ck = new CandidateKey(this);
                        HashSet<Column> addedColumns = new HashSet<Column>();
                        int countOwnerFields = ownerMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countOwnerFields; ++i) {
                            Column col = (Column)ownerMapping.getDataStoreMapping(i).getDatastoreField();
                            addedColumns.add(col);
                            ck.addDatastoreField(col);
                        }
                        int countKeyFields = keyMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countKeyFields; ++i) {
                            Column col = (Column)keyMapping.getDataStoreMapping(i).getDatastoreField();
                            if (!addedColumns.contains(col)) {
                                addedColumns.add(col);
                                ck.addDatastoreField(col);
                                continue;
                            }
                            NucleusLogger.DATASTORE.warn((Object)AbstractTable.LOCALISER.msg("057041", (Object)ownerfmd.getName()));
                        }
                        if (this.candidateKeysByMapField.put(mfmd, ck) != null) {
                            NucleusLogger.DATASTORE.warn((Object)AbstractTable.LOCALISER.msg("057012", (Object)mfmd.getFullFieldName(), (Object)ownerfmd.getFullFieldName()));
                        }
                    }
                } else if (ownerfmd.getValueMetaData() != null && ownerfmd.getValueMetaData().getMappedBy() != null) {
                    AbstractMemberMetaData vmd = null;
                    String value_field_name = ownerfmd.getValueMetaData().getMappedBy();
                    if (value_field_name != null) {
                        vmd = this.cmd.getMetaDataForMember(value_field_name);
                    }
                    if (vmd == null) {
                        throw new ClassDefinitionException(AbstractTable.LOCALISER.msg("057008", (Object)mfmd));
                    }
                    JavaTypeMapping ownerMapping = this.getFieldMapping(map_field_name);
                    JavaTypeMapping valueMapping = this.getFieldMapping(vmd.getName());
                    if ((this.dba.supportsOption("NullsInCandidateKeys") || !ownerMapping.isNullable() && !valueMapping.isNullable()) && valueMapping.getDatastoreContainer() == this && ownerMapping.getDatastoreContainer() == this) {
                        CandidateKey ck = new CandidateKey(this);
                        HashSet<Column> addedColumns = new HashSet<Column>();
                        int countOwnerFields = ownerMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countOwnerFields; ++i) {
                            Column col = (Column)ownerMapping.getDataStoreMapping(i).getDatastoreField();
                            addedColumns.add(col);
                            ck.addDatastoreField(col);
                        }
                        int countValueFields = valueMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countValueFields; ++i) {
                            Column col = (Column)valueMapping.getDataStoreMapping(i).getDatastoreField();
                            if (!addedColumns.contains(col)) {
                                addedColumns.add(col);
                                ck.addDatastoreField(col);
                                continue;
                            }
                            NucleusLogger.DATASTORE.warn((Object)AbstractTable.LOCALISER.msg("057042", (Object)ownerfmd.getName()));
                        }
                        if (this.candidateKeysByMapField.put(mfmd, ck) != null) {
                            NucleusLogger.DATASTORE.warn((Object)AbstractTable.LOCALISER.msg("057012", (Object)mfmd.getFullFieldName(), (Object)ownerfmd.getFullFieldName()));
                        }
                    }
                } else {
                    throw new ClassDefinitionException(AbstractTable.LOCALISER.msg("057009", (Object)ownerfmd.getFullFieldName()));
                }
            }
        }
    }

    private void initializeIDMapping() {
        if (this.idMapping != null) {
            return;
        }
        PersistenceCapableMapping mapping = new PersistenceCapableMapping();
        mapping.initialize(this.getStoreManager().getDatastoreAdapter(), this.cmd.getFullClassName());
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            mapping.addJavaTypeMapping(this.datastoreIDMapping);
        } else if (this.getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < this.pkMappings.length; ++i) {
                mapping.addJavaTypeMapping(this.pkMappings[i]);
            }
        }
        this.idMapping = mapping;
    }

    public JavaTypeMapping getIDMapping() {
        return this.idMapping;
    }

    private HashMap getExternalOrderMappings() {
        if (this.externalOrderMappings == null) {
            this.externalOrderMappings = new HashMap();
        }
        return this.externalOrderMappings;
    }

    private HashMap getExternalFkMappings() {
        if (this.externalFkMappings == null) {
            this.externalFkMappings = new HashMap();
        }
        return this.externalFkMappings;
    }

    public JavaTypeMapping getExternalMapping(AbstractMemberMetaData fmd, int mappingType) {
        if (mappingType == 5) {
            return (JavaTypeMapping)this.getExternalFkMappings().get(fmd);
        }
        if (mappingType == 6) {
            return (JavaTypeMapping)this.getExternalFkDiscriminatorMappings().get(fmd);
        }
        if (mappingType == 4) {
            return (JavaTypeMapping)this.getExternalOrderMappings().get(fmd);
        }
        return null;
    }

    public AbstractMemberMetaData getMetaDataForExternalMapping(JavaTypeMapping mapping, int mappingType) {
        block4: {
            block5: {
                block3: {
                    if (mappingType != 5) break block3;
                    Set entries = this.getExternalFkMappings().entrySet();
                    Iterator iter = entries.iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        if (entry.getValue() != mapping) continue;
                        return (AbstractMemberMetaData)entry.getKey();
                    }
                    break block4;
                }
                if (mappingType != 6) break block5;
                Set entries = this.getExternalFkDiscriminatorMappings().entrySet();
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (entry.getValue() != mapping) continue;
                    return (AbstractMemberMetaData)entry.getKey();
                }
                break block4;
            }
            if (mappingType != 4) break block4;
            Set entries = this.getExternalOrderMappings().entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (entry.getValue() != mapping) continue;
                return (AbstractMemberMetaData)entry.getKey();
            }
        }
        return null;
    }

    private HashMap getExternalFkDiscriminatorMappings() {
        if (this.externalFkDiscriminatorMappings == null) {
            this.externalFkDiscriminatorMappings = new HashMap();
        }
        return this.externalFkDiscriminatorMappings;
    }

    public JavaTypeMapping getFieldMapping(AbstractMemberMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        if (fmd instanceof PropertyMetaData && fmd.getAbstractClassMetaData() instanceof InterfaceMetaData) {
            return this.getFieldMapping(fmd.getName());
        }
        if (fmd.isPrimaryKey()) {
            this.assertIsPKInitialized();
        } else {
            this.assertIsInitialized();
        }
        JavaTypeMapping m = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
        if (m != null) {
            return m;
        }
        int ifc = this.cmd.getNoOfInheritedManagedMembers();
        if (fmd.getAbsoluteFieldNumber() < ifc && this.supertable != null && (m = this.supertable.getFieldMapping(fmd)) != null) {
            return m;
        }
        if (this.secondaryTables != null) {
            Collection secTables = this.secondaryTables.values();
            Iterator iter = secTables.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)iter.next();
                m = secTable.getFieldMapping(fmd);
                if (m == null) continue;
                return m;
            }
        }
        return null;
    }

    public JavaTypeMapping getFieldMappingInDatastoreClass(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return null;
        }
        if (mmd instanceof PropertyMetaData && mmd.getAbstractClassMetaData() instanceof InterfaceMetaData) {
            return this.getFieldMapping(mmd.getName());
        }
        if (mmd.isPrimaryKey()) {
            this.assertIsPKInitialized();
        } else {
            this.assertIsInitialized();
        }
        JavaTypeMapping m = (JavaTypeMapping)this.fieldMappingsMap.get(mmd);
        if (m != null) {
            return m;
        }
        return null;
    }

    public JavaTypeMapping getFieldMapping(String fieldName) {
        this.assertIsInitialized();
        AbstractMemberMetaData fmd = this.getFieldMetaData(fieldName);
        JavaTypeMapping m = this.getFieldMapping(fmd);
        if (m == null) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), fieldName);
        }
        return m;
    }

    AbstractMemberMetaData getFieldMetaData(String fieldName) {
        AbstractMemberMetaData fmd = this.cmd.getMetaDataForMember(fieldName);
        if (fmd == null) {
            Iterator iter = this.managedClassMetaData.iterator();
            while (iter.hasNext()) {
                AbstractClassMetaData theCmd = (AbstractClassMetaData)iter.next();
                AbstractMemberMetaData foundFmd = theCmd.getMetaDataForMember(fieldName);
                if (foundFmd == null) continue;
                if (!(fmd == null || fmd.toString().equalsIgnoreCase(foundFmd.toString()) && fmd.getType() == foundFmd.getType())) {
                    String errMsg = "Table " + this.getIdentifier() + " manages at least 2 subclasses that both define a field \"" + fieldName + "\", " + "and the fields' metadata is different or they have different type! That means you can get e.g. wrong fetch results.";
                    NucleusLogger.DATASTORE.error((Object)errMsg);
                    throw new NucleusException(errMsg).setFatal();
                }
                fmd = foundFmd;
            }
        }
        return fmd;
    }

    void assertPCClass(StateManager sm) {
        Class<?> c = sm.getObject().getClass();
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.cmd.getFullClassName(), c)) {
            throw new NucleusException(AbstractTable.LOCALISER.msg("057013", (Object)this.cmd.getFullClassName(), c)).setFatal();
        }
    }

    private JavaTypeMapping addOrderColumn(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        Class indexType = class$java$lang$Integer == null ? (class$java$lang$Integer = ClassTable.class$("java.lang.Integer")) : class$java$lang$Integer;
        IndexMapping indexMapping = new IndexMapping();
        indexMapping.initialize(this.dba, indexType.getName());
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier indexColumnName = null;
        ColumnMetaData colmd = null;
        OrderMetaData omd = fmd.getOrderMetaData();
        if (omd != null) {
            ColumnMetaData columnMetaData = colmd = omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 ? omd.getColumnMetaData()[0] : null;
            if (omd.getMappedBy() != null) {
                this.state = 2;
                JavaTypeMapping orderMapping = this.getFieldMapping(omd.getMappedBy());
                if (orderMapping == null) {
                    throw new NucleusUserException(AbstractTable.LOCALISER.msg("057021", (Object)fmd.getFullFieldName(), (Object)omd.getMappedBy()));
                }
                if (!(orderMapping instanceof IntegerMapping) && !(orderMapping instanceof LongMapping)) {
                    throw new NucleusUserException(AbstractTable.LOCALISER.msg("057022", (Object)fmd.getFullFieldName(), (Object)omd.getMappedBy()));
                }
                return orderMapping;
            }
            String colName = null;
            if (omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 && omd.getColumnMetaData()[0].getName() != null) {
                colName = omd.getColumnMetaData()[0].getName();
                indexColumnName = idFactory.newDatastoreFieldIdentifier(colName);
            }
        }
        if (indexColumnName == null) {
            indexColumnName = ((RDBMSIdentifierFactory)idFactory).newForeignKeyFieldIdentifier(fmd, null, null, this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(indexType), 7);
        }
        DatastoreField column = this.addDatastoreField(indexType.getName(), indexColumnName, indexMapping, (MetaData)colmd);
        if (colmd == null || colmd != null && !colmd.isAllowsNullSet() || colmd != null && colmd.isAllowsNullSet() && colmd.isAllowsNull()) {
            column.setNullable();
        }
        this.storeMgr.getMappingManager().createDatastoreMapping(indexMapping, this.storeMgr, column, indexType.getName());
        return indexMapping;
    }

    public void providePrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.pkMappings != null) {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            for (int i = 0; i < this.pkMappings.length; ++i) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.pkMappings[i], fmd);
            }
        } else {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            int countPkFields = this.cmd.getNoOfPrimaryKeyMembers();
            for (int i = 0; i < countPkFields; ++i) {
                AbstractMemberMetaData pkfmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.getFieldMapping(pkfmd), pkfmd);
            }
        }
    }

    public final void provideExternalMappings(MappingConsumer consumer, int mappingType) {
        block4: {
            block5: {
                block3: {
                    if (mappingType != 5 || this.externalFkMappings == null) break block3;
                    consumer.preConsumeMapping(this.highestFieldNumber + 1);
                    Set fieldNumbersSet = this.externalFkMappings.keySet();
                    Iterator iter = fieldNumbersSet.iterator();
                    while (iter.hasNext()) {
                        AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
                        JavaTypeMapping fieldMapping = (JavaTypeMapping)this.externalFkMappings.get(fmd);
                        if (fieldMapping == null) continue;
                        consumer.consumeMapping(fieldMapping, 5);
                    }
                    break block4;
                }
                if (mappingType != 6 || this.externalFkDiscriminatorMappings == null) break block5;
                consumer.preConsumeMapping(this.highestFieldNumber + 1);
                Set fieldNumbersSet = this.externalFkDiscriminatorMappings.keySet();
                Iterator iter = fieldNumbersSet.iterator();
                while (iter.hasNext()) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
                    JavaTypeMapping fieldMapping = (JavaTypeMapping)this.externalFkDiscriminatorMappings.get(fmd);
                    if (fieldMapping == null) continue;
                    consumer.consumeMapping(fieldMapping, 6);
                }
                break block4;
            }
            if (mappingType != 4 || this.externalOrderMappings == null) break block4;
            consumer.preConsumeMapping(this.highestFieldNumber + 1);
            Set fieldNumbersSet = this.externalOrderMappings.keySet();
            Iterator iter = fieldNumbersSet.iterator();
            while (iter.hasNext()) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.externalOrderMappings.get(fmd);
                if (fieldMapping == null) continue;
                consumer.consumeMapping(fieldMapping, 4);
            }
        }
    }

    public void provideMappingsForFields(MappingConsumer consumer, AbstractMemberMetaData[] fieldMetaData, boolean includeSecondaryTables) {
        super.provideMappingsForFields(consumer, fieldMetaData, true);
        if (includeSecondaryTables && this.secondaryTables != null) {
            Collection secTables = this.secondaryTables.values();
            Iterator iter = secTables.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)iter.next();
                secTable.provideMappingsForFields(consumer, fieldMetaData, false);
            }
        }
    }

    public void provideUnmappedDatastoreFields(MappingConsumer consumer) {
        if (this.unmappedColumns != null) {
            Iterator iter = this.unmappedColumns.iterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                consumer.consumeUnmappedDatastoreField(col);
            }
        }
    }

    public boolean validateConstraints(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean modified = false;
        if (super.validateConstraints(conn, autoCreate, autoCreateErrors, clr)) {
            modified = true;
        }
        if (this.secondaryTables != null) {
            Collection secTables = this.secondaryTables.values();
            Iterator iter = secTables.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)iter.next();
                if (!secTable.validateConstraints(conn, autoCreate, autoCreateErrors, clr)) continue;
                modified = true;
            }
        }
        return modified;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CallBack {
        final AbstractMemberMetaData fmd;

        public CallBack(AbstractMemberMetaData fmd) {
            this.fmd = fmd;
        }
    }
}

