/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;

public class StatementText {
    private static int nextParamID = 0;
    private StringBuffer statementText;
    private List parameterNames = null;
    private Map parameterMappingsByName = null;
    private Map parameterValuesByName = null;
    private boolean encloseWithInParentheses = false;
    private String postpend;
    private List appended = new ArrayList();

    public StatementText() {
    }

    public StatementText(String initialStatementText) {
        this();
        this.append(initialStatementText);
    }

    public void clearStatement() {
        this.statementText = null;
        this.appended.clear();
    }

    private void initParameters() {
        if (this.parameterNames == null) {
            this.parameterNames = new ArrayList();
            this.parameterMappingsByName = new HashMap();
            this.parameterValuesByName = new HashMap();
        }
    }

    public void encloseWithInParentheses() {
        this.statementText = null;
        this.encloseWithInParentheses = true;
    }

    public StatementText postpend(String s) {
        this.statementText = null;
        this.postpend = s;
        return this;
    }

    public StatementText append(char c) {
        this.statementText = null;
        this.appended.add(new Character(c));
        return this;
    }

    public StatementText append(String s) {
        this.statementText = null;
        this.appended.add(s);
        return this;
    }

    public StatementText append(QueryExpression qsc) {
        this.statementText = null;
        this.appended.add(qsc);
        return this;
    }

    public StatementText append(StatementText st, int mode) {
        this.appended.add(st.toStatementString(mode));
        if (st.parameterNames != null) {
            this.initParameters();
            this.parameterNames.addAll(st.parameterNames);
            this.parameterMappingsByName.putAll(st.parameterMappingsByName);
            this.parameterValuesByName.putAll(st.parameterValuesByName);
        }
        return this;
    }

    public StatementText append(ScalarExpression expr) {
        this.appended.add(expr);
        return this;
    }

    public String appendParameter(JavaTypeMapping mapping, Object value) {
        this.statementText = null;
        String name = "param-" + nextParamID++;
        this.appended.add(new Parameter(name, mapping, value));
        return name;
    }

    public void setParameters(ObjectManager om, Object datastoreStatement) {
        if (this.parameterNames != null) {
            Iterator i = this.parameterNames.iterator();
            int stmtParamNum = 1;
            while (i.hasNext()) {
                Object name = i.next();
                JavaTypeMapping mapping = (JavaTypeMapping)this.parameterMappingsByName.get(name);
                Object value = this.parameterValuesByName.get(name);
                mapping.setObject(om, datastoreStatement, Mappings.getParametersIndex(stmtParamNum, mapping), value);
                if (mapping.getNumberOfDatastoreFields() > 0) {
                    stmtParamNum += mapping.getNumberOfDatastoreFields();
                    continue;
                }
                ++stmtParamNum;
            }
        }
    }

    public String toStatementString(int mode) {
        if (this.statementText == null) {
            this.statementText = new StringBuffer();
            if (this.encloseWithInParentheses) {
                this.statementText.append("(");
            }
            for (int i = 0; i < this.appended.size(); ++i) {
                StatementText st;
                Object item = this.appended.get(i);
                if (item instanceof ScalarExpression) {
                    ScalarExpression expr = (ScalarExpression)item;
                    st = expr.toStatementText(mode);
                    this.statementText.append(st.toStatementString(mode));
                    if (st.parameterNames == null) continue;
                    this.initParameters();
                    this.parameterNames.addAll(st.parameterNames);
                    this.parameterMappingsByName.putAll(st.parameterMappingsByName);
                    this.parameterValuesByName.putAll(st.parameterValuesByName);
                    continue;
                }
                if (item instanceof Parameter) {
                    Parameter param = (Parameter)item;
                    this.statementText.append('?');
                    this.initParameters();
                    this.parameterNames.add(param.name);
                    this.parameterMappingsByName.put(param.name, param.mapping);
                    this.parameterValuesByName.put(param.name, param.value);
                    continue;
                }
                if (item instanceof QueryExpression) {
                    QueryExpression qe = (QueryExpression)item;
                    st = qe.toStatementText(false);
                    this.statementText.append(st.toStatementString(mode));
                    if (st.parameterNames == null) continue;
                    this.initParameters();
                    this.parameterNames.addAll(st.parameterNames);
                    this.parameterMappingsByName.putAll(st.parameterMappingsByName);
                    this.parameterValuesByName.putAll(st.parameterValuesByName);
                    continue;
                }
                if (item instanceof StatementText) {
                    StatementText st2 = (StatementText)item;
                    this.statementText.append(st2.toStatementString(mode));
                    if (st2.parameterNames == null) continue;
                    this.initParameters();
                    this.parameterNames.addAll(st2.parameterNames);
                    this.parameterMappingsByName.putAll(st2.parameterMappingsByName);
                    this.parameterValuesByName.putAll(st2.parameterValuesByName);
                    continue;
                }
                this.statementText.append(item);
            }
            if (this.encloseWithInParentheses) {
                this.statementText.append(")");
            }
            this.statementText.append(this.postpend == null ? "" : this.postpend);
        }
        return this.statementText.toString();
    }

    public String toString() {
        return this.toStatementString(ScalarExpression.PROJECTION);
    }

    private class Parameter {
        final String name;
        final JavaTypeMapping mapping;
        final Object value;

        public Parameter(String name, JavaTypeMapping mapping, Object value) {
            this.name = name;
            this.mapping = mapping;
            this.value = value;
        }
    }
}

