/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.util.Localiser;

public abstract class JavaTypeMapping {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)(class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = JavaTypeMapping.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    public static final int MAPPING_FIELD = 0;
    public static final int MAPPING_COLLECTION_ELEMENT = 1;
    public static final int MAPPING_ARRAY_ELEMENT = 2;
    public static final int MAPPING_MAP_KEY = 3;
    public static final int MAPPING_MAP_VALUE = 4;
    protected AbstractMemberMetaData fmd;
    protected int roleForField = 0;
    protected DatastoreMapping[] datastoreMappings = new DatastoreMapping[0];
    protected DatastoreContainerObject datastoreContainer;
    protected DatastoreAdapter dba;
    protected String type;
    protected JavaTypeMapping referenceMapping;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    protected JavaTypeMapping() {
    }

    protected JavaTypeMapping(DatastoreAdapter dba, String type, AbstractMemberMetaData fmd, DatastoreContainerObject container) {
        this.dba = dba;
        this.type = type;
        this.fmd = fmd;
        this.datastoreContainer = container;
    }

    public void initialize(DatastoreAdapter dba, String type) {
        this.dba = dba;
        this.type = type;
    }

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        this.dba = dba;
        this.fmd = fmd;
        this.type = fmd.getType().getName();
        this.datastoreContainer = container;
    }

    public void setFieldInformation(AbstractMemberMetaData fmd, DatastoreContainerObject container) {
        this.fmd = fmd;
        this.datastoreContainer = container;
    }

    public void setRoleForField(int role) {
        this.roleForField = role;
    }

    public boolean isSerialised() {
        if (this.roleForField == 0) {
            return this.fmd != null ? this.fmd.isSerialized() : false;
        }
        if (this.roleForField == 1) {
            if (this.fmd == null) {
                return false;
            }
            return this.fmd.getCollection() != null ? this.fmd.getCollection().isSerializedElement() : false;
        }
        if (this.roleForField == 2) {
            if (this.fmd == null) {
                return false;
            }
            return this.fmd.getArray() != null ? this.fmd.getArray().isSerializedElement() : false;
        }
        if (this.roleForField == 3) {
            if (this.fmd == null) {
                return false;
            }
            return this.fmd.getMap() != null ? this.fmd.getMap().isSerializedKey() : false;
        }
        if (this.roleForField == 4) {
            if (this.fmd == null) {
                return false;
            }
            return this.fmd.getMap() != null ? this.fmd.getMap().isSerializedValue() : false;
        }
        return false;
    }

    public boolean isNullable() {
        for (int i = 0; i < this.datastoreMappings.length; ++i) {
            if (this.datastoreMappings[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    public DatastoreMapping[] getDataStoreMappings() {
        return this.datastoreMappings;
    }

    public DatastoreContainerObject getDatastoreContainer() {
        return this.datastoreContainer;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        return this.datastoreMappings[index];
    }

    public JavaTypeMapping getReferenceMapping() {
        return this.referenceMapping;
    }

    public void setReferenceMapping(JavaTypeMapping referenceMapping) {
        this.referenceMapping = referenceMapping;
    }

    public void addDataStoreMapping(DatastoreMapping datastoreMapping) {
        DatastoreMapping[] dm = this.datastoreMappings;
        this.datastoreMappings = new DatastoreMapping[this.datastoreMappings.length + 1];
        System.arraycopy(dm, 0, this.datastoreMappings, 0, dm.length);
        this.datastoreMappings[dm.length] = datastoreMapping;
    }

    public int getNumberOfDatastoreFields() {
        return this.datastoreMappings.length;
    }

    public AbstractMemberMetaData getFieldMetaData() {
        return this.fmd;
    }

    public int getRoleForField() {
        return this.roleForField;
    }

    public abstract Class getJavaType();

    public String getJavaTypeForDatastoreMapping(int index) {
        throw new UnsupportedOperationException("Datastore type mapping is not supported by: " + this.getClass());
    }

    public String getType() {
        return this.type;
    }

    public abstract Object getSampleValue(ClassLoaderResolver var1);

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean includeInUpdateStatement() {
        return true;
    }

    public boolean includeInInsertStatement() {
        return true;
    }

    public abstract ScalarExpression newLiteral(QueryExpression var1, Object var2);

    public abstract ScalarExpression newScalarExpression(QueryExpression var1, LogicSetExpression var2);

    protected String failureMessage(String method) {
        return LOCALISER.msg("041004", (Object)this.getClass().getName(), (Object)method);
    }

    public void setDefault(ObjectManager om, Object datastoreStatement, int[] exprIndex) {
        this.getDataStoreMapping(0).setObject(datastoreStatement, exprIndex[0], this.isNullable() ? null : this.getSampleValue(om.getClassLoaderResolver()));
    }

    public void setBoolean(ObjectManager om, Object datastoreStatement, int[] exprIndex, boolean value) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public boolean getBoolean(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public void setChar(ObjectManager om, Object datastoreStatement, int[] exprIndex, char value) {
        throw new NucleusException(this.failureMessage("setChar")).setFatal();
    }

    public char getChar(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getChar")).setFatal();
    }

    public void setByte(ObjectManager om, Object datastoreStatement, int[] exprIndex, byte value) {
        throw new NucleusException(this.failureMessage("setByte")).setFatal();
    }

    public byte getByte(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getByte")).setFatal();
    }

    public void setShort(ObjectManager om, Object datastoreStatement, int[] exprIndex, short value) {
        throw new NucleusException(this.failureMessage("setShort")).setFatal();
    }

    public short getShort(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getShort")).setFatal();
    }

    public void setInt(ObjectManager om, Object datastoreStatement, int[] exprIndex, int value) {
        throw new NucleusException(this.failureMessage("setInt")).setFatal();
    }

    public int getInt(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getInt")).setFatal();
    }

    public void setLong(ObjectManager om, Object datastoreStatement, int[] exprIndex, long value) {
        throw new NucleusException(this.failureMessage("setLong")).setFatal();
    }

    public long getLong(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getLong")).setFatal();
    }

    public void setFloat(ObjectManager om, Object datastoreStatement, int[] exprIndex, float value) {
        throw new NucleusException(this.failureMessage("setFloat")).setFatal();
    }

    public float getFloat(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getFloat")).setFatal();
    }

    public void setDouble(ObjectManager om, Object datastoreStatement, int[] exprIndex, double value) {
        throw new NucleusException(this.failureMessage("setDouble")).setFatal();
    }

    public double getDouble(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getDouble")).setFatal();
    }

    public void setString(ObjectManager om, Object datastoreStatement, int[] exprIndex, String value) {
        throw new NucleusException(this.failureMessage("setString")).setFatal();
    }

    public String getString(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getString")).setFatal();
    }

    public void setObject(ObjectManager om, Object datastoreStatement, int[] exprIndex, Object value, StateManager ownerSM, int ownerFieldNumber) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public void setObject(ObjectManager om, Object datastoreStatement, int[] exprIndex, Object value) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public Object getObject(ObjectManager om, Object datastoreResults, int[] exprIndex, StateManager ownerSM, int ownerFieldNumber) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    public Object getObject(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

