/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SqlTemporalExpression;
import org.datanucleus.store.mapped.expression.SqlTimestampLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class GregorianCalendarMapping
extends SingleFieldMultiMapping {
    boolean singleColumn = false;
    static /* synthetic */ Class class$java$util$GregorianCalendar;

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        if (fmd.hasExtension("calendar-one-column") && fmd.getValueForExtension("calendar-one-column").equals("true")) {
            this.singleColumn = true;
        }
        if (this.singleColumn) {
            this.addDatastoreField(ClassNameConstants.JAVA_SQL_TIMESTAMP);
        } else {
            this.addDatastoreField(ClassNameConstants.LONG);
            this.addDatastoreField(ClassNameConstants.JAVA_LANG_STRING);
        }
    }

    public Class getJavaType() {
        return class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = GregorianCalendarMapping.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar;
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.singleColumn) {
            return ClassNameConstants.JAVA_SQL_TIMESTAMP;
        }
        if (index == 0) {
            return ClassNameConstants.LONG;
        }
        if (index == 1) {
            return ClassNameConstants.JAVA_LANG_STRING;
        }
        return null;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return new GregorianCalendar();
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        GregorianCalendar cal = (GregorianCalendar)value;
        if (this.singleColumn) {
            Timestamp ts = null;
            if (cal != null) {
                ts = new Timestamp(cal.getTimeInMillis());
            }
            this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], ts);
        } else if (cal == null) {
            this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
            this.getDataStoreMapping(1).setObject(preparedStatement, exprIndex[1], null);
        } else {
            this.getDataStoreMapping(0).setLong(preparedStatement, exprIndex[0], cal.getTime().getTime());
            this.getDataStoreMapping(1).setString(preparedStatement, exprIndex[1], cal.getTimeZone().getID());
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        try {
            if (this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.singleColumn) {
            Timestamp ts = (Timestamp)this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(ts.getTime());
            String timezoneID = om.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.ServerTimeZoneID");
            if (timezoneID != null) {
                cal.setTimeZone(TimeZone.getTimeZone(timezoneID));
            }
            return cal;
        }
        long millisecs = this.getDataStoreMapping(0).getLong(resultSet, exprIndex[0]);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(millisecs));
        String timezoneId = this.getDataStoreMapping(1).getString(resultSet, exprIndex[1]);
        if (timezoneId != null) {
            cal.setTimeZone(TimeZone.getTimeZone(timezoneId));
        }
        return cal;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.singleColumn) {
            return new SqlTimestampLiteral(qs, (JavaTypeMapping)this, (Timestamp)value);
        }
        throw new NucleusUserException("JPOX doesnt support querying of Calendar fields when stored as 2 columns");
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.singleColumn) {
            return new SqlTemporalExpression(qs, this, te);
        }
        throw new NucleusUserException("JPOX doesnt support querying of Calendar fields when stored as 2 columns");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

