/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.mapped.expression.ArrayExpression;
import org.datanucleus.store.mapped.expression.ArrayLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.util.NucleusLogger;

public class ArrayMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    private static Byte mappingSampleValue = new Byte("0");

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ArrayMapping sm = (ArrayMapping)obj;
        return this.fmd.equals(sm.fmd) && ((Object)((Object)this.storeMgr)).equals((Object)sm.storeMgr);
    }

    public Class getJavaType() {
        if (this.fmd != null) {
            return this.fmd.getType();
        }
        return null;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return mappingSampleValue;
    }

    protected boolean containerIsStoredInSingleColumn() {
        if (super.containerIsStoredInSingleColumn()) {
            return true;
        }
        return this.fmd != null && this.fmd.hasArray() && this.fmd.getJoinMetaData() == null && MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.fmd);
    }

    public void postInsert(StateManager sm) {
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting((ObjectManager)sm.getObjectManager(), (Object)value);
            return;
        }
        if (value == null) {
            return;
        }
        if (!this.fmd.isCascadePersist()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007006", (Object)this.fmd.getFullFieldName()));
            }
            if (!this.fmd.getType().getComponentType().isPrimitive()) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    if (sm.getObjectManager().getApiAdapter().isDetached(array[i]) || sm.getObjectManager().getApiAdapter().isPersistent(array[i])) continue;
                    throw new ReachableObjectNotCascadedException(this.fmd.getFullFieldName(), array[i]);
                }
            }
        } else {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007007", (Object)this.fmd.getFullFieldName()));
            }
            ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.fmd, null)).set(sm, value);
        }
    }

    public void postFetch(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        List elements = ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.fmd, null)).getArray(sm);
        if (elements != null) {
            boolean primitiveArray = this.fmd.getType().getComponentType().isPrimitive();
            Object array = Array.newInstance(this.fmd.getType().getComponentType(), elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                if (primitiveArray) {
                    if (element instanceof Boolean) {
                        Array.setBoolean(array, i, (Boolean)element);
                        continue;
                    }
                    if (element instanceof Byte) {
                        Array.setByte(array, i, (Byte)element);
                        continue;
                    }
                    if (element instanceof Character) {
                        Array.setChar(array, i, ((Character)element).charValue());
                        continue;
                    }
                    if (element instanceof Double) {
                        Array.setDouble(array, i, (Double)element);
                        continue;
                    }
                    if (element instanceof Float) {
                        Array.setFloat(array, i, ((Float)element).floatValue());
                        continue;
                    }
                    if (element instanceof Integer) {
                        Array.setInt(array, i, (Integer)element);
                        continue;
                    }
                    if (element instanceof Long) {
                        Array.setLong(array, i, (Long)element);
                        continue;
                    }
                    if (!(element instanceof Short)) continue;
                    Array.setShort(array, i, (Short)element);
                    continue;
                }
                Array.set(array, i, element);
            }
            if (elements.size() == 0) {
                sm.replaceField(this.fmd.getAbsoluteFieldNumber(), null, true);
            } else {
                sm.replaceField(this.fmd.getAbsoluteFieldNumber(), array, true);
            }
        } else {
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), null, true);
        }
    }

    public void postUpdate(StateManager sm) {
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting((ObjectManager)sm.getObjectManager(), (Object)value);
            return;
        }
        if (value == null) {
            ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.fmd, null)).clear(sm);
            return;
        }
        if (!this.fmd.isCascadeUpdate()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007008", (Object)this.fmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007009", (Object)this.fmd.getFullFieldName()));
        }
        ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.fmd, null)).clear(sm);
        ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.fmd, null)).set(sm, value);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.getObjectManager().getApiAdapter().isLoaded(sm, this.fmd.getAbsoluteFieldNumber());
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.fmd, null)).clear(sm);
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(JavaTypeMapping.LOCALISER.msg("041026", (Object)this.fmd.getFullFieldName())).setFatal();
        }
        return new ArrayLiteral(qs, (JavaTypeMapping)this, value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(JavaTypeMapping.LOCALISER.msg("041026", (Object)this.fmd.getFullFieldName())).setFatal();
        }
        return new ArrayExpression(qs, this.datastoreContainer.getIDMapping(), te, (ArrayStore)this.storeMgr.getBackingStoreForField(qs.getClassLoaderResolver(), this.fmd, null), this.fieldName);
    }
}

