/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.ContainerSizeExpression;
import org.datanucleus.store.mapped.expression.ExistsExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.query.StatementText;
import org.datanucleus.store.mapped.scostore.MapStoreQueryable;
import org.datanucleus.store.scostore.MapStore;

public class MapExpression
extends ScalarExpression {
    private final MapStore mapStore;
    private final String fieldName;

    public MapExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te, MapStore mapStore, String fieldName) {
        super(qs);
        this.mapping = mapping;
        this.te = te;
        this.mapStore = mapStore;
        this.fieldName = fieldName;
    }

    public NumericExpression sizeMethod() {
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        String ctIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifier();
        DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(0, ctIdentifier);
        return new ContainerSizeExpression(this.qs, this.getBackingStoreQueryable().getSizeSubquery(this.qs, this.mapping, this.te, ctRangeVar));
    }

    public BooleanExpression containsKeyMethod(ScalarExpression expr) {
        DatastoreIdentifier vtRangeVar;
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        if (expr instanceof UnboundVariable) {
            UnboundVariable var = (UnboundVariable)expr;
            if (var.getVariableType() == null) {
                var.setVariableType(this.qs.getClassLoaderResolver().classForName(this.mapStore.getKeyType()));
            }
            String vtIdentifier = "UNBOUND." + var.getVariableName();
            String mtIdentifier = idFactory.newIdentifier(idFactory.newIdentifier(this.te.getAlias(), this.fieldName), var.getVariableName()).getIdentifier();
            DatastoreIdentifier mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
            DatastoreIdentifier vtRangeVar2 = idFactory.newIdentifier(0, vtIdentifier);
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, mtRangeVar);
            var.bindTo(this.getBackingStoreQueryable().joinKeysTo(qexpr, this.qs, this.mapping, this.te, mtRangeVar, var.getVariableType(), expr, vtRangeVar2));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        if (expr instanceof Literal) {
            String vtIdentifier;
            DatastoreIdentifier vtRangeVar3;
            String mtIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifier();
            DatastoreIdentifier mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
            int n = 0;
            while (this.qs.getTableExpression(vtRangeVar3 = idFactory.newIdentifier(0, vtIdentifier = mtIdentifier + '.' + ++n)) != null) {
            }
            ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, mtRangeVar);
            ScalarExpression joinKeysExpr = this.getBackingStoreQueryable().joinKeysTo(qexpr, this.qs, this.mapping, this.te, mtRangeVar, clr.classForName(expr.getMapping().getType()), expr, vtRangeVar3);
            qexpr.andCondition(expr.eq(joinKeysExpr));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        String mtIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifier();
        DatastoreIdentifier mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
        if (expr.te == null) {
            String vtIdentifier;
            int n = 0;
            while (this.qs.getTableExpression(vtRangeVar = idFactory.newIdentifier(0, vtIdentifier = mtIdentifier + '.' + ++n)) != null) {
            }
        } else {
            vtRangeVar = expr.te.getAlias();
        }
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        ScalarExpression joinKeysExpr = this.getBackingStoreQueryable().joinKeysTo(expr.getQueryExpression(), this.qs, this.mapping, this.te, mtRangeVar, clr.classForName(this.mapStore.getKeyType()), expr, vtRangeVar);
        return joinKeysExpr.eq(expr);
    }

    public BooleanExpression containsEntryMethod(ScalarExpression keyExpr, ScalarExpression valueExpr) {
        DatastoreIdentifier vtRangeVar;
        Class valueType;
        DatastoreIdentifier ktRangeVar;
        Class keyType;
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        String mtIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifier();
        DatastoreIdentifier mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
        UnboundVariable keyVar = null;
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        int nKey = 0;
        if (keyExpr instanceof UnboundVariable) {
            keyVar = (UnboundVariable)keyExpr;
            String ktJavaName = "UNBOUND." + keyVar.getVariableName();
            keyType = keyVar.getVariableType();
            ktRangeVar = idFactory.newIdentifier(0, ktJavaName);
        } else {
            String ktIdentifier;
            keyType = clr.classForName(this.mapStore.getKeyType());
            while (this.qs.getTableExpression(ktRangeVar = idFactory.newIdentifier(0, ktIdentifier = mtIdentifier + '.' + ++nKey)) != null) {
            }
        }
        UnboundVariable valueVar = null;
        int nValue = 0;
        if (valueExpr instanceof UnboundVariable) {
            valueVar = (UnboundVariable)valueExpr;
            String vtJavaName = "UNBOUND." + valueVar.getVariableName();
            valueType = valueVar.getVariableType();
            vtRangeVar = idFactory.newIdentifier(0, vtJavaName);
        } else {
            String vtIdentifier;
            valueType = clr.classForName(this.mapStore.getValueType());
            while (this.qs.getTableExpression(vtRangeVar = idFactory.newIdentifier(0, vtIdentifier = mtIdentifier + '.' + ++nValue)) != null) {
            }
        }
        QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, mtRangeVar);
        ScalarExpression[] qclKeyValues = this.getBackingStoreQueryable().joinKeysValuesTo(qexpr, this.qs, this.mapping, this.te, mtRangeVar, keyType, valueType, keyExpr, valueExpr, ktRangeVar, vtRangeVar);
        if (keyExpr instanceof UnboundVariable) {
            keyVar.bindTo(qclKeyValues[0]);
        }
        if (valueExpr instanceof UnboundVariable) {
            valueVar.bindTo(qclKeyValues[1]);
        }
        if (!(keyExpr instanceof UnboundVariable)) {
            qexpr.andCondition(keyExpr.eq(qclKeyValues[0]));
        }
        if (!(valueExpr instanceof UnboundVariable)) {
            qexpr.andCondition(valueExpr.eq(qclKeyValues[1]));
        }
        return new ExistsExpression(this.qs, qexpr, true);
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        return this.containsValueMethod(expr);
    }

    public BooleanExpression containsValueMethod(ScalarExpression expr) {
        DatastoreIdentifier vtRangeVar;
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        if (expr instanceof UnboundVariable) {
            UnboundVariable var = (UnboundVariable)expr;
            if (var.getVariableType() == null) {
                var.setVariableType(this.qs.getClassLoaderResolver().classForName(this.mapStore.getValueType()));
            }
            String vtIdentifier = "UNBOUND." + var.getVariableName();
            String mtIdentifier = idFactory.newIdentifier(idFactory.newIdentifier(this.te.getAlias(), this.fieldName), var.getVariableName()).getIdentifier();
            DatastoreIdentifier mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
            DatastoreIdentifier vtRangeVar2 = idFactory.newIdentifier(0, vtIdentifier);
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, mtRangeVar);
            var.bindTo(this.getBackingStoreQueryable().joinValuesTo(qexpr, this.qs, this.mapping, this.te, mtRangeVar, var.getVariableType(), expr, vtRangeVar2));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        if (expr instanceof Literal) {
            String vtIdentifier;
            DatastoreIdentifier vtRangeVar3;
            String mtIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifier();
            DatastoreIdentifier mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
            int n = 0;
            while (this.qs.getTableExpression(vtRangeVar3 = idFactory.newIdentifier(0, vtIdentifier = mtIdentifier + '.' + ++n)) != null) {
            }
            ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
            QueryExpression qexpr = this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, mtRangeVar);
            ScalarExpression joinValuesExpr = this.getBackingStoreQueryable().joinValuesTo(qexpr, this.qs, this.mapping, this.te, mtRangeVar, clr.classForName(expr.getMapping().getType()), expr, vtRangeVar3);
            qexpr.andCondition(expr.eq(joinValuesExpr));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        String mtIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifier();
        DatastoreIdentifier mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
        if (expr.te == null) {
            String vtIdentifier;
            int n = 0;
            while (this.qs.getTableExpression(vtRangeVar = idFactory.newIdentifier(0, vtIdentifier = mtIdentifier + '.' + ++n)) != null) {
            }
        } else {
            vtRangeVar = expr.te.getAlias();
        }
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        ScalarExpression joinValuesExpr = this.getBackingStoreQueryable().joinValuesTo(expr.getQueryExpression(), this.qs, this.mapping, this.te, mtRangeVar, clr.classForName(this.mapStore.getValueType()), expr, vtRangeVar);
        return joinValuesExpr.eq(expr);
    }

    public BooleanExpression isEmptyMethod() {
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        String mtIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifier();
        DatastoreIdentifier mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
        return new ExistsExpression(this.qs, this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, mtRangeVar), false);
    }

    public ScalarExpression getMethod(ScalarExpression expr) {
        DatastoreIdentifier vtRangeVar;
        DatastoreIdentifier ktRangeVar;
        DatastoreIdentifier mtRangeVar;
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        String mtIdentifier = idFactory.newIdentifier(this.te.getAlias(), this.fieldName).getIdentifier();
        int n = 0;
        if (expr instanceof UnboundVariable) {
            UnboundVariable var = (UnboundVariable)expr;
            if (var.getVariableType() == null) {
                var.setVariableType(this.qs.getClassLoaderResolver().classForName(this.mapStore.getKeyType()));
            }
            String ktIdentifier = "UNBOUND." + var.getVariableName();
            String vtIdentifier = "UNBOUNDVALUE." + var.getVariableName();
            mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
            ktRangeVar = idFactory.newIdentifier(0, ktIdentifier);
            vtRangeVar = idFactory.newIdentifier(0, vtIdentifier);
        } else {
            String vtIdentifier;
            String ktJavaName;
            mtRangeVar = idFactory.newIdentifier(0, mtIdentifier);
            while (this.qs.getTableExpression(ktRangeVar = idFactory.newIdentifier(0, ktJavaName = mtIdentifier + '.' + ++n)) != null) {
            }
            n = 0;
            while (this.qs.getTableExpression(vtRangeVar = idFactory.newIdentifier(0, vtIdentifier = mtIdentifier + '.' + ++n)) != null || vtRangeVar.equals(ktRangeVar)) {
            }
        }
        this.getBackingStoreQueryable().getExistsSubquery(this.qs, this.mapping, this.te, mtRangeVar);
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        ScalarExpression[] joinKeysExpr = this.getBackingStoreQueryable().joinKeysToGet(this.qs, this.qs, this.mapping, this.te, mtRangeVar, clr.classForName(this.mapStore.getKeyType()), ktRangeVar, vtRangeVar);
        if (expr instanceof UnboundVariable) {
            UnboundVariable var = (UnboundVariable)expr;
            var.bindTo(joinKeysExpr[0]);
        }
        return new ObjectExpression(this.qs, joinKeysExpr[1], joinKeysExpr[0].eq(expr), joinKeysExpr[1].te);
    }

    public StatementText toStatementText(int mode) {
        throw new NucleusUserException("Cannot reference Map object directly: field name = " + this.fieldName);
    }

    private MapStoreQueryable getBackingStoreQueryable() {
        return (MapStoreQueryable)this.mapStore;
    }
}

