/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.scostore.AbstractCollectionStore;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.NucleusLogger;

abstract class AbstractSetStore
extends AbstractCollectionStore
implements SetStore {
    protected String setName;

    protected AbstractSetStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager ownerSM) {
        SetStoreIterator iter;
        QueryExpression stmt = this.getIteratorStatement(ownerSM);
        if (stmt == null) {
            throw new NucleusException(BaseContainerStore.LOCALISER.msg("056005")).setFatal();
        }
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        ObjectManager om = ownerSM.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        String statement = this.storeMgr.getStatementTextForQuery(stmt, useUpdateLock);
        if (statement == null) {
            throw new NucleusException(BaseContainerStore.LOCALISER.msg("056005")).setFatal();
        }
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = this.storeMgr.getStatementForQuery(stmt, om, mconn, useUpdateLock, null, null);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                    try {
                        iter = new SetStoreIterator(ownerSM, rs, rof);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(BaseContainerStore.LOCALISER.msg("056006", (Object)statement), (Throwable)e);
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int size) {
        this.validateElementForWriting(sm, element, null);
        boolean modified = false;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                int[] num = this.internalAdd(sm, mconn, false, element, true);
                if (num[0] > 0) {
                    modified = true;
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            String msg = BaseContainerStore.LOCALISER.msg("056009", (Object)this.getAddStmt());
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, (Throwable)e);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = elements.size() > 1;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.validateElementForWriting(sm, iter.next(), null);
        }
        ObjectManager om = sm.getObjectManager();
        ManagedConnection mconn = this.storeMgr.getConnection(om);
        try {
            iter = elements.iterator();
            Object element = null;
            int[] returnCode = null;
            while (iter.hasNext()) {
                element = iter.next();
                try {
                    returnCode = this.internalAdd(sm, mconn, batched, element, !batched || batched && !iter.hasNext());
                }
                catch (SQLException sqe) {
                    exceptions.add(sqe);
                    NucleusLogger.DATASTORE.error((Object)sqe);
                }
            }
            if (exceptions.size() == 0) {
                if (returnCode == null) {
                    modified = false;
                } else {
                    for (int i = 0; i < returnCode.length; ++i) {
                        if (returnCode[i] <= 0) continue;
                        modified = true;
                    }
                }
            }
        }
        finally {
            mconn.release();
        }
        if (!exceptions.isEmpty()) {
            String msg = BaseContainerStore.LOCALISER.msg("056009", (Object)this.getAddStmt());
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalAdd(StateManager ownerSM, ManagedConnection conn, boolean batched, Object element, boolean processNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmt();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
            jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
            }
            int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, processNow);
            return nArray;
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(StateManager sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(sm, element)) {
            NucleusLogger.DATASTORE.debug((Object)("AbstractSetStore::remove element=" + element + " doesn't exist in this Set."));
            return false;
        }
        boolean modified = false;
        ObjectManager om = sm.getObjectManager();
        String removeStmt = this.getRemoveStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeStmt, false);
                try {
                    int[] rowsDeleted;
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    modified = (rowsDeleted = sqlControl.executeStatementUpdate(mconn, removeStmt, ps, true))[0] == 1;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            String msg = BaseContainerStore.LOCALISER.msg("056012", (Object)removeStmt);
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, (Throwable)e);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (allowDependentField && collmd.isDependentElement() && !collmd.isEmbeddedElement()) {
            om.deleteObjectInternal(element);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = elements.size() > 1;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (this.validateElementForReading(sm, element)) continue;
            NucleusLogger.DATASTORE.debug((Object)("AbstractSetStore::removeAll element=" + element + " doesn't exist in this Set."));
            return false;
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                Object element = null;
                iter = elements.iterator();
                SQLController sqlControl = this.storeMgr.getSQLController();
                sqlControl.processStatementsForConnection(mconn);
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        int[] rc = this.internalRemove(sm, mconn, batched, element, !batched || batched && !iter.hasNext());
                        if (rc == null) continue;
                        for (int i = 0; i < rc.length; ++i) {
                            if (rc[i] <= 0) continue;
                            modified = true;
                        }
                    }
                    catch (SQLException sqe) {
                        sqe.printStackTrace();
                        exceptions.add(sqe);
                        NucleusLogger.DATASTORE.error((Object)sqe);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            exceptions.add(e);
            NucleusLogger.DATASTORE.error((Object)e);
        }
        if (!exceptions.isEmpty()) {
            String msg = BaseContainerStore.LOCALISER.msg("056012", (Object)this.getRemoveStmt());
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalRemove(StateManager ownerSM, ManagedConnection conn, boolean batched, Object element, boolean executeNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String removeStmt = this.getRemoveStmt();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
            jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
            }
            int[] nArray = sqlControl.executeStatementUpdate(conn, removeStmt, ps, executeNow);
            return nArray;
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    private class SetStoreIterator
    implements Iterator {
        private final StateManager sm;
        private final ObjectManager om;
        private final Iterator delegate;
        private Object lastElement = null;

        public SetStoreIterator(StateManager sm, ResultSet rs, ResultObjectFactory rof) throws SQLException {
            this.sm = sm;
            this.om = sm.getObjectManager();
            ArrayList<Object> results = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    Object nextElement;
                    int i;
                    int[] param;
                    if (AbstractSetStore.this.elementsAreEmbedded || AbstractSetStore.this.elementsAreSerialised) {
                        param = new int[AbstractSetStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (AbstractSetStore.this.elementMapping instanceof SerialisedPCMapping || AbstractSetStore.this.elementMapping instanceof SerialisedReferenceMapping || AbstractSetStore.this.elementMapping instanceof EmbeddedElementPCMapping) {
                            int ownerFieldNumber = -1;
                            if (AbstractSetStore.this.containerTable != null) {
                                ownerFieldNumber = ((JoinTable)AbstractSetStore.this.containerTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                            }
                            nextElement = AbstractSetStore.this.elementMapping.getObject(this.om, rs, param, sm, ownerFieldNumber);
                        } else {
                            nextElement = AbstractSetStore.this.elementMapping.getObject(this.om, rs, param);
                        }
                    } else if (AbstractSetStore.this.elementMapping instanceof ReferenceMapping) {
                        param = new int[AbstractSetStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        nextElement = AbstractSetStore.this.elementMapping.getObject(this.om, rs, param);
                    } else {
                        nextElement = rof.getObject(this.om, (Object)rs);
                    }
                    results.add(nextElement);
                }
            }
            this.delegate = ((AbstractList)results).iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            AbstractSetStore.this.remove(this.sm, this.lastElement, -1, true);
            this.delegate.remove();
            this.lastElement = null;
        }
    }
}

