/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.exceptions.ClassNotPersistenceCapableException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.Extent;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryCompiler;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.PersistentSuperclassNotAllowedException;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.SQLEvaluator;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.query.TransientIDROF;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MacroString;
import org.datanucleus.util.NucleusLogger;

public class NucleusSQLQuery
extends Query {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)(class$org$datanucleus$store$rdbms$RDBMSManager == null ? (class$org$datanucleus$store$rdbms$RDBMSManager = NucleusSQLQuery.class$("org.datanucleus.store.rdbms.RDBMSManager")) : class$org$datanucleus$store$rdbms$RDBMSManager).getClassLoader());
    protected final transient String inputSQL;
    protected transient String compiledSQL = null;
    protected transient List parameterOccurrences = null;
    protected transient List fieldColumnNames = null;
    protected transient int[] fieldNumbers = null;
    protected transient StatementExpressionIndex[] statementExpressionIndex;
    protected transient Map parameterTypesByName = null;
    protected transient boolean isCompiled = false;
    static /* synthetic */ Class class$org$datanucleus$store$rdbms$RDBMSManager;

    public NucleusSQLQuery(ObjectManager om, NucleusSQLQuery query) {
        this(om, query.inputSQL);
    }

    public NucleusSQLQuery(ObjectManager om) {
        this(om, (String)null);
    }

    public NucleusSQLQuery(ObjectManager om, String sqlText) {
        super(om);
        this.candidateClass = null;
        this.filter = null;
        this.imports = null;
        this.explicitVariables = null;
        this.explicitParameters = null;
        this.ordering = null;
        if (sqlText == null) {
            throw new NucleusUserException(Query.LOCALISER.msg("059001"));
        }
        this.inputSQL = sqlText.trim();
    }

    public String getInputSQL() {
        return this.inputSQL;
    }

    protected boolean shouldReturnSingleRow() {
        return this.unique;
    }

    public void setCandidates(Extent pcs) {
        throw new NucleusUserException(Query.LOCALISER.msg("059004"));
    }

    public void setCandidates(Collection pcs) {
        throw new NucleusUserException(Query.LOCALISER.msg("059005"));
    }

    public void setResult(String result) {
        throw new NucleusUserException(Query.LOCALISER.msg("059006"));
    }

    public void setRange(int fromIncl, int toExcl) {
        throw new NucleusUserException(Query.LOCALISER.msg("059007"));
    }

    public void setSubclasses(boolean subclasses) {
        throw new NucleusUserException(Query.LOCALISER.msg("059004"));
    }

    public void setFilter(String filter) {
        throw new NucleusUserException(Query.LOCALISER.msg("059008"));
    }

    public void declareExplicitVariables(String variables) {
        throw new NucleusUserException(Query.LOCALISER.msg("059009"));
    }

    public void setGrouping(String grouping) {
        throw new NucleusUserException(Query.LOCALISER.msg("059010"));
    }

    public void setOrdering(String ordering) {
        throw new NucleusUserException(Query.LOCALISER.msg("059011"));
    }

    protected long performDeletePersistentAll(Map parameters) {
        throw new NucleusUserException(Query.LOCALISER.msg("059000"));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NucleusSQLQuery) || !super.equals(obj)) {
            return false;
        }
        return this.inputSQL.equals(((NucleusSQLQuery)((Object)obj)).inputSQL);
    }

    protected void discardCompiled() {
        this.isCompiled = false;
        this.parameterOccurrences = null;
        this.fieldColumnNames = null;
        this.fieldNumbers = null;
        this.statementExpressionIndex = null;
        this.parameterTypesByName = null;
        this.compiledSQL = null;
        super.discardCompiled();
    }

    protected boolean isCompiled() {
        return this.isCompiled;
    }

    public void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.isCompiled) {
            return;
        }
        QueryCompiler c = new QueryCompiler((Query)this, this.getParsedImports(), parameterValues);
        c.compile(1);
        this.parameterNames = c.getParameterNames();
        this.parameterTypesByName = c.getParameterTypesByName();
        this.compiledSQL = this.generateQueryStatement();
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("059012", (Object)this.compiledSQL));
        }
        this.isCompiled = true;
    }

    protected String generateQueryStatement() {
        AbstractClassMetaData candidateCmd;
        if (this.candidateClass == null) {
            this.fieldColumnNames = new ArrayList();
            candidateCmd = null;
        } else {
            MappedStoreManager storeMgr = (MappedStoreManager)this.om.getStoreManager();
            DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
            candidateCmd = this.om.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.om.getClassLoaderResolver());
            if (candidateCmd == null) {
                throw new ClassNotPersistenceCapableException(this.candidateClass.getName());
            }
            if (candidateCmd.getPersistenceCapableSuperclass() != null) {
                throw new PersistentSuperclassNotAllowedException(this.candidateClass.getName());
            }
            if (candidateCmd.isRequiresExtent()) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("060000", (Object)this.candidateClass.getName()));
            }
            if (candidateCmd.getIdentityType() != IdentityType.NONDURABLE) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("060001", (Object)this.candidateClass.getName()));
            }
            int fieldCount = candidateCmd.getNoOfManagedMembers();
            int[] fn = new int[fieldCount];
            this.statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            this.fieldColumnNames = new ArrayList(fieldCount);
            int n = 0;
            for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                this.statementExpressionIndex[fieldNumber] = new StatementExpressionIndex();
                AbstractMemberMetaData fmd = candidateCmd.getMetaDataForManagedMemberAtPosition(fieldNumber);
                String fieldName = fmd.getName();
                Class fieldType = fmd.getType();
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                    JavaTypeMapping m = dba.getMapping(fieldType, storeMgr, this.om.getClassLoaderResolver());
                    if (m.includeInFetchStatement()) {
                        this.statementExpressionIndex[fieldNumber].setMapping(m);
                        fn[n++] = fieldNumber;
                        String columnName = null;
                        columnName = fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0 ? fmd.getColumnMetaData()[0].getName() : storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(fieldName, this.om.getOMFContext().getTypeManager().isDefaultEmbeddedType(fieldType), 0).getIdentifier();
                        this.fieldColumnNames.add(columnName);
                    }
                    if (!(m instanceof AbstractContainerMapping)) continue;
                    throw new NucleusUserException("Mapping " + m + " not suitable for a NucleusSQL result column, field = " + fieldName).setFatal();
                }
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                throw new NucleusException("Invalid persistence modifier on field " + fieldName).setFatal();
            }
            if (n == 0) {
                throw new NucleusUserException("View class has no persistent fields: " + this.candidateClass.getName()).setFatal();
            }
            this.fieldNumbers = new int[n];
            System.arraycopy(fn, 0, this.fieldNumbers, 0, n);
        }
        this.parameterOccurrences = new ArrayList();
        MacroString ms = new MacroString(this.candidateClass != null ? this.candidateClass.getName() : null, this.candidateClass != null ? this.imports : null, this.inputSQL);
        return ms.substituteMacros(new MacroString.MacroHandler(){

            public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                if (NucleusSQLQuery.this.candidateClass != null) {
                    if (im.className.equals(NucleusSQLQuery.this.candidateClass.getName())) {
                        if (im.fieldName == null) {
                            throw new NucleusUserException(LOCALISER_RDBMS.msg("060004", (Object)im));
                        }
                        if (im.subfieldName != null) {
                            throw new NucleusUserException(LOCALISER_RDBMS.msg("060003", (Object)im.className, (Object)im));
                        }
                        int fieldNumber = candidateCmd.getRelativePositionOfMember(im.fieldName);
                        if (fieldNumber < 0) {
                            throw new NucleusUserException(LOCALISER_RDBMS.msg("060003", (Object)im.className, (Object)im));
                        }
                        im.value = (String)NucleusSQLQuery.this.fieldColumnNames.get(fieldNumber);
                    } else {
                        ((RDBMSManager)NucleusSQLQuery.this.getStoreManager()).resolveIdentifierMacro(im, NucleusSQLQuery.this.om.getClassLoaderResolver());
                    }
                }
            }

            public void onParameterMacro(MacroString.ParameterMacro pm) {
                NucleusSQLQuery.this.parameterOccurrences.add(pm.parameterName);
            }
        }, this.om.getClassLoaderResolver());
    }

    public Object performExecute(Map parameters) {
        this.compileInternal(true, parameters);
        if (parameters.size() != (this.parameterNames != null ? this.parameterNames.length : 0)) {
            throw new NucleusUserException(LOCALISER_RDBMS.msg("060002", (Object)("" + this.parameterNames.length), (Object)("" + parameters.size())));
        }
        NucleusSQLQueryEvaluator eval = new NucleusSQLQueryEvaluator(this, parameters);
        QueryResult qr = (QueryResult)((SQLEvaluator)eval).evaluate(null);
        this.queryResults.add(qr);
        return qr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NucleusSQLQueryEvaluator
    extends SQLEvaluator {
        Map parameters;

        public NucleusSQLQueryEvaluator(Query query, Map parameters) {
            super(query, null, null);
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object evaluate(QueryExpression queryStmt) {
            AbstractRDBMSQueryResult qr = null;
            try {
                RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
                DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
                ManagedConnection mconn = storeMgr.getConnection(this.om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = conn.prepareStatement(NucleusSQLQuery.this.compiledSQL);
                    try {
                        Iterator iter = NucleusSQLQuery.this.parameterOccurrences.iterator();
                        int stmtParamNum = 1;
                        while (iter.hasNext()) {
                            String paramName = (String)iter.next();
                            Class paramType = (Class)NucleusSQLQuery.this.parameterTypesByName.get(paramName);
                            if (!this.parameters.containsKey(paramName)) {
                                throw new NucleusUserException(LOCALISER_RDBMS.msg("060006", (Object)paramName));
                            }
                            if (paramType == null) {
                                throw new NucleusUserException(LOCALISER_RDBMS.msg("060007", (Object)paramName));
                            }
                            JavaTypeMapping mapping = dba.getMapping(paramType, storeMgr, this.om.getClassLoaderResolver());
                            Object paramValue = this.parameters.get(paramName);
                            mapping.setObject(this.om, ps, Mappings.getParametersIndex(stmtParamNum, mapping), paramValue);
                            if (mapping.getNumberOfDatastoreFields() == 0) {
                                ++stmtParamNum;
                                continue;
                            }
                            stmtParamNum += mapping.getNumberOfDatastoreFields();
                        }
                        RDBMSQueryUtils.prepareStatementForExecution(ps, this.query);
                        ResultSet rs = sqlControl.executeStatementQuery(mconn, NucleusSQLQuery.this.compiledSQL, ps);
                        try {
                            Object rof = null;
                            if (NucleusSQLQuery.this.candidateClass != null) {
                                ResultSetMetaData rsmd = rs.getMetaData();
                                HashSet remainingColumnNames = new HashSet(NucleusSQLQuery.this.fieldColumnNames);
                                int colCount = rsmd.getColumnCount();
                                for (int colNum = 1; colNum <= colCount; ++colNum) {
                                    String colName = rsmd.getColumnName(colNum);
                                    int fieldNumber = NucleusSQLQuery.this.fieldColumnNames.indexOf(colName);
                                    if (fieldNumber < 0) continue;
                                    NucleusSQLQuery.this.statementExpressionIndex[fieldNumber].setExpressionIndex(new int[]{colNum});
                                    remainingColumnNames.remove(colName);
                                }
                                if (!remainingColumnNames.isEmpty()) {
                                    throw new NucleusUserException(LOCALISER_RDBMS.msg("060005", remainingColumnNames));
                                }
                                rof = NucleusSQLQuery.this.resultClass != null ? new ResultClassROF(NucleusSQLQuery.this.resultClass, NucleusSQLQuery.this.statementExpressionIndex) : new TransientIDROF(NucleusSQLQuery.this.candidateClass, NucleusSQLQuery.this.fieldNumbers, NucleusSQLQuery.this.statementExpressionIndex);
                            } else {
                                rof = this.getResultObjectFactoryForNoCandidateClass(rs, NucleusSQLQuery.this.resultClass);
                            }
                            String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery(this.query);
                            qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult(null, this.query, (ResultObjectFactory)rof, rs, null) : new ForwardQueryResult(null, this.query, (ResultObjectFactory)rof, rs, null);
                            final ScrollableQueryResult qr1 = qr;
                            final ManagedConnection mconn1 = mconn;
                            mconn.addListener(new ManagedConnectionResourceListener(){

                                public void managedConnectionFlushed() {
                                    qr1.disconnect();
                                }

                                public void managedConnectionPreClose() {
                                }

                                public void managedConnectionPostClose() {
                                }

                                public void resourcePostClose() {
                                    mconn1.removeListener((ManagedConnectionResourceListener)this);
                                }
                            });
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (qr == null) {
                            sqlControl.closeStatement(mconn, ps);
                        }
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("060008", (Object)NucleusSQLQuery.this.compiledSQL), (Throwable)e);
            }
            return qr;
        }
    }
}

