/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.ObjectLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ReferenceExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MultiMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.rdbms.table.ColumnCreator;
import org.datanucleus.util.NucleusLogger;

public abstract class ReferenceMapping
extends MultiMapping
implements MappingCallbacks {
    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        this.numberOfDatastoreFields = 0;
        super.initialize(dba, mmd, container, clr);
        this.createColumns(this.datastoreContainer, mmd, clr);
    }

    protected void createColumns(DatastoreContainerObject datastoreContainer, AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        MappedStoreManager storeMgr = datastoreContainer.getStoreManager();
        if (fmd.getMappedBy() == null) {
            ColumnCreator.createColumnsForFieldUsingReference(this, datastoreContainer, fmd, clr, fmd.isEmbedded() || fmd.getElementMetaData() != null);
        } else {
            InterfaceMetaData refCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForInterface(fmd.getType(), clr);
            JavaTypeMapping referenceMapping = null;
            if (refCmd != null && refCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass((AbstractClassMetaData)refCmd, clr);
                if (cmds != null && cmds.length > 0) {
                    if (cmds.length > 1) {
                        NucleusLogger.PERSISTENCE.warn((Object)("Field " + fmd.getFullFieldName() + " represents either a 1-1 relation, or a N-1 relation where the other end uses" + " \"subclass-table\" inheritance strategy and more than 1 subclasses with a table. " + "This is not fully supported currently"));
                    }
                } else {
                    return;
                }
                referenceMapping = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIDMapping();
            } else {
                String[] implTypes = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(fmd, 2, clr);
                for (int j = 0; j < implTypes.length; ++j) {
                    referenceMapping = storeMgr.getDatastoreClass(implTypes[j], clr).getIDMapping();
                    JavaTypeMapping mapping = this.dba.getMapping(clr.classForName(implTypes[j]), storeMgr);
                    mapping.setReferenceMapping(referenceMapping);
                    this.addJavaTypeMapping(mapping);
                }
            }
        }
    }

    public Class getJavaType() {
        return null;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, value.getClass().getName());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        ReferenceExpression expr = new ReferenceExpression(qs, this, te);
        return expr;
    }

    public void postFetch(StateManager sm) {
    }

    public void postInsert(StateManager sm) {
    }

    public void postUpdate(StateManager sm) {
    }

    public void preDelete(StateManager sm) {
        boolean isDependentElement = this.fmd.isDependent();
        if (!isDependentElement) {
            return;
        }
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (!(mapping instanceof PersistenceCapableMapping)) continue;
            int fieldNumber = this.getFieldMetaData().getAbsoluteFieldNumber();
            sm.getObjectManager().getApiAdapter().isLoaded(sm, fieldNumber);
            Object pc = sm.provideField(fieldNumber);
            if (pc == null) continue;
            sm.replaceField(fieldNumber, null, true);
            sm.getStoreManager().getPersistenceHandler().updateObject(sm, new int[]{fieldNumber});
            sm.getObjectManager().deleteObjectInternal(pc);
        }
    }
}

