/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOContainer;
import org.datanucleus.sco.SCOMap;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MapExpression;
import org.datanucleus.store.mapped.expression.MapLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.NucleusLogger;

public class MapMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    static /* synthetic */ Class class$java$util$Map;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MapMapping sm = (MapMapping)obj;
        return this.fmd.equals(sm.fmd) && ((Object)((Object)this.storeMgr)).equals((Object)sm.storeMgr);
    }

    public Class getJavaType() {
        return class$java$util$Map == null ? (class$java$util$Map = MapMapping.class$("java.util.Map")) : class$java$util$Map;
    }

    public void postInsert(StateManager sm) {
        Map value = (Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting((ObjectManager)sm.getObjectManager(), value.keySet());
                SCOUtils.validateObjectsForWriting((ObjectManager)sm.getObjectManager(), value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (!this.fmd.isCascadePersist()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007006", (Object)this.fmd.getFullFieldName()));
            }
            ApiAdapter api = sm.getObjectManager().getApiAdapter();
            Set entries = value.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (api.isPersistable(entry.getKey()) && !api.isPersistent(entry.getKey()) && !api.isDetached(entry.getKey())) {
                    throw new ReachableObjectNotCascadedException(this.fmd.getFullFieldName(), entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || api.isPersistent(entry.getValue()) || api.isDetached(entry.getValue())) continue;
                throw new ReachableObjectNotCascadedException(this.fmd.getFullFieldName(), entry.getValue());
            }
        } else {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007007", (Object)this.fmd.getFullFieldName()));
            }
            if (value.size() > 0) {
                ((MapStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.fmd, value.getClass())).putAll(sm, value);
                this.replaceFieldWithWrapper(sm, value, false, false);
            } else {
                this.replaceFieldWithWrapper(sm, null, false, false);
            }
        }
    }

    public void postUpdate(StateManager sm) {
        ObjectManager om = sm.getObjectManager();
        Map value = (Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting((ObjectManager)om, value.keySet());
                SCOUtils.validateObjectsForWriting((ObjectManager)om, value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (value instanceof SCOContainer) {
            SCOContainer sco = (SCOContainer)value;
            if (sm.getObject() == sco.getOwner() && this.fieldName.equals(sco.getFieldName())) {
                sco.flush();
                return;
            }
            if (sco.getOwner() != null) {
                throw new NucleusException("Owned second-class object was somehow assigned to a field other than its owner's").setFatal();
            }
        }
        if (!this.fmd.isCascadeUpdate()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007008", (Object)this.fmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007009", (Object)this.fmd.getFullFieldName()));
        }
        MapStore backingStore = (MapStore)this.storeMgr.getBackingStoreForField(om.getClassLoaderResolver(), this.fmd, value.getClass());
        backingStore.clear(sm);
        backingStore.putAll(sm, value);
        this.replaceFieldWithWrapper(sm, value, false, false);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.getObjectManager().getApiAdapter().isLoaded(sm, this.fmd.getAbsoluteFieldNumber());
        Map value = (Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null || value.isEmpty()) {
            return;
        }
        if (!(value instanceof SCO)) {
            value = (Map)sm.wrapSCOField(this.fmd.getAbsoluteFieldNumber(), (Object)value, false, false, true);
        }
        value.clear();
        ((SCOMap)value).flush();
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(JavaTypeMapping.LOCALISER.msg("041025", (Object)this.fmd.getFullFieldName())).setFatal();
        }
        return new MapLiteral(qs, (JavaTypeMapping)this, (Map)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(JavaTypeMapping.LOCALISER.msg("041025", (Object)this.fmd.getFullFieldName())).setFatal();
        }
        return new MapExpression(qs, this.datastoreContainer.getIDMapping(), te, (MapStore)this.storeMgr.getBackingStoreForField(qs.getClassLoaderResolver(), this.fmd, null), this.fieldName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

