/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.exceptions.NoSuchPersistentFieldException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreCollection;
import org.datanucleus.store.mapped.DatastoreContainer;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreElementContainer;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.DatastoreMap;
import org.datanucleus.store.mapped.DatastoreObject;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.Localiser;

public abstract class LogicSetExpression {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)(class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = LogicSetExpression.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected final QueryExpression qs;
    protected final DatastoreContainerObject mainTable;
    protected final DatastoreIdentifier mainAlias;
    protected String sqlText = null;
    protected Map embeddedFieldMappings = null;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    protected LogicSetExpression(QueryExpression qs, DatastoreContainerObject mainTable, DatastoreIdentifier alias) {
        this.qs = qs;
        this.mainTable = mainTable;
        this.mainAlias = alias;
    }

    protected void assertNotFrozen() {
        if (this.sqlText != null) {
            // empty if block
        }
    }

    public final DatastoreObject getMainTable() {
        return this.mainTable;
    }

    public final DatastoreIdentifier getAlias() {
        return this.mainAlias;
    }

    public ScalarExpression newFieldExpression(String fieldName) {
        if (this.mainTable instanceof DatastoreClass) {
            DatastoreClass ct = (DatastoreClass)this.mainTable;
            JavaTypeMapping m = null;
            if (fieldName.equals(this.qs.getCandidateAlias())) {
                m = ct.getIDMapping();
                return m.newScalarExpression(this.qs, this);
            }
            if (fieldName.indexOf(".") > 0) {
                ScalarExpression expr;
                String baseField;
                block22: {
                    baseField = fieldName.substring(0, fieldName.indexOf("."));
                    try {
                        m = ct.getFieldMapping(baseField);
                    }
                    catch (NoSuchPersistentFieldException npfe) {
                        if (this.embeddedFieldMappings != null) {
                            m = (JavaTypeMapping)this.embeddedFieldMappings.get(baseField);
                        }
                        if (m != null) break block22;
                        throw npfe;
                    }
                }
                if (m == null) {
                    throw new NucleusUserException(LOCALISER.msg("037001", (Object)fieldName, (Object)((Object)ct).toString()));
                }
                if (m instanceof EmbeddedPCMapping) {
                    String subField = fieldName.substring(fieldName.indexOf(".") + 1);
                    if ((m = this.getMappingForEmbeddedField((EmbeddedPCMapping)m, subField)) == null) {
                        throw new NucleusUserException(LOCALISER.msg("037002", (Object)fieldName, (Object)subField, (Object)baseField));
                    }
                    if (this.embeddedFieldMappings == null) {
                        this.embeddedFieldMappings = new HashMap();
                    }
                    this.embeddedFieldMappings.put(subField, m);
                }
                if ((expr = m.newScalarExpression(this.qs, this)) instanceof ObjectExpression) {
                    ((ObjectExpression)expr).setFieldDefinition(m.getFieldMetaData().getName(), m.getFieldMetaData().getTypeName());
                }
                return expr;
            }
            m = ct.getFieldMapping(fieldName);
            if (m == null) {
                throw new NucleusUserException(LOCALISER.msg("037001", (Object)fieldName, (Object)((Object)ct).toString()));
            }
            ScalarExpression expr = m.newScalarExpression(this.qs, this);
            if (expr instanceof ObjectExpression) {
                ((ObjectExpression)expr).setFieldDefinition(fieldName, m.getType());
            }
            return expr;
        }
        if (this.mainTable instanceof DatastoreCollection || this.mainTable instanceof DatastoreMap) {
            DatastoreContainer join;
            String fld = fieldName;
            if (fieldName.indexOf(".") > 0) {
                String subField;
                fld = subField = fieldName.substring(fieldName.indexOf(".") + 1);
            }
            if (this.mainTable instanceof DatastoreElementContainer) {
                join = (DatastoreElementContainer)this.mainTable;
                JavaTypeMapping m = join.getElementMapping();
                if (m instanceof EmbeddedElementPCMapping) {
                    JavaTypeMapping fieldMapping = ((EmbeddedMapping)m).getJavaTypeMapping(fld);
                    if (fieldMapping != null) {
                        return fieldMapping.newScalarExpression(this.qs, this);
                    }
                    throw new NucleusUserException("'" + fieldName + "' was not found as a field stored in the join table " + this.mainTable);
                }
            } else if (this.mainTable instanceof DatastoreMap) {
                JavaTypeMapping fieldMapping;
                join = (DatastoreMap)this.mainTable;
                JavaTypeMapping m = join.getKeyMapping();
                if (m instanceof EmbeddedKeyPCMapping && (fieldMapping = ((EmbeddedMapping)m).getJavaTypeMapping(fld)) != null) {
                    return fieldMapping.newScalarExpression(this.qs, this);
                }
                m = join.getValueMapping();
                if (m instanceof EmbeddedValuePCMapping && (fieldMapping = ((EmbeddedMapping)m).getJavaTypeMapping(fld)) != null) {
                    return fieldMapping.newScalarExpression(this.qs, this);
                }
            }
            throw new NucleusUserException("'" + fieldName + "' was not found as an embedded element/key/value field stored in the join table " + this.mainTable);
        }
        throw new NucleusUserException("'" + fieldName + "' can't be referenced in " + this.mainTable.toString() + ": table does not store a persistence-capable class or a join table storing a persistence-capable class");
    }

    private JavaTypeMapping getMappingForEmbeddedField(EmbeddedPCMapping m, String fieldName) {
        if (m == null || fieldName == null) {
            return null;
        }
        if (fieldName.indexOf(".") < 0) {
            return m.getJavaTypeMapping(fieldName);
        }
        String field = fieldName.substring(0, fieldName.indexOf("."));
        String subField = fieldName.substring(fieldName.indexOf(".") + 1);
        JavaTypeMapping mapping = m.getJavaTypeMapping(field);
        if (mapping instanceof EmbeddedPCMapping && subField != null) {
            return this.getMappingForEmbeddedField((EmbeddedPCMapping)mapping, subField);
        }
        return mapping;
    }

    public abstract String referenceColumn(DatastoreField var1);

    public abstract String toString();

    public int hashCode() {
        return this.mainTable.hashCode() ^ this.mainAlias.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicSetExpression)) {
            return false;
        }
        LogicSetExpression expr = (LogicSetExpression)obj;
        return this.mainAlias.equals(expr.mainAlias) && this.mainTable.equals(expr.mainTable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

