/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.DatastoreMap;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.ColumnCreator;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.SCOTable;
import org.datanucleus.store.rdbms.table.TableUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class MapTable
extends JoinTable
implements SCOTable,
DatastoreMap {
    private JavaTypeMapping keyMapping;
    private JavaTypeMapping valueMapping;
    private JavaTypeMapping orderMapping;
    protected Map embeddedKeyMappingsMap;
    protected Map embeddedValueMappingsMap;

    public MapTable(DatastoreIdentifier tableName, AbstractMemberMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, fmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        boolean valuePC;
        boolean keyPC;
        this.assertIsUninitialized();
        MapMetaData mmd = this.fmd.getMap();
        if (mmd == null) {
            throw new NucleusUserException(AbstractTable.LOCALISER.msg("057017", (Object)this.fmd));
        }
        PrimaryKeyMetaData pkmd = this.fmd.getJoinMetaData() != null ? this.fmd.getJoinMetaData().getPrimaryKeyMetaData() : null;
        boolean pkColsSpecified = pkmd != null && pkmd.getColumnMetaData() != null;
        boolean pkRequired = this.requiresPrimaryKey();
        ColumnMetaData[] ownerColmd = null;
        if (this.fmd.getJoinMetaData() != null && this.fmd.getJoinMetaData().getColumnMetaData() != null && this.fmd.getJoinMetaData().getColumnMetaData().length > 0) {
            ownerColmd = this.fmd.getJoinMetaData().getColumnMetaData();
        }
        this.ownerMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(this.ownerType), this.fmd, ownerColmd, this.storeMgr, this, pkRequired, false, false, false, 1, clr);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            this.debugMapping(this.ownerMapping);
        }
        boolean bl = keyPC = this.fmd.hasMap() && this.fmd.getMap().getKeyClassMetaData() != null;
        if (this.isSerialisedKey() || this.isEmbeddedKeyPC() || this.isEmbeddedKey() && !keyPC) {
            this.keyMapping = this.dba.getMappingManager().getMapping(this, this.fmd, this.dba, clr, 3);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.keyMapping);
            }
        } else {
            ColumnMetaData[] keyColmd = null;
            KeyMetaData keymd = this.fmd.getKeyMetaData();
            if (keymd != null && keymd.getColumnMetaData() != null && keymd.getColumnMetaData().length > 0) {
                keyColmd = keymd.getColumnMetaData();
            }
            this.keyMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(mmd.getKeyType()), this.fmd, keyColmd, this.storeMgr, this, false, false, this.fmd.getMap().isSerializedKey(), false, 5, clr);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.keyMapping);
            }
        }
        boolean bl2 = valuePC = this.fmd.hasMap() && this.fmd.getMap().getValueClassMetaData() != null;
        if (this.isSerialisedValue() || this.isEmbeddedValuePC() || this.isEmbeddedValue() && !valuePC) {
            this.valueMapping = this.dba.getMappingManager().getMapping(this, this.fmd, this.dba, clr, 4);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.valueMapping);
            }
        } else {
            ColumnMetaData[] valueColmd = null;
            ValueMetaData valuemd = this.fmd.getValueMetaData();
            if (valuemd != null && valuemd.getColumnMetaData() != null && valuemd.getColumnMetaData().length > 0) {
                valueColmd = valuemd.getColumnMetaData();
            }
            this.valueMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(mmd.getValueType()), this.fmd, valueColmd, this.storeMgr, this, false, true, this.fmd.getMap().isSerializedValue(), false, 6, clr);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.valueMapping);
            }
        }
        boolean orderRequired = false;
        if (this.fmd.getOrderMetaData() != null) {
            orderRequired = true;
        } else if (this.requiresPrimaryKey() && !pkColsSpecified) {
            if (this.isEmbeddedKeyPC()) {
                if (this.fmd.getMap().getKeyClassMetaData().getIdentityType() != IdentityType.APPLICATION) {
                    orderRequired = true;
                }
            } else if (this.isSerialisedKey()) {
                orderRequired = true;
            } else if (this.keyMapping instanceof ReferenceMapping) {
                ReferenceMapping refMapping = (ReferenceMapping)this.keyMapping;
                if (refMapping.getJavaTypeMapping().length > 1) {
                    orderRequired = true;
                }
            } else if (!(this.keyMapping instanceof PersistenceCapableMapping)) {
                Column elementCol = (Column)this.keyMapping.getDataStoreMapping(0).getDatastoreField();
                if (!((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).isValidPrimaryKeyType(elementCol.getJdbcType())) {
                    orderRequired = true;
                }
            }
        }
        if (orderRequired) {
            ColumnMetaData orderColmd = null;
            if (this.fmd.getOrderMetaData() != null && this.fmd.getOrderMetaData().getColumnMetaData() != null && this.fmd.getOrderMetaData().getColumnMetaData().length > 0) {
                orderColmd = this.fmd.getOrderMetaData().getColumnMetaData()[0];
            } else if (this.fmd.hasExtension("adapter-column-name")) {
                orderColmd = new ColumnMetaData((MetaData)this.fmd, this.fmd.getValueForExtension("adapter-column-name"));
            } else {
                DatastoreIdentifier id = ((RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory()).newIndexFieldIdentifier();
                orderColmd = new ColumnMetaData((MetaData)this.fmd, id.getIdentifier());
            }
            this.orderMapping = this.dba.getMapping(Integer.TYPE, this.storeMgr);
            ColumnCreator.createIndexColumn(this.orderMapping, this.storeMgr, clr, this, orderColmd, pkRequired && !pkColsSpecified);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.orderMapping);
            }
        }
        if (pkRequired) {
            if (pkColsSpecified) {
                this.applyUserPrimaryKeySpecification(pkmd);
            } else if (orderRequired) {
                this.orderMapping.getDataStoreMapping(0).getDatastoreField().setAsPrimaryKey();
            } else {
                for (int i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                    this.keyMapping.getDataStoreMapping(i).getDatastoreField().setAsPrimaryKey();
                }
            }
        }
        this.state = 2;
    }

    protected void applyUserPrimaryKeySpecification(PrimaryKeyMetaData pkmd) {
        ColumnMetaData[] pkCols = pkmd.getColumnMetaData();
        for (int i = 0; i < pkCols.length; ++i) {
            int j;
            String colName = pkCols[i].getName();
            boolean found = false;
            for (j = 0; j < this.ownerMapping.getNumberOfDatastoreFields(); ++j) {
                if (!this.ownerMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().getIdentifier().equals(colName)) continue;
                this.ownerMapping.getDataStoreMapping(j).getDatastoreField().setAsPrimaryKey();
                found = true;
            }
            if (!found) {
                for (j = 0; j < this.keyMapping.getNumberOfDatastoreFields(); ++j) {
                    if (!this.keyMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().getIdentifier().equals(colName)) continue;
                    this.keyMapping.getDataStoreMapping(j).getDatastoreField().setAsPrimaryKey();
                    found = true;
                }
            }
            if (!found) {
                for (j = 0; j < this.valueMapping.getNumberOfDatastoreFields(); ++j) {
                    if (!this.valueMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().getIdentifier().equals(colName)) continue;
                    this.valueMapping.getDataStoreMapping(j).getDatastoreField().setAsPrimaryKey();
                    found = true;
                }
            }
            if (found) continue;
            throw new NucleusUserException(AbstractTable.LOCALISER.msg("057040", (Object)this.toString(), (Object)colName));
        }
    }

    public boolean isEmbeddedKey() {
        if (this.fmd.getMap() != null && this.fmd.getMap().isSerializedKey()) {
            return false;
        }
        return this.fmd.getMap() != null && this.fmd.getMap().isEmbeddedKey();
    }

    public boolean isSerialisedKey() {
        return this.fmd.getMap() != null && this.fmd.getMap().isSerializedKey();
    }

    public boolean isSerialisedKeyPC() {
        return this.fmd.getMap() != null && this.fmd.getMap().isSerializedKey() && this.fmd.getMap().getKeyClassMetaData() != null;
    }

    public boolean isEmbeddedKeyPC() {
        if (this.fmd.getMap() != null && this.fmd.getMap().isSerializedKey()) {
            return false;
        }
        return this.fmd.getKeyMetaData() != null && this.fmd.getKeyMetaData().getEmbeddedMetaData() != null;
    }

    public boolean isEmbeddedValue() {
        if (this.fmd.getMap() != null && this.fmd.getMap().isSerializedValue()) {
            return false;
        }
        return this.fmd.getMap() != null && this.fmd.getMap().isEmbeddedValue();
    }

    public boolean isSerialisedValue() {
        return this.fmd.getMap() != null && this.fmd.getMap().isSerializedValue();
    }

    public boolean isSerialisedValuePC() {
        return this.fmd.getMap() != null && this.fmd.getMap().isSerializedValue() && this.fmd.getMap().getValueClassMetaData() != null;
    }

    public boolean isEmbeddedValuePC() {
        if (this.fmd.getMap() != null && this.fmd.getMap().isSerializedValue()) {
            return false;
        }
        return this.fmd.getValueMetaData() != null && this.fmd.getValueMetaData().getEmbeddedMetaData() != null;
    }

    public JavaTypeMapping getKeyMapping() {
        this.assertIsInitialized();
        return this.keyMapping;
    }

    public JavaTypeMapping getValueMapping() {
        this.assertIsInitialized();
        return this.valueMapping;
    }

    public String getKeyType() {
        return this.fmd.getMap().getKeyType();
    }

    public String getValueType() {
        return this.fmd.getMap().getValueType();
    }

    public JavaTypeMapping getOrderMapping() {
        this.assertIsInitialized();
        return this.orderMapping;
    }

    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        try {
            ForeignKey fk;
            Collection fks;
            AbstractMemberMetaData embFmd;
            JavaTypeMapping embFieldMapping;
            EmbeddedMapping embMapping;
            ForeignKey fk2;
            ForeignKeyMetaData fkmd;
            DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(this.ownerType, clr);
            if (referencedTable != null) {
                fkmd = null;
                if (this.fmd.getJoinMetaData() != null) {
                    fkmd = this.fmd.getJoinMetaData().getForeignKeyMetaData();
                }
                if (fkmd != null || autoMode) {
                    fk2 = new ForeignKey(this.ownerMapping, this.dba, referencedTable, true);
                    fk2.setForMetaData(fkmd);
                    foreignKeys.add(fk2);
                }
            }
            if (!this.isSerialisedValuePC()) {
                if (this.isEmbeddedValuePC()) {
                    embMapping = (EmbeddedValuePCMapping)this.valueMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        embFieldMapping = embMapping.getJavaTypeMapping(i);
                        embFmd = embFieldMapping.getFieldMetaData();
                        if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreFields() <= 0 || !(embFieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk);
                    }
                } else if (this.fmd.getMap().getValueClassMetaData() != null && (referencedTable = this.storeMgr.getDatastoreClass(this.fmd.getMap().getValueType(), clr)) != null) {
                    fkmd = null;
                    if (this.fmd.getValueMetaData() != null) {
                        fkmd = this.fmd.getValueMetaData().getForeignKeyMetaData();
                    }
                    if (fkmd != null || autoMode) {
                        fk2 = new ForeignKey(this.valueMapping, this.dba, referencedTable, true);
                        fk2.setForMetaData(fkmd);
                        foreignKeys.add(fk2);
                    }
                }
            }
            if (!this.isSerialisedKeyPC()) {
                if (this.isEmbeddedKeyPC()) {
                    embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        embFieldMapping = embMapping.getJavaTypeMapping(i);
                        embFmd = embFieldMapping.getFieldMetaData();
                        if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreFields() <= 0 || !(embFieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk);
                    }
                } else if (this.fmd.getMap().getKeyClassMetaData() != null && (referencedTable = this.storeMgr.getDatastoreClass(this.fmd.getMap().getKeyType(), clr)) != null) {
                    fkmd = null;
                    if (this.fmd.getKeyMetaData() != null) {
                        fkmd = this.fmd.getKeyMetaData().getForeignKeyMetaData();
                    }
                    if (fkmd != null || autoMode) {
                        fk2 = new ForeignKey(this.keyMapping, this.dba, referencedTable, true);
                        fk2.setForMetaData(fkmd);
                        foreignKeys.add(fk2);
                    }
                }
            }
        }
        catch (NoTableManagedException e) {
            // empty catch block
        }
        return foreignKeys;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        Index index;
        IndexMetaData imd;
        JavaTypeMapping embFieldMapping;
        int i;
        EmbeddedMapping embMapping;
        Set indices = super.getExpectedIndices(clr);
        if (this.keyMapping instanceof EmbeddedKeyPCMapping) {
            embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                imd = embFieldMapping.getFieldMetaData().getIndexMetaData();
                if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index);
            }
        }
        if (this.valueMapping instanceof EmbeddedValuePCMapping) {
            embMapping = (EmbeddedValuePCMapping)this.valueMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                imd = embFieldMapping.getFieldMetaData().getIndexMetaData();
                if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    protected List getExpectedCandidateKeys() {
        CandidateKey ck;
        UniqueMetaData umd;
        JavaTypeMapping embFieldMapping;
        int i;
        EmbeddedMapping embMapping;
        List candidateKeys = super.getExpectedCandidateKeys();
        if (this.keyMapping instanceof EmbeddedKeyPCMapping) {
            embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                umd = embFieldMapping.getFieldMetaData().getUniqueMetaData();
                if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck);
            }
        }
        if (this.valueMapping instanceof EmbeddedValuePCMapping) {
            embMapping = (EmbeddedValuePCMapping)this.valueMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                umd = embFieldMapping.getFieldMetaData().getUniqueMetaData();
                if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck);
            }
        }
        return candidateKeys;
    }

    public JavaTypeMapping getFieldMapping(AbstractMemberMetaData fmd) {
        return null;
    }
}

