/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.valuegenerator;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.util.Localiser;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Result;

public class IncrementGenerator
extends AbstractConnectedGenerator<Long> {
    protected static final String INCREMENT_INDEX = "DN_INCREMENT_INDEX";
    protected static final String INCREMENT_NAME = "INCREMENT_NAME";
    protected static final String INCREMENT_VALUE_PROPERTY = "INCREMENT_VAL";

    public IncrementGenerator(StoreManager storeMgr, String name, Properties props) {
        super(storeMgr, name, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueGenerationBlock<Long> reserveBlock(long size) {
        ArrayList<Long> oids = new ArrayList<Long>();
        try {
            ManagedConnection mconn = this.connectionProvider.retrieveConnection();
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            Node generatorNode = null;
            if (db.index().existsForNodes(INCREMENT_INDEX)) {
                String cypherStr = "START n=node:DN_INCREMENT_INDEX(INCREMENT_NAME=\"" + this.name + "\") RETURN n";
                Result queryResult = db.execute(cypherStr);
                if (queryResult.hasNext()) {
                    Map map = queryResult.next();
                    generatorNode = (Node)map.get("n");
                }
                queryResult.close();
            }
            if (generatorNode == null) {
                if (!this.storeMgr.getSchemaHandler().isAutoCreateTables()) {
                    throw new NucleusUserException(Localiser.msg((String)"040011", (Object[])new Object[]{this.name}));
                }
                generatorNode = db.createNode();
                generatorNode.setProperty(INCREMENT_VALUE_PROPERTY, (Object)0L);
                db.index().forNodes(INCREMENT_INDEX).add((PropertyContainer)generatorNode, INCREMENT_NAME, (Object)this.name);
            }
            long number = (Long)generatorNode.getProperty(INCREMENT_VALUE_PROPERTY);
            int i = 0;
            while ((long)i < size) {
                oids.add(++number);
                ++i;
            }
            generatorNode.setProperty(INCREMENT_VALUE_PROPERTY, (Object)number);
        }
        finally {
            this.connectionProvider.releaseConnection();
        }
        return new ValueGenerationBlock(oids);
    }
}

