/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.fieldmanager;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.ClassUtils;
import org.neo4j.graphdb.PropertyContainer;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public StoreEmbeddedFieldManager(ObjectProvider op, PropertyContainer propObj, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(op, propObj, insert, table);
        this.mmds = mmds;
    }

    public StoreEmbeddedFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, PropertyContainer propObj, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(ec, cmd, propObj, insert, table);
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractMemberMetaData lastMmd = this.mmds.get(this.mmds.size() - 1);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            ObjectProvider[] ownerOPs;
            if (this.op != null && (ownerOPs = this.ec.getOwnersForEmbeddedObjectProvider(this.op)) != null && ownerOPs.length == 1 && value != ownerOPs[0].getObject()) {
                this.op.replaceField(fieldNumber, ownerOPs[0].getObject());
            }
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, lastMmd) && RelationType.isRelationSingleValued((RelationType)relationType)) {
            AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            if (embCmd == null) {
                throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
            }
            if (RelationType.isBidirectional((RelationType)relationType)) {
                // empty if block
            }
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
            embMmds.add(mmd);
            if (value == null) {
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(ec, embCmd, this.propObj, this.insert, embMmds, this.table);
                for (int i = 0; i < embMmdPosns.length; ++i) {
                    AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                    if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                        ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                        colEmbMmds.add(embMmd);
                        MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                        this.propObj.removeProperty(mapping.getColumn(0).getName());
                        continue;
                    }
                    if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                    storeEmbFM.storeObjectField(embMmdPosns[i], null);
                }
                return;
            }
            ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
            StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.propObj, this.insert, embMmds, this.table);
            embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
            return;
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }
}

